/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest;", "", "annotationEquality", "", "jp", "Lorg/openrewrite/java/JavaParser;", "assignEquality", "fieldAccessEquality", "fullyQualifiedReference", "identEquality", "literalEquality", "noArgumentsTest", "tagAnnotationEquality", "typeEqualityDependsOnlyOnFqn", "Companion", "rewrite-test"})
public interface SemanticallyEqualTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.SemanticallyEqualTest$Companion.$$INSTANCE;

    @Test
    public void fullyQualifiedReference(@NotNull JavaParser var1);

    @Test
    public void noArgumentsTest(@NotNull JavaParser var1);

    @Test
    public void tagAnnotationEquality(@NotNull JavaParser var1);

    @Test
    public void annotationEquality(@NotNull JavaParser var1);

    @Test
    public void identEquality(@NotNull JavaParser var1);

    @Test
    public void fieldAccessEquality(@NotNull JavaParser var1);

    @Test
    public void assignEquality(@NotNull JavaParser var1);

    @Test
    public void literalEquality(@NotNull JavaParser var1);

    @Test
    public void typeEqualityDependsOnlyOnFqn(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest$Companion;", "", "()V", "annotInterface", "", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String annotInterface = "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void fullyQualifiedReference(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String mcAnnoClass = "\n                package org.mco.anno;\n                public @interface McAnno {}\n            ";
            JavaParser j = JavaParser.fromJavaVersion().dependsOn((Collection)Collections.singletonList(Parser.Input.fromString((String)mcAnnoClass))).build();
            String[] stringArray = new String[]{"\n                import org.mco.anno.McAnno;\n                @McAnno\n                class M {}\n                @org.mco.anno.McAnno\n                class N {}\n            "};
            List cu1 = j.parse(stringArray);
            J.Annotation c1Anno = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu1.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            J.Annotation c2Anno = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu1.get(0)).getClasses().get(1)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)c2Anno), (J)((J)c2Anno))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)c1Anno), (J)((J)c2Anno))).isTrue();
        }

        @Test
        public static void noArgumentsTest(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @NoArgAnnotation1\n                class A {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            List cu2 = jp.parse(stringArray);
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            jp.reset();
            String[] stringArray2 = new String[]{"\n                @NoArgAnnotation2\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray2).get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            jp.reset();
            String[] stringArray3 = new String[]{"\n                @NoArgAnnotation2\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            J.Annotation thirdAnnot = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray3).get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isFalse();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)secondAnnot), (J)((J)thirdAnnot))).isTrue();
        }

        @Test
        public static void tagAnnotationEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @Tag(FastTests.class)\n                @Tag(FastTests.class)\n                @Tag(SlowTests.class)\n                class A {}\n            ", "\n                @interface Tags {\n                    Tag[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Tags.class)\n                @interface Tag {\n                    Class value();\n                }\n            ", "public interface FastTests {}", "public interface SlowTests {}"};
            List cu2 = jp.parse(stringArray);
            J.Annotation fastTest = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            J.Annotation fastTest2 = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(1);
            J.Annotation slowTest = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)fastTest2))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)slowTest))).isFalse();
        }

        @Test
        public static void annotationEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class A {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            List cu2 = jp.parse(stringArray);
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            jp.reset();
            String[] stringArray2 = new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray2).get(0)).getClasses().get(0)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isTrue();
        }

        @Test
        public static void identEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"};
            List cu2 = jp.parse(stringArray);
            NameTree firstIdent = ((J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0)).getAnnotationType();
            J.Identifier secondIdent = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"MyAnnotation", (JavaType)JavaType.buildType((String)"MyAnnotation"));
            J.Identifier thirdIdent = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"YourAnnotation", (JavaType)JavaType.buildType((String)"YourAnnotation"));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)secondIdent))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)thirdIdent))).isFalse();
        }

        @Test
        public static void fieldAccessEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @Category(FastTest.class)\n                @Category(SlowTest.class)\n                class A {\n                }\n            ", "\n                @interface Categories {\n                    Category[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Categories.class)\n                @interface Category {\n                    Class value();\n                }\n            ", "class FastTest {}", "class SlowTest {}"};
            List cu2 = jp.parse(stringArray);
            List list = ((J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Expression firstFieldAccess = (Expression)CollectionsKt.first((List)list);
            J.FieldAccess secondFieldAccess = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"FastTest", (JavaType)((JavaType)JavaType.Class.build((String)"FastTest"))), new JLeftPadded(Space.EMPTY, (Object)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"class", null), Markers.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"));
            List list2 = ((J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(1)).getArguments();
            Intrinsics.checkNotNull((Object)list2);
            Expression thirdFieldAccess = (Expression)CollectionsKt.first((List)list2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)secondFieldAccess))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)thirdFieldAccess))).isFalse();
        }

        @Test
        public static void assignEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"};
            List cu2 = jp.parse(stringArray);
            List list = ((J.Annotation)((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Expression firstAssign = (Expression)CollectionsKt.first((List)list);
            J.Assignment secondAssign = new J.Assignment(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"value", null), new JLeftPadded(Space.format((String)" "), (Object)new J.Literal(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, (Object)true, "true", null, JavaType.Primitive.Boolean), Markers.EMPTY), (JavaType)JavaType.Primitive.Boolean);
            Expression expression = secondAssign.getVariable();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            }
            J.Assignment thirdAssign = secondAssign.withVariable((Expression)((J.Identifier)expression).withName("otherValue"));
            Expression expression2 = secondAssign.getAssignment();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Assignment fourthAssign = secondAssign.withAssignment((Expression)((J.Literal)expression2).withValue((Object)false));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)secondAssign))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)thirdAssign))).isFalse();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)fourthAssign))).isFalse();
        }

        @Test
        public static void literalEquality(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                class A {\n                    int i = 0;\n                    String str = \"thisString\";\n                    String str2 = null;\n                }\n            "};
            List cu2 = jp.parse(stringArray);
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression intLiteral = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0)).getInitializer();
            Object e2 = ((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression strLiteral = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Object e3 = ((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getBody().getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression nullLiteral = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e3).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)intLiteral);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)intLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", null, JavaType.Primitive.Int)))).isTrue();
            Intrinsics.checkNotNull((Object)strLiteral);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)strLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)"thisString", "thisString", null, JavaType.Primitive.String)))).isTrue();
            Intrinsics.checkNotNull((Object)nullLiteral);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)nullLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, "null", null, JavaType.Primitive.String)))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)strLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", null, JavaType.Primitive.Int)))).isFalse();
        }

        @Test
        public static void typeEqualityDependsOnlyOnFqn(@NotNull SemanticallyEqualTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.Identifier nameA2 = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"name", (JavaType)((JavaType)new JavaType.FullyQualified(){

                public boolean deepEquals(@Nullable JavaType type) {
                    return false;
                }

                @NotNull
                public String getFullyQualifiedName() {
                    return "org.foo.Bar";
                }
            }));
            boolean bl = false;
            bl = false;
            bl = false;
            J.Identifier nameB = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"name", (JavaType)((JavaType)JavaType.Class.build(Collections.singleton(Flag.Public), (String)"org.foo.Bar", (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.listOf((Object)JavaType.Class.build((String)"org.foo.Baz")), (List)CollectionsKt.emptyList(), null, null)));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)nameA2), (J)((J)nameB))).isTrue();
        }
    }
}

