/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.RenameVariableTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/RenameVariableTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "doNotChangeToJavaKeyword", "", "jp", "Lorg/openrewrite/java/JavaParser;", "doNotRenameForLoopVariables", "doNotRenameInnerClassVariables", "doNotRenameVariablesInLambda", "renameCatchWithTryResource", "renameCatchWithoutResource", "renameForLoopVariables", "renameInnerClassVariables", "renameMethodVariables", "renameSwitchCases", "renameTry", "renameVariable", "renameVariableTest", "Lorg/openrewrite/Recipe;", "targetClassName", "", "hasName", "toName", "renameVariablesInLambda", "rewrite-test"})
public interface RenameVariableTest
extends JavaRecipeTest {
    @NotNull
    public Recipe renameVariableTest(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @Test
    public void doNotChangeToJavaKeyword(@NotNull JavaParser var1);

    @Test
    public void doNotRenameForLoopVariables(@NotNull JavaParser var1);

    @Test
    public void renameForLoopVariables(@NotNull JavaParser var1);

    @Test
    public void doNotRenameInnerClassVariables(@NotNull JavaParser var1);

    @Test
    public void renameInnerClassVariables(@NotNull JavaParser var1);

    @Test
    public void renameTry(@NotNull JavaParser var1);

    @Test
    public void renameCatchWithoutResource(@NotNull JavaParser var1);

    @Test
    public void renameCatchWithTryResource(@NotNull JavaParser var1);

    @Test
    public void renameVariablesInLambda(@NotNull JavaParser var1);

    @Test
    public void doNotRenameVariablesInLambda(@NotNull JavaParser var1);

    @Test
    public void renameSwitchCases(@NotNull JavaParser var1);

    @Test
    public void renameMethodVariables(@NotNull JavaParser var1);

    @Test
    public void renameVariable(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe renameVariableTest(@NotNull RenameVariableTest this_, @NotNull String targetClassName, @NotNull String hasName, @NotNull String toName) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)targetClassName, (String)"targetClassName");
            Intrinsics.checkNotNullParameter((Object)hasName, (String)"hasName");
            Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
            return this_.toRecipe((Function0)new Function0<TreeVisitor<?, ExecutionContext>>(targetClassName, hasName, toName){
                final /* synthetic */ String $targetClassName;
                final /* synthetic */ String $hasName;
                final /* synthetic */ String $toName;
                {
                    this.$targetClassName = $targetClassName;
                    this.$hasName = $hasName;
                    this.$toName = $toName;
                    super(0);
                }

                @NotNull
                public final TreeVisitor<?, ExecutionContext> invoke() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(this.$targetClassName, this.$hasName, this.$toName){
                        final /* synthetic */ String $targetClassName;
                        final /* synthetic */ String $hasName;
                        final /* synthetic */ String $toName;
                        {
                            this.$targetClassName = $targetClassName;
                            this.$hasName = $hasName;
                            this.$toName = $toName;
                        }

                        @NotNull
                        public J visitClassDeclaration(@NotNull J.ClassDeclaration classDecl2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)classDecl2, (String)"classDecl");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            if (classDecl2.getSimpleName().equals(this.$targetClassName)) {
                                List<T> variableDecls = classDecl2.getBody().getStatements().stream().filter(renameVariableTest.1::visitClassDeclaration$lambda-0).map(renameVariableTest.1::visitClassDeclaration$lambda-1).collect(Collectors.toList());
                                boolean bl = false;
                                List namedVariables = new ArrayList<E>();
                                Intrinsics.checkNotNullExpressionValue(variableDecls, (String)"variableDecls");
                                Iterable $this$forEach$iv = variableDecls;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    J.VariableDeclarations it = (J.VariableDeclarations)element$iv;
                                    boolean bl2 = false;
                                    List list = it.getVariables();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.variables");
                                    namedVariables.addAll(list);
                                }
                                for (J.VariableDeclarations.NamedVariable namedVariable : namedVariables) {
                                    if (!namedVariable.getSimpleName().equals(this.$hasName)) continue;
                                    this.doAfterVisit((TreeVisitor)new RenameVariable(namedVariable, this.$toName));
                                }
                            }
                            J j = super.visitClassDeclaration(classDecl2, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitClassDeclaration(classDecl, p)");
                            return j;
                        }

                        private static final boolean visitClassDeclaration$lambda-0(Statement s) {
                            return s instanceof J.VariableDeclarations;
                        }

                        private static final J.VariableDeclarations visitClassDeclaration$lambda-1(Statement s) {
                            if (s == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
                            }
                            return (J.VariableDeclarations)s;
                        }
                    };
                }
            });
        }

        @Test
        public static void doNotChangeToJavaKeyword(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.renameVariableTest("A", "val", "int"), "\n            package org.openrewrite;\n\n            public class A {\n                int fooA() {\n                    val++;\n                    // creates new scope owned by for loop.\n                    for (int val = 0; val < 10; ++val) {\n                        int x = val + 1;\n                    }\n                    val++;\n                }\n                // val is scoped to classDeclaration regardless of statement order.\n                public int val = 1;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void doNotRenameForLoopVariables(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                int fooA() {\n                    val++;\n                    // creates new scope owned by for loop.\n                    for (int val = 0; val < 10; ++val) {\n                        int x = val + 1;\n                    }\n                    val++;\n                }\n                // val is scoped to classDeclaration regardless of statement order.\n                public int val = 1;\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                int fooA() {\n                    VALUE++;\n                    // creates new scope owned by for loop.\n                    for (int val = 0; val < 10; ++val) {\n                        int x = val + 1;\n                    }\n                    VALUE++;\n                }\n                // val is scoped to classDeclaration regardless of statement order.\n                public int VALUE = 1;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameForLoopVariables(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                int fooA() {\n                    // refers to class declaration scope.\n                    for (val = 0; val < 10; ++val) {\n                        int x = val + 1;\n                        int val = 10;\n                        val++;\n                    }\n                }\n                // val is scoped to classDeclaration regardless of statement order.\n                public int val = 1;\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                int fooA() {\n                    // refers to class declaration scope.\n                    for (VALUE = 0; VALUE < 10; ++VALUE) {\n                        int x = VALUE + 1;\n                        int val = 10;\n                        val++;\n                    }\n                }\n                // val is scoped to classDeclaration regardless of statement order.\n                public int VALUE = 1;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotRenameInnerClassVariables(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                // Scoped to ClassDeclaration regardless of statement order.\n                public int val = 1;\n\n                class X {\n                    int val = 0;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                // Scoped to ClassDeclaration regardless of statement order.\n                public int VALUE = 1;\n\n                class X {\n                    int val = 0;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameInnerClassVariables(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                public int val = 0;\n\n                class X {\n                    int foo() {\n                        val = 10;\n                        return val;\n                    }\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                public int VALUE = 0;\n\n                class X {\n                    int foo() {\n                        VALUE = 10;\n                        return VALUE;\n                    }\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameTry(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            import java.io.FileInputStream;\n            import java.io.FileDescriptor;\n\n            public class A {\n                public int val = 0;\n\n                int foo() {\n                    try (FileInputStream fs = new FileInputStream(\"file\")) {\n                        FileDescriptor fd = fs.getFD();\n                        val++;\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + val, ex);\n                    }\n                    return val;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            import java.io.FileInputStream;\n            import java.io.FileDescriptor;\n\n            public class A {\n                public int VALUE = 0;\n\n                int foo() {\n                    try (FileInputStream fs = new FileInputStream(\"file\")) {\n                        FileDescriptor fd = fs.getFD();\n                        VALUE++;\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + VALUE, ex);\n                    }\n                    return VALUE;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameCatchWithoutResource(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            import java.io.FileDescriptor;\n            import java.io.FileInputStream;\n\n            public class A {\n                public int val = 0;\n\n                int foo() {\n                    try {\n                        val++;\n                        String val = \"1234\";\n                        Integer.valueOf(val);\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + val, ex);\n                    }\n                    return val;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            import java.io.FileDescriptor;\n            import java.io.FileInputStream;\n\n            public class A {\n                public int VALUE = 0;\n\n                int foo() {\n                    try {\n                        VALUE++;\n                        String val = \"1234\";\n                        Integer.valueOf(val);\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + VALUE, ex);\n                    }\n                    return VALUE;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameCatchWithTryResource(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            import java.io.FileDescriptor;\n            import java.io.FileInputStream;\n\n            public class A {\n                public int val = 0;\n\n                int foo() {\n                    FileDescriptor fd;\n                    try (FileInputStream val = new FileInputStream(\"file\")) {\n                        fd = val.getFD();\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + val, ex);\n                    }\n                    return fd.hashCode();\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            import java.io.FileDescriptor;\n            import java.io.FileInputStream;\n\n            public class A {\n                public int VALUE = 0;\n\n                int foo() {\n                    FileDescriptor fd;\n                    try (FileInputStream val = new FileInputStream(\"file\")) {\n                        fd = val.getFD();\n                    } catch (Exception ex) {\n                        throw new RuntimeException(\"\" + VALUE, ex);\n                    }\n                    return fd.hashCode();\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameVariablesInLambda(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            import java.util.function.BiFunction;\n\n            public class A {\n                public Integer val = 1;\n\n                int onlyChangeInScope() {\n                    BiFunction<String, Integer, Integer> x = (String k, Integer v) -> \n                    val == null ? 42 : val + 41;\n\n                    // Class scope.\n                    val = 10;\n                    // Method scope.\n                    int val = 10;\n                    return val;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            import java.util.function.BiFunction;\n\n            public class A {\n                public Integer VALUE = 1;\n\n                int onlyChangeInScope() {\n                    BiFunction<String, Integer, Integer> x = (String k, Integer v) -> \n                    VALUE == null ? 42 : VALUE + 41;\n\n                    // Class scope.\n                    VALUE = 10;\n                    // Method scope.\n                    int val = 10;\n                    return val;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotRenameVariablesInLambda(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            import java.util.function.BiFunction;\n\n            public class A {\n                public Integer val = 1;\n\n                int onlyChangeInScope() {\n                    BiFunction<String, Integer, Integer> x = (String k, Integer val) -> \n                    val == null ? 42 : val + 41;\n\n                    // Class scope.\n                    val = 10;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            import java.util.function.BiFunction;\n\n            public class A {\n                public Integer VALUE = 1;\n\n                int onlyChangeInScope() {\n                    BiFunction<String, Integer, Integer> x = (String k, Integer val) -> \n                    val == null ? 42 : val + 41;\n\n                    // Class scope.\n                    VALUE = 10;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameSwitchCases(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                public int val = 1;\n\n                int newScopeDoNotChange() {\n                    switch (val) {\n                        case 1:\n                            val++;\n                            break;\n                        case 2:\n                            int val = 100;\n                            val += 2;\n                            break;\n                        case 3:\n                            val = 0;\n                            break;\n                        default:\n                            break;\n                    }\n                    return val;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                public int VALUE = 1;\n\n                int newScopeDoNotChange() {\n                    switch (VALUE) {\n                        case 1:\n                            VALUE++;\n                            break;\n                        case 2:\n                            int val = 100;\n                            val += 2;\n                            break;\n                        case 3:\n                            VALUE = 0;\n                            break;\n                        default:\n                            break;\n                    }\n                    return VALUE;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameMethodVariables(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.renameVariableTest("A", "val", "VALUE"), "\n            package org.openrewrite;\n\n            public class A {\n                public int val = 1;\n\n                int newScopeDoNotChange(int val) {\n                    return val;\n                }\n                int onlyChangeInScope() {\n                    // Class scope.\n                    val = 10;\n                    // Method scope.\n                    int val = 10;\n                    return val;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                public int VALUE = 1;\n\n                int newScopeDoNotChange(int val) {\n                    return val;\n                }\n                int onlyChangeInScope() {\n                    // Class scope.\n                    VALUE = 10;\n                    // Method scope.\n                    int val = 10;\n                    return val;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void renameVariable(@NotNull RenameVariableTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(renameVariable.1.INSTANCE), "\n            public class B {\n                int n;\n            \n                {\n                    n++; // do not change.\n                    int n;\n                    n = 1;\n                    n /= 2;\n                    if(n + 1 == 2) {}\n                    n++;\n                }\n               \n                public int foo(int n) {\n                    return n + this.n;\n                }\n            }\n        ", null, "\n            public class B {\n                int n;\n            \n                {\n                    n++; // do not change.\n                    int n1;\n                    n1 = 1;\n                    n1 /= 2;\n                    if(n1 + 1 == 2) {}\n                    n1++;\n                }\n               \n                public int foo(int n2) {\n                    return n2 + this.n;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        public static void assertChangedBase(@NotNull RenameVariableTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RenameVariableTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RenameVariableTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull RenameVariableTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RenameVariableTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RenameVariableTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull RenameVariableTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull RenameVariableTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RenameVariableTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull RenameVariableTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RenameVariableTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RenameVariableTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull RenameVariableTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

