/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.NeedBraces;
import org.openrewrite.java.cleanup.NeedBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u000b\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\r\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u000e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/cleanup/NeedBracesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "addBraces", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "allowEmptyLoopBody", "allowSingleLineStatement", "allowSingleLineStatementInSwitch", "doNotAllowLoopsWithEmptyBodyWhenSingleLineStatementAreAllowed", "initializeStyleWhenOtherwiseNotProvided", "namedStyles", "", "Lorg/openrewrite/style/NamedStyles;", "styles", "", "Lorg/openrewrite/style/Style;", "rewrite-test"})
public interface NeedBracesTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @NotNull
    public Iterable<NamedStyles> namedStyles(@NotNull Collection<? extends Style> var1);

    @Test
    public void addBraces(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void allowEmptyLoopBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void allowSingleLineStatement(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void doNotAllowLoopsWithEmptyBodyWhenSingleLineStatementAreAllowed(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void allowSingleLineStatementInSwitch(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void initializeStyleWhenOtherwiseNotProvided(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new NeedBraces();
        }

        @NotNull
        public static Iterable<NamedStyles> namedStyles(@NotNull NeedBracesTest this_, @NotNull Collection<? extends Style> styles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            return CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "Test", "test", "test", SetsKt.emptySet(), styles));
        }

        @Test
        public static void addBraces(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles(this_.namedStyles(CollectionsKt.listOf((Object)new NeedBracesStyle(Boolean.valueOf(false), Boolean.valueOf(false))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(namedStyles(listOf(NeedBracesStyle(false, false)))).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                static void addToWhile() {\n                    while (true) ;\n                }\n\n                static void addToWhileWithBody() {\n                    while (true) return;\n                }\n\n                static void addToIf(int n) {\n                    if (n == 1) return;\n                }\n\n                static void addToIfElse(int n) {\n                    if (n == 1) return;\n                    else return;\n                }\n\n                static void addToIfElseIfElse(int n) {\n                    if (n == 1) return;\n                    else if (n == 2) return;\n                    else return;\n                }\n\n                static void addToDoWhile(Object obj) {\n                    do obj.notify(); while (true);\n                }\n\n                static void addToIterativeFor(Object obj) {\n                    for (int i = 0; ; ) obj.notify();\n                }\n            }\n        ", null, "\n            class Test {\n                static void addToWhile() {\n                    while (true) {\n                    }\n                }\n\n                static void addToWhileWithBody() {\n                    while (true) {\n                        return;\n                    }\n                }\n\n                static void addToIf(int n) {\n                    if (n == 1) {\n                        return;\n                    }\n                }\n\n                static void addToIfElse(int n) {\n                    if (n == 1) {\n                        return;\n                    }\n                    else {\n                        return;\n                    }\n                }\n\n                static void addToIfElseIfElse(int n) {\n                    if (n == 1) {\n                        return;\n                    }\n                    else if (n == 2) {\n                        return;\n                    }\n                    else {\n                        return;\n                    }\n                }\n\n                static void addToDoWhile(Object obj) {\n                    do {\n                        obj.notify();\n                    } while (true);\n                }\n\n                static void addToIterativeFor(Object obj) {\n                    for (int i = 0; ; ) {\n                        obj.notify();\n                    }\n                }\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void allowEmptyLoopBody(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles(this_.namedStyles(CollectionsKt.listOf((Object)new NeedBracesStyle(Boolean.valueOf(false), Boolean.valueOf(true))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(namedStyles(listOf(NeedBracesStyle(false, true)))).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                static void emptyWhile() {\n                    while (true) ;\n                }\n\n                static void emptyForIterative() {\n                    for (int i = 0; i < 10; i++) ;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void allowSingleLineStatement(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles(this_.namedStyles(CollectionsKt.listOf((Object)new NeedBracesStyle(Boolean.valueOf(true), Boolean.valueOf(false))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(namedStyles(listOf(NeedBracesStyle(true, false)))).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                static void allowIf(int n) {\n                    if (n == 1) return;\n                }\n\n                static void allowIfElse(int n) {\n                    if (n == 1) return;\n                    else return;\n                }\n\n                static void allowIfElseIfElse(int n) {\n                    if (n == 1) return;\n                    else if (n == 2) return;\n                    else return;\n                }\n\n                static void allowWhileWithBody() {\n                    while (true) return;\n                }\n\n                static void allowDoWhileWithBody(Object obj) {\n                    do obj.notify(); while (true);\n                }\n\n                static void allowForIterativeWithBody(Object obj) {\n                    for (int i = 0; ; ) obj.notify();\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void doNotAllowLoopsWithEmptyBodyWhenSingleLineStatementAreAllowed(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles(this_.namedStyles(CollectionsKt.listOf((Object)new NeedBracesStyle(Boolean.valueOf(true), Boolean.valueOf(false))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(namedStyles(listOf(NeedBracesStyle(true, false)))).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                static void doNotAllowWhileWithEmptyBody() {\n                    while (true) ;\n                }\n\n                static void doNotAllowDoWhileWithEmptyBody(Object obj) {\n                    do ; while (true);\n                }\n\n                static void doNotAllowForIterativeWithEmptyBody(Object obj) {\n                    for (int i = 0; ; ) ;\n                }\n            }\n        ", null, "\n            class Test {\n                static void doNotAllowWhileWithEmptyBody() {\n                    while (true) {\n                    }\n                }\n\n                static void doNotAllowDoWhileWithEmptyBody(Object obj) {\n                    do {\n                    } while (true);\n                }\n\n                static void doNotAllowForIterativeWithEmptyBody(Object obj) {\n                    for (int i = 0; ; ) {\n                    }\n                }\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void allowSingleLineStatementInSwitch(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles(this_.namedStyles(CollectionsKt.listOf((Object)new NeedBracesStyle(Boolean.valueOf(true), Boolean.valueOf(false))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(namedStyles(listOf(NeedBracesStyle(true, false)))).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                {\n                    int counter = 0;\n                    int n = 1;\n                    switch (n) {\n                      case 1: counter++; break;\n                      case 6: counter += 10; break;\n                      default: counter = 100; break;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void initializeStyleWhenOtherwiseNotProvided(@NotNull NeedBracesTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static void method() {\n                    if (true) {\n                        return;\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        public static void assertChangedBase(@NotNull NeedBracesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NeedBracesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NeedBracesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull NeedBracesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NeedBracesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NeedBracesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull NeedBracesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull NeedBracesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NeedBracesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull NeedBracesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NeedBracesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NeedBracesTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull NeedBracesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

