/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u000f\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010 \u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010#\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0017J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006'"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addClassAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addMethodAnnotations", "addVariableAnnotationsToVariableAlreadyAnnotated", "addVariableAnnotationsToVariableNotAnnotated", "afterStatementInBlock", "beforeStatementInBlock", "lastStatementInClassBlock", "lastStatementInMethodBlock", "replaceAndInterpolateMethodParameters", "replaceArguments", "replaceBody", "Lorg/openrewrite/java/JavaParser$Builder;", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassAnnotationsWithAnnotationWithComment", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceLambdaParameters", "replaceLambdaWithMethodReference", "replaceMethod", "replaceMethodAnnotations", "replaceMethodInvocationWithArray", "replaceMethodInvocationWithMethodReference", "replaceMethodParameters", "replaceMethodParametersVariadicArray", "replaceMethodTypeParameters", "replaceMissingBody", "replacePackage", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "rewrite-test"})
public interface JavaTemplateTest
extends JavaRecipeTest {
    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithArray(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParametersVariadicArray(@NotNull JavaParser var1);

    @Test
    public void replaceAndInterpolateMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaParameters(@NotNull JavaParser var1);

    @Test
    public void replaceSingleStatement(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void afterStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void replaceStatementRequiringNewImport(@NotNull JavaParser var1);

    @Test
    public void replaceArguments(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotation(@NotNull JavaParser var1);

    @Test
    public void replaceMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceVariableAnnotations(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaParser var1);

    @Test
    public void addMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void addClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassImplements(@NotNull JavaParser var1);

    @Test
    public void replaceClassExtends(@NotNull JavaParser var1);

    @Test
    public void replaceThrows(@NotNull JavaParser var1);

    @Test
    public void replaceMethodTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceClassTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMissingBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceClassAnnotationsWithAnnotationWithComment(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replacePackage.1.INSTANCE), "\n            package a;\n            class Test {\n            }\n        ", null, "\n            package b;\n            class Test {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethod.1.INSTANCE), "\n            class Test {\n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                int test2(int n) {\n                    return n;\n                }\n            }\n        ", 0, 0, null, replaceMethod.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceLambdaWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaWithMethodReference.1.INSTANCE), "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = it -> it.toString();\n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceMethodInvocationWithArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"package org.openrewrite;\npublic class Test {\n    public void method(int[] val) {}\n    public void method(int[] val1, String val2) {}\n}"};
            Recipe recipe3 = recipe2;
            recipe2 = this_.toRecipe(replaceMethodInvocationWithArray.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr, null);\n                }\n            }\n        ", (String[])recipe3, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr);\n                }\n            }\n        ", 0, 0, replaceMethodInvocationWithArray.2.INSTANCE, null, 352, null);
        }

        @Test
        public static void replaceMethodInvocationWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodInvocationWithMethodReference.1.INSTANCE), "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = getToString();\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParameters.1.INSTANCE), "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int m, java.util.List<String> n) {\n                    new Runnable() {\n                        void inner(int m, java.util.List<String> n) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParameters.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceMethodParametersVariadicArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParametersVariadicArray.1.INSTANCE), "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(Object[]... values) {\n                    new Runnable() {\n                        void inner(Object[]... values) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParametersVariadicArray.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceAndInterpolateMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceAndInterpolateMethodParameters.1.INSTANCE), "\n            class Test {\n                void test(String s) {\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int n, String s) {\n                }\n            }\n        ", 0, 0, null, replaceAndInterpolateMethodParameters.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaParameters.1.INSTANCE), "\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceSingleStatement.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInBlock.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(beforeStatementInBlock.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(afterStatementInBlock.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInClassBlock.1.INSTANCE), "\n            class Test {\n            }\n        ", null, "\n            class Test {\n                int n;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInMethodBlock.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceStatementRequiringNewImport.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceArguments.1.INSTANCE), "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test();\n                }\n            }\n        ", null, "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test(m, Integer.valueOf(n), \"foo\");\n                }\n            }\n        ", 0, 0, null, replaceArguments.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotation.1.INSTANCE), "@SuppressWarnings(\"ALL\") class Test {}", null, "@Deprecated class Test {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodAnnotations.1.INSTANCE), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotations.1.INSTANCE), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceVariableAnnotations.1.INSTANCE), "\n            class Test {\n                void test() {\n                    // the m\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    // the m\n                    @SuppressWarnings(\"other\")\n                    int m;\n                    @SuppressWarnings(\"other\")\n                    final int n;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableAlreadyAnnotated.1.INSTANCE), "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\") /* hello */\n                    Boolean z;\n                    @SuppressWarnings(\"ALL\") private final int m, a;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                    @SuppressWarnings(\"ALL\") final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated /* hello */\n                    Boolean z;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    private final int m, a;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    int n;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableNotAnnotated.1.INSTANCE), "\n            class Test {\n                void test() {\n                    final int m;\n                    int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    final int m;\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addMethodAnnotations.1.INSTANCE), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public void test() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addClassAnnotations.1.INSTANCE), "\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassImplements.1.INSTANCE), "\n            class Test {\n            }\n        ", null, "\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassExtends.1.INSTANCE), "\n            class Test {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceThrows.1.INSTANCE), "\n            class Test {\n                void test() {}\n            }\n        ", null, "\n            class Test {\n                void test() throws Exception {}\n            }\n        ", 0, 0, null, replaceThrows.2.INSTANCE, 232, null);
        }

        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodTypeParameters.1.INSTANCE), "\n            import java.util.List;\n            \n            class Test {\n            \n                void test() {\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n            \n                <T, U> void test(List<T> t, U u) {\n                }\n            }\n        ", 0, 0, replaceMethodTypeParameters.2.INSTANCE, replaceMethodTypeParameters.3.INSTANCE, 104, null);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassTypeParameters.1.INSTANCE), "\n            class Test {\n            }\n        ", null, "\n            class Test<T, U> {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceBody.1.INSTANCE), "\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceMissingBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceMissingBody.1.INSTANCE), "\n            abstract class Test {\n                abstract void test();\n            }\n        ", null, "\n            abstract class Test {\n                void test(){\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceClassAnnotationsWithAnnotationWithComment(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotationsWithAnnotationWithComment.1.INSTANCE), "\n            class Test {\n            \n                class Inner1 {\n                }\n            }\n        ", null, "\n            /**\n             * Do suppress those warnings\n             */\n            @SuppressWarnings(\"other\")\n            class Test {\n            \n                /**\n                 * Do suppress those warnings\n                 */\n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull JavaTemplateTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

