/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\f\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0014"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "doesNotMatchDifferentNamedParameters", "jp", "Lorg/openrewrite/java/JavaParser;", "doesNotMatchDifferentSingleAnnotationParameter", "doesNotMatchNotFullyQualifiedAnnotations", "findAnnotationWithClassTypeArgument", "matchesAnnotationOnField", "matchesAnnotationOnMethod", "matchesClassArgument", "Lorg/openrewrite/java/JavaParser$Builder;", "matchesNamedParameters", "matchesNamedParametersRegardlessOfOrder", "matchesPartialNamedParameters", "matchesSimpleFullyQualifiedAnnotation", "matchesSingleAnnotationParameter", "Companion", "rewrite-test"})
public interface FindAnnotationsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.FindAnnotationsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

    @Test
    public void matchesClassArgument(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void matchesSimpleFullyQualifiedAnnotation(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnMethod(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnField(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchNotFullyQualifiedAnnotations(@NotNull JavaParser var1);

    @Test
    public void matchesSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParameters(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesPartialNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParametersRegardlessOfOrder(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Test
    public void findAnnotationWithClassTypeArgument(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest$Companion;", "", "()V", "foo", "", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void matchesClassArgument(@NotNull FindAnnotationsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"junit-jupiter-api"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            stringArray = new FindAnnotations("@org.junit.jupiter.api.extension.ExtendWith(org.openrewrite.MyExtension.class)");
            String[] stringArray2 = new String[]{"\n                package org.openrewrite;\n                import org.junit.jupiter.api.extension.Extension;\n                public class MyExtension implements Extension {}\n            "};
            String[] stringArray3 = stringArray2;
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)stringArray, "\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.openrewrite.MyExtension;\n            @ExtendWith(MyExtension.class) public class A {}\n            @ExtendWith({MyExtension.class}) class B {}\n            @ExtendWith(value = MyExtension.class) class C {}\n            @ExtendWith(value = {MyExtension.class}) class D {}\n        ", stringArray3, "\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.openrewrite.MyExtension;\n            /*~~>*/@ExtendWith(MyExtension.class) public class A {}\n            /*~~>*/@ExtendWith({MyExtension.class}) class B {}\n            /*~~>*/@ExtendWith(value = MyExtension.class) class C {}\n            /*~~>*/@ExtendWith(value = {MyExtension.class}) class D {}\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void matchesSimpleFullyQualifiedAnnotation(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "@Deprecated public class A {}", null, "/*~~>*/@Deprecated public class A {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void matchesAnnotationOnMethod(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "\n            public class A {\n                @Deprecated\n                public void foo() {}\n            }\n        ", null, "\n            public class A {\n                /*~~>*/@Deprecated\n                public void foo() {}\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void matchesAnnotationOnField(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "\n            public class A {\n                @Deprecated String s;\n            }\n        ", null, "\n            public class A {\n                /*~~>*/@Deprecated String s;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doesNotMatchNotFullyQualifiedAnnotations(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new FindAnnotations("@Deprecated"), "@Deprecated public class A {}", null, 8, null);
        }

        @Test
        public static void matchesSingleAnnotationParameter(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"deprecation\")"), "@SuppressWarnings(\"deprecation\") public class A {}", null, "/*~~>*/@SuppressWarnings(\"deprecation\") public class A {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doesNotMatchDifferentSingleAnnotationParameter(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"foo\")"), "@SuppressWarnings(\"deprecation\") public class A {}", null, 8, null);
        }

        @Test
        public static void matchesNamedParameters(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(bar=\"quux\",baz=\"bar\")");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findAnnotations, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void doesNotMatchDifferentNamedParameters(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            this_.assertUnchanged(jp, (Recipe)new FindAnnotations("@com.netflix.foo.Foo(bar=\"qux\",baz=\"baz\")"), "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {} \n        ", stringArray);
        }

        @Test
        public static void matchesPartialNamedParameters(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\")");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findAnnotations, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void matchesNamedParametersRegardlessOfOrder(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findAnnotations, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void checkValidation(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            FindAnnotations recipe2 = new FindAnnotations(null);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("annotationPattern");
            recipe2 = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")");
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isTrue();
        }

        @Test
        public static void findAnnotationWithClassTypeArgument(@NotNull FindAnnotationsTest this_, @NotNull JavaParser jp) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
                Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                String[] stringArray = new String[]{"\n            package com.foo;\n            \n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Inherited;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n            \n            @Retention(RetentionPolicy.RUNTIME)\n            @Target({ElementType.TYPE})\n            @Inherited\n            public @interface Example { \n                Class<?> value();\n            }\n        ", "\n            package com.foo;\n            \n            @Example(Foo.class)\n            public class Foo {}\n        "};
                Iterable iterable = jp.parse(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"jp.parse(\"\"\"\n            package com.foo;\n            \n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Inherited;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n            \n            @Retention(RetentionPolicy.RUNTIME)\n            @Target({ElementType.TYPE})\n            @Inherited\n            public @interface Example { \n                Class<?> value();\n            }\n        \"\"\",\n        \"\"\"\n            package com.foo;\n            \n            @Example(Foo.class)\n            public class Foo {}\n        \"\"\")");
                iterable = iterable;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object e : iterable2) {
                    J.CompilationUnit it = (J.CompilationUnit)e;
                    boolean bl3 = false;
                    List list = it.getClasses();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.classes");
                    if (!Intrinsics.areEqual((Object)((J.ClassDeclaration)CollectionsKt.first((List)list)).getSimpleName(), (Object)"Foo")) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            J.CompilationUnit compilationUnit = v0;
            Intrinsics.checkNotNull((Object)compilationUnit);
            J.CompilationUnit fooClass = compilationUnit;
            Set maybeExample = FindAnnotations.find((J)((J)fooClass), (String)"@com.foo.Example(com.foo.Foo.class)");
            Assertions.assertThat((Iterable)maybeExample).hasSize(1);
        }

        public static void assertChangedBase(@NotNull FindAnnotationsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindAnnotationsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindAnnotationsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull FindAnnotationsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FindAnnotationsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull FindAnnotationsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindAnnotationsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

