/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AssertionsKt;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 %2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0003%&'B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\f\u0010\u001f\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010 \u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010!\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010\"\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010#\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010$\u001a\u00020\n*\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lorg/openrewrite/java/TypeValidator;", "Lorg/openrewrite/java/JavaIsoVisitor;", "", "Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "options", "Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "(Lorg/openrewrite/java/TypeValidator$ValidationOptions;)V", "getOptions", "()Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "inImport", "", "inPackageDeclaration", "isCaseLabel", "isClassName", "isLabel", "isMemberReference", "isMethodInvocationName", "isMethodName", "isTypeParameter", "visitClassDeclaration", "Lorg/openrewrite/java/tree/J$ClassDeclaration;", "classDecl", "p", "visitIdentifier", "Lorg/openrewrite/java/tree/J$Identifier;", "identifier", "visitMethodDeclaration", "Lorg/openrewrite/java/tree/J$MethodDeclaration;", "method", "visitMethodInvocation", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "isAllowedToHaveNullType", "isAnnotationField", "isBeingDeclared", "isFieldAccess", "isNewClass", "isParameterizedType", "Companion", "InvalidTypeResult", "ValidationOptions", "rewrite-test"})
public final class TypeValidator
extends JavaIsoVisitor<List<InvalidTypeResult>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValidationOptions options;
    @NotNull
    private static final ValidationOptions defaultOptions = new ValidationOptions(false, false, false, false, 15, null);

    public TypeValidator(@NotNull ValidationOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    public /* synthetic */ TypeValidator(ValidationOptions validationOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            validationOptions = defaultOptions;
        }
        this(validationOptions);
    }

    @NotNull
    public final ValidationOptions getOptions() {
        return this.options;
    }

    @NotNull
    public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull List<InvalidTypeResult> p) {
        Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        if (!this.options.getClassDeclarations()) {
            Intrinsics.checkNotNullExpressionValue((Object)c, (String)"c");
            return c;
        }
        JavaType.FullyQualified t = c.getType();
        if (t == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.ClassDeclaration type is null"));
            Intrinsics.checkNotNullExpressionValue((Object)c, (String)"c");
            return c;
        }
        if (!Intrinsics.areEqual((Object)c.getKind().name(), (Object)t.getKind().name())) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.ClassDeclaration kind \"" + c.getKind() + "\" does not match the kind in its type information \"" + t.getKind() + '\"'));
        }
        J.CompilationUnit compilationUnit = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
        Intrinsics.checkNotNull((Object)compilationUnit);
        J.CompilationUnit cu = compilationUnit;
        J.Package pack = cu.getPackageDeclaration();
        if (pack != null && !t.getPackageName().equals(pack.getExpression().printTrimmed())) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.ClassDeclaration package \"" + t.getPackageName() + "\" does not match the enclosing J.CompilationUnit's package declaration \"" + pack.getExpression().printTrimmed() + '\"'));
        }
        Intrinsics.checkNotNullExpressionValue((Object)c, (String)"c");
        return c;
    }

    @NotNull
    public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull List<InvalidTypeResult> p) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        if (!this.options.getMethodInvocations()) {
            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
            return m;
        }
        JavaType.Method mt = method.getType();
        if (mt == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation type is null"));
            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
            return m;
        }
        if (mt.getGenericSignature() == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation is missing a genericSignature"));
        }
        if (!m.getSimpleName().equals(mt.getName())) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation name \"" + m.getSimpleName() + "\" does not match the name in its type information \"" + mt.getName() + '\"'));
        }
        Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
        return m;
    }

    @NotNull
    public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull List<InvalidTypeResult> p) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        if (!this.options.getMethodDeclarations()) {
            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
            return m;
        }
        JavaType.Method mt = m.getType();
        if (mt == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodDeclaration type is null"));
            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
            return m;
        }
        if (mt.getGenericSignature() == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodDeclaration is missing a genericSignature"));
        }
        if (!m.getSimpleName().equals(mt.getName())) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodDeclaration name \"" + m.getSimpleName() + "\" does not match the name in its type information \"" + mt.getName() + '\"'));
        }
        Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
        return m;
    }

    @NotNull
    public J.Identifier visitIdentifier(@NotNull J.Identifier identifier, @NotNull List<InvalidTypeResult> p) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        J.Identifier i = super.visitIdentifier(identifier, p);
        if (!this.options.getIdentifiers()) {
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
            return i;
        }
        JavaType t = i.getType();
        if (t == null) {
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
            if (!this.isAllowedToHaveNullType(i)) {
                p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.Identifier type is null"));
            }
            return i;
        }
        Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
        return i;
    }

    private final boolean isAllowedToHaveNullType(J.Identifier $this$isAllowedToHaveNullType) {
        return this.inPackageDeclaration() || this.inImport() || this.isClassName() || this.isMethodName() || this.isMethodInvocationName() || this.isFieldAccess($this$isAllowedToHaveNullType) || this.isBeingDeclared($this$isAllowedToHaveNullType) || this.isParameterizedType($this$isAllowedToHaveNullType) || this.isNewClass($this$isAllowedToHaveNullType) || this.isTypeParameter() || this.isMemberReference() || this.isCaseLabel() || this.isLabel() || this.isAnnotationField($this$isAllowedToHaveNullType);
    }

    private final boolean inPackageDeclaration() {
        return this.getCursor().firstEnclosing(J.Package.class) != null;
    }

    private final boolean inImport() {
        return this.getCursor().firstEnclosing(J.Import.class) != null;
    }

    private final boolean isClassName() {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        return cursor.getValue() instanceof J.ClassDeclaration;
    }

    private final boolean isMethodName() {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        return cursor.getValue() instanceof J.MethodDeclaration;
    }

    private final boolean isMethodInvocationName() {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        return cursor.getValue() instanceof J.MethodInvocation;
    }

    private final boolean isFieldAccess(J.Identifier $this$isFieldAccess) {
        J.FieldAccess parent = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
        return parent != null && (Intrinsics.areEqual((Object)parent.getName(), (Object)$this$isFieldAccess) || Intrinsics.areEqual((Object)parent.getTarget(), (Object)$this$isFieldAccess));
    }

    private final boolean isBeingDeclared(J.Identifier $this$isBeingDeclared) {
        J.VariableDeclarations.NamedVariable parent = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        return parent != null && Intrinsics.areEqual((Object)parent.getName(), (Object)$this$isBeingDeclared);
    }

    private final boolean isParameterizedType(J.Identifier $this$isParameterizedType) {
        J.ParameterizedType parent = (J.ParameterizedType)this.getCursor().firstEnclosing(J.ParameterizedType.class);
        return parent != null && Intrinsics.areEqual((Object)parent.getClazz(), (Object)$this$isParameterizedType);
    }

    private final boolean isNewClass(J.Identifier $this$isNewClass) {
        J.NewClass parent = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
        return parent != null && Intrinsics.areEqual((Object)parent.getClazz(), (Object)$this$isNewClass);
    }

    private final boolean isTypeParameter() {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        return cursor.getValue() instanceof J.TypeParameter;
    }

    private final boolean isMemberReference() {
        return this.getCursor().firstEnclosing(J.MemberReference.class) != null;
    }

    private final boolean isCaseLabel() {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        return cursor.getValue() instanceof J.Case;
    }

    private final boolean isLabel() {
        return this.getCursor().firstEnclosing(J.Label.class) != null;
    }

    private final boolean isAnnotationField(J.Identifier $this$isAnnotationField) {
        Cursor cursor = this.getCursor().getParent();
        Intrinsics.checkNotNull((Object)cursor);
        Object parent = cursor.getValue();
        return parent instanceof J.Assignment && Intrinsics.areEqual((Object)((J.Assignment)parent).getVariable(), (Object)$this$isAnnotationField) && this.getCursor().firstEnclosing(J.Annotation.class) != null;
    }

    public TypeValidator() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final List<InvalidTypeResult> analyzeTypes(@NotNull J.CompilationUnit cu, @NotNull ValidationOptions options) {
        return Companion.analyzeTypes(cu, options);
    }

    @JvmStatic
    public static final void assertTypesValid(@NotNull J.CompilationUnit cu, @NotNull ValidationOptions options) {
        Companion.assertTypesValid(cu, options);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "", "cursor", "Lorg/openrewrite/Cursor;", "message", "", "(Lorg/openrewrite/Cursor;Ljava/lang/String;)V", "getCursor", "()Lorg/openrewrite/Cursor;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "rewrite-test"})
    public static final class InvalidTypeResult {
        @NotNull
        private final Cursor cursor;
        @NotNull
        private final String message;

        public InvalidTypeResult(@NotNull Cursor cursor, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.cursor = cursor;
            this.message = message;
        }

        @NotNull
        public final Cursor getCursor() {
            return this.cursor;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Cursor component1() {
            return this.cursor;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final InvalidTypeResult copy(@NotNull Cursor cursor, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new InvalidTypeResult(cursor, message);
        }

        public static /* synthetic */ InvalidTypeResult copy$default(InvalidTypeResult invalidTypeResult, Cursor cursor, String string, int n, Object object) {
            if ((n & 1) != 0) {
                cursor = invalidTypeResult.cursor;
            }
            if ((n & 2) != 0) {
                string = invalidTypeResult.message;
            }
            return invalidTypeResult.copy(cursor, string);
        }

        @NotNull
        public String toString() {
            return "InvalidTypeResult(cursor=" + this.cursor + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result = this.cursor.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidTypeResult)) {
                return false;
            }
            InvalidTypeResult invalidTypeResult = (InvalidTypeResult)other;
            if (!Intrinsics.areEqual((Object)this.cursor, (Object)invalidTypeResult.cursor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)invalidTypeResult.message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "", "classDeclarations", "", "identifiers", "methodDeclarations", "methodInvocations", "(ZZZZ)V", "getClassDeclarations", "()Z", "getIdentifiers", "getMethodDeclarations", "getMethodInvocations", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "rewrite-test"})
    public static final class ValidationOptions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean classDeclarations;
        private final boolean identifiers;
        private final boolean methodDeclarations;
        private final boolean methodInvocations;

        public ValidationOptions(boolean classDeclarations, boolean identifiers, boolean methodDeclarations, boolean methodInvocations) {
            this.classDeclarations = classDeclarations;
            this.identifiers = identifiers;
            this.methodDeclarations = methodDeclarations;
            this.methodInvocations = methodInvocations;
        }

        public /* synthetic */ ValidationOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getClassDeclarations() {
            return this.classDeclarations;
        }

        public final boolean getIdentifiers() {
            return this.identifiers;
        }

        public final boolean getMethodDeclarations() {
            return this.methodDeclarations;
        }

        public final boolean getMethodInvocations() {
            return this.methodInvocations;
        }

        public final boolean component1() {
            return this.classDeclarations;
        }

        public final boolean component2() {
            return this.identifiers;
        }

        public final boolean component3() {
            return this.methodDeclarations;
        }

        public final boolean component4() {
            return this.methodInvocations;
        }

        @NotNull
        public final ValidationOptions copy(boolean classDeclarations, boolean identifiers, boolean methodDeclarations, boolean methodInvocations) {
            return new ValidationOptions(classDeclarations, identifiers, methodDeclarations, methodInvocations);
        }

        public static /* synthetic */ ValidationOptions copy$default(ValidationOptions validationOptions, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = validationOptions.classDeclarations;
            }
            if ((n & 2) != 0) {
                bl2 = validationOptions.identifiers;
            }
            if ((n & 4) != 0) {
                bl3 = validationOptions.methodDeclarations;
            }
            if ((n & 8) != 0) {
                bl4 = validationOptions.methodInvocations;
            }
            return validationOptions.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "ValidationOptions(classDeclarations=" + this.classDeclarations + ", identifiers=" + this.identifiers + ", methodDeclarations=" + this.methodDeclarations + ", methodInvocations=" + this.methodInvocations + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.classDeclarations ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.identifiers) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.methodDeclarations ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.methodInvocations ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidationOptions)) {
                return false;
            }
            ValidationOptions validationOptions = (ValidationOptions)other;
            if (this.classDeclarations != validationOptions.classDeclarations) {
                return false;
            }
            if (this.identifiers != validationOptions.identifiers) {
                return false;
            }
            if (this.methodDeclarations != validationOptions.methodDeclarations) {
                return false;
            }
            return this.methodInvocations == validationOptions.methodInvocations;
        }

        public ValidationOptions() {
            this(false, false, false, false, 15, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/TypeValidator$ValidationOptions$Companion;", "", "()V", "builder", "Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "init", "Lkotlin/Function1;", "Lorg/openrewrite/java/TypeValidator$ValidationOptions$Companion$Builder;", "", "Lkotlin/ExtensionFunctionType;", "Builder", "rewrite-test"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ValidationOptions builder(@NotNull Function1<? super Builder, Unit> init) {
                Intrinsics.checkNotNullParameter(init, (String)"init");
                Builder builder = new Builder(false, false, false, false, 15, null);
                init.invoke((Object)builder);
                return new ValidationOptions(builder.getClassDeclarations(), builder.getIdentifiers(), builder.getMethodDeclarations(), builder.getMethodInvocations());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/TypeValidator$ValidationOptions$Companion$Builder;", "", "classDeclarations", "", "identifiers", "methodDeclarations", "methodInvocations", "(ZZZZ)V", "getClassDeclarations", "()Z", "setClassDeclarations", "(Z)V", "getIdentifiers", "setIdentifiers", "getMethodDeclarations", "setMethodDeclarations", "getMethodInvocations", "setMethodInvocations", "rewrite-test"})
            public static final class Builder {
                private boolean classDeclarations;
                private boolean identifiers;
                private boolean methodDeclarations;
                private boolean methodInvocations;

                public Builder(boolean classDeclarations, boolean identifiers, boolean methodDeclarations, boolean methodInvocations) {
                    this.classDeclarations = classDeclarations;
                    this.identifiers = identifiers;
                    this.methodDeclarations = methodDeclarations;
                    this.methodInvocations = methodInvocations;
                }

                public /* synthetic */ Builder(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        bl = true;
                    }
                    if ((n & 2) != 0) {
                        bl2 = true;
                    }
                    if ((n & 4) != 0) {
                        bl3 = true;
                    }
                    if ((n & 8) != 0) {
                        bl4 = true;
                    }
                    this(bl, bl2, bl3, bl4);
                }

                public final boolean getClassDeclarations() {
                    return this.classDeclarations;
                }

                public final void setClassDeclarations(boolean bl) {
                    this.classDeclarations = bl;
                }

                public final boolean getIdentifiers() {
                    return this.identifiers;
                }

                public final void setIdentifiers(boolean bl) {
                    this.identifiers = bl;
                }

                public final boolean getMethodDeclarations() {
                    return this.methodDeclarations;
                }

                public final void setMethodDeclarations(boolean bl) {
                    this.methodDeclarations = bl;
                }

                public final boolean getMethodInvocations() {
                    return this.methodInvocations;
                }

                public final void setMethodInvocations(boolean bl) {
                    this.methodInvocations = bl;
                }

                public Builder() {
                    this(false, false, false, false, 15, null);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\u000f\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/TypeValidator$Companion;", "", "()V", "defaultOptions", "Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "getDefaultOptions", "()Lorg/openrewrite/java/TypeValidator$ValidationOptions;", "analyzeTypes", "", "Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "cu", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "options", "assertTypesValid", "", "invalidTypeResult", "Lorg/openrewrite/java/JavaVisitor;", "message", "", "rewrite-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ValidationOptions getDefaultOptions() {
            return defaultOptions;
        }

        @JvmStatic
        @NotNull
        public final List<InvalidTypeResult> analyzeTypes(@NotNull J.CompilationUnit cu, @NotNull ValidationOptions options) {
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            boolean bl = false;
            List report = new ArrayList();
            new TypeValidator(options).visit((Tree)cu, report);
            return report;
        }

        public static /* synthetic */ List analyzeTypes$default(Companion companion, J.CompilationUnit compilationUnit, ValidationOptions validationOptions, int n, Object object) {
            if ((n & 2) != 0) {
                validationOptions = companion.getDefaultOptions();
            }
            return companion.analyzeTypes(compilationUnit, validationOptions);
        }

        @JvmStatic
        public final void assertTypesValid(@NotNull J.CompilationUnit cu, @NotNull ValidationOptions options) {
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            List<InvalidTypeResult> report = this.analyzeTypes(cu, options);
            Collection collection = report;
            boolean bl = false;
            if (!collection.isEmpty()) {
                String reportText2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)report), (Function1)assertTypesValid.reportText.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                AssertionsKt.fail$default((String)Intrinsics.stringPlus((String)"AST contains missing or invalid type information: \n", (Object)reportText2), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
        }

        public static /* synthetic */ void assertTypesValid$default(Companion companion, J.CompilationUnit compilationUnit, ValidationOptions validationOptions, int n, Object object) {
            if ((n & 2) != 0) {
                validationOptions = companion.getDefaultOptions();
            }
            companion.assertTypesValid(compilationUnit, validationOptions);
        }

        private final InvalidTypeResult invalidTypeResult(JavaVisitor<?> $this$invalidTypeResult, String message) {
            Cursor cursor = $this$invalidTypeResult.getCursor();
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
            return new InvalidTypeResult(cursor, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

