/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.RemoveUnusedLocalVariables;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\b\u0010\u0015\u001a\u00020\u0007H\u0017J\b\u0010\u0016\u001a\u00020\u0007H\u0017J\b\u0010\u0017\u001a\u00020\u0007H\u0017J\b\u0010\u0018\u001a\u00020\u0007H\u0017J\b\u0010\u0019\u001a\u00020\u0007H\u0017J\b\u0010\u001a\u001a\u00020\u0007H\u0017J\b\u0010\u001b\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lorg/openrewrite/java/cleanup/RemoveUnusedLocalVariablesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "forLoopIncrementVariableReadInEvaluationCondition", "", "forLoopWithExternalIncrementLogic", "handleInstanceOf", "ignoreAnonymousClassVariables", "ignoreClassVariables", "ignoreEnhancedForLoops", "ignoreForLoopIncrementVariableNeverRead", "ignoreSuppressWarnings", "ignoreTryCatchException", "ignoreTryResource", "ignoreUnusedLambdaExpressionParameters", "ignoreUnusedLambdaExpressionParametersForEach", "keepLocalVariableAssignmentOperation", "keepLocalVariableBitwiseAssignmentOperationWithinExpression", "keepLocalVariablesAssignmentOperationToOtherVariables", "keepLocalVariablesWhenMethodInvocationsCalledOnThem", "keepLocalVariablesWhenUsedAsMethodInvocationArgument", "removeUnusedLocalVariableBitwiseAssignmentOperation", "removeUnusedLocalVariables", "removeUnusedLocalVariablesFromMultiVariablesDeclaration", "removeUnusedLocalVariablesReassignedButNeverUsed", "rewrite-test"})
public interface RemoveUnusedLocalVariablesTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void ignoreSuppressWarnings();

    @Test
    public void removeUnusedLocalVariables();

    @Test
    public void removeUnusedLocalVariablesReassignedButNeverUsed();

    @Test
    public void keepLocalVariablesAssignmentOperationToOtherVariables();

    @Test
    public void keepLocalVariableAssignmentOperation();

    @Test
    public void removeUnusedLocalVariableBitwiseAssignmentOperation();

    @Test
    public void keepLocalVariableBitwiseAssignmentOperationWithinExpression();

    @Test
    public void handleInstanceOf();

    @Test
    public void removeUnusedLocalVariablesFromMultiVariablesDeclaration();

    @Test
    public void keepLocalVariablesWhenUsedAsMethodInvocationArgument();

    @Test
    public void keepLocalVariablesWhenMethodInvocationsCalledOnThem();

    @Test
    public void ignoreClassVariables();

    @Test
    public void ignoreAnonymousClassVariables();

    @Test
    public void forLoopWithExternalIncrementLogic();

    @Test
    public void forLoopIncrementVariableReadInEvaluationCondition();

    @Test
    public void ignoreTryResource();

    @Test
    public void ignoreTryCatchException();

    @Test
    public void ignoreUnusedLambdaExpressionParameters();

    @Test
    public void ignoreUnusedLambdaExpressionParametersForEach();

    @Test
    public void ignoreForLoopIncrementVariableNeverRead();

    @Test
    public void ignoreEnhancedForLoops();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new RemoveUnusedLocalVariables();
        }

        @Test
        public static void ignoreSuppressWarnings(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    @SuppressWarnings(\"unused\") int b = 0;\n                    return a + 1;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void removeUnusedLocalVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    int b = 0;\n                    return a + 1;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    return a + 1;\n                }\n            }\n        ", 0, 0, false, null, 491, null);
        }

        @Test
        public static void removeUnusedLocalVariablesReassignedButNeverUsed(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test {\n                static int method() {\n                    int isRead = -1;\n                    int notRead = 0;\n                    notRead = 1;\n                    notRead += 1;\n                    notRead = isRead + 1;\n                    return isRead + 1;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method() {\n                    int isRead = -1;\n                    return isRead + 1;\n                }\n            }\n        ", 0, 0, false, null, 491, null);
        }

        @Test
        public static void keepLocalVariablesAssignmentOperationToOtherVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static int method() {\n                    int dataSize = 0;\n                    int size = 0;\n                    for (int j = 0; j < 10; j++) {\n                        dataSize += 1;\n                    }\n                    size += dataSize;\n                    return size;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void keepLocalVariableAssignmentOperation(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    return a |= false;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void removeUnusedLocalVariableBitwiseAssignmentOperation(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    boolean b = false;\n                    b &= true;\n                    return a |= false;\n                }\n            }\n        ", null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    return a |= false;\n                }\n            }\n        ", 0, 0, false, null, 491, null);
        }

        @Test
        public static void keepLocalVariableBitwiseAssignmentOperationWithinExpression(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static boolean method(String string) {\n                    boolean a = false;\n                    for (char c : string.toCharArray()) {\n                        if (false || (a |= !Character.isWhitespace(c))) {\n                            break;\n                        }\n                    }\n                    return a;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void handleInstanceOf(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.Stack;\n\n            class Test {\n                static boolean method(Stack<Object> typeStack) {\n                    for (Object e = typeStack.pop(); ; e = typeStack.pop()) {\n                        if (e instanceof String) {\n                            break;\n                        }\n                    }\n                    return true;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void removeUnusedLocalVariablesFromMultiVariablesDeclaration(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0, b = 0, c = 0, d = 0;\n                    return b + c;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method(int x) {\n                    int b = 0, c = 0;\n                    return b + c;\n                }\n            }\n        ", 0, 0, false, null, 491, null);
        }

        @Test
        public static void keepLocalVariablesWhenUsedAsMethodInvocationArgument(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static void method() {\n                    int a = 0;\n                    System.out.println(a);\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void keepLocalVariablesWhenMethodInvocationsCalledOnThem(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                void method() {\n                    Worker worker = new Worker();\n                    worker.doWork();\n                }\n\n                class Worker {\n                    void doWork() {\n                        //\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreClassVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static int someClassVariable = 0;\n                int someInstanceVariable = 0;\n\n                static void method() {\n                    // do nothing\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreAnonymousClassVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.io.File;\n\n            class Test {\n                static File method(File dir) {\n                    final File src = new File(dir, \"child\") {\n                        private static final long serialVersionUID = 1L;\n                    };\n                    return src;\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void forLoopWithExternalIncrementLogic(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static void method() {\n                    for (int i; ; ) {\n                        i = 41;\n                        if (i == 42) {\n                            break;\n                        }\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void forLoopIncrementVariableReadInEvaluationCondition(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static void method() {\n                    for (int j = 0; j < 10; j++) {\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreTryResource(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method() {\n                    try (Stream<Object> unused = Stream.of()) {\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreTryCatchException(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static void method() {\n                    try {\n                    } catch (Exception e) {\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreUnusedLambdaExpressionParameters(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.function.BinaryOperator;\n            import java.util.function.UnaryOperator;\n\n            class Test {\n                static BinaryOperator<UnaryOperator<Object>> method() {\n                    return (a, b) -> input -> {\n                        Object o = a.apply(input);\n                        o.toString();\n                        return o;\n                    };\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreUnusedLambdaExpressionParametersForEach(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.List;\n\n            class Test {\n                static void method(List<Object> list) {\n                    list.forEach(item -> {\n                        // do nothing with \"item\"\n                    });\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreForLoopIncrementVariableNeverRead(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test {\n                static boolean isTrue() {\n                    return true;\n                }\n\n                static void method() {\n                    for (int j = 0; isTrue(); j++) {\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void ignoreEnhancedForLoops(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.List;\n\n            class Test {\n                static void method(List<String> list) {\n                    for (String s : list) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, 11, null);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull RemoveUnusedLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

