/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/TryCatchTest;", "Lorg/openrewrite/java/JavaTreeTest;", "catchRightPadding", "", "jp", "Lorg/openrewrite/java/JavaParser;", "multiCatch", "multipleResources", "tryCatchFinally", "tryCatchNoFinally", "tryFinally", "tryWithResources", "tryWithResourcesSemiTerminated", "rewrite-test"})
public interface TryCatchTest
extends JavaTreeTest {
    @Test
    public void catchRightPadding(@NotNull JavaParser var1);

    @Test
    public void tryFinally(@NotNull JavaParser var1);

    @Test
    public void tryCatchNoFinally(@NotNull JavaParser var1);

    @Test
    public void tryWithResources(@NotNull JavaParser var1);

    @Test
    public void tryWithResourcesSemiTerminated(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multipleResources(@NotNull JavaParser var1);

    @Test
    public void tryCatchFinally(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void catchRightPadding(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void method() {\n        try {\n        } catch( Exception e ) {\n        }\n    }\n}"};
            J.CompilationUnit j = (J.CompilationUnit)jp.parse(stringArray).get(0);
            new JavaIsoVisitor<Integer>(){

                @NotNull
                public J.Try.Catch visitCatch(@NotNull J.Try.Catch c, int p) {
                    Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                    Assertions.assertThat((String)c.getParameter().getPadding().getTree().getAfter().getWhitespace()).isEqualTo(" ");
                    J.Try.Catch catch_ = super.visitCatch(c, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)catch_, (String)"super.visitCatch(c, p)");
                    return catch_;
                }
            }.visit((Tree)j, (Object)0);
        }

        @Test
        public static void tryFinally(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            try {\n            }\n            finally {\n            }\n        ", new String[0]);
        }

        @Test
        public static void tryCatchNoFinally(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            try {\n            }\n            catch(Throwable t) {\n            }\n        ", new String[0]);
        }

        @Test
        public static void tryWithResources(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.io.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            File f = new File(\"file.txt\");\n            try (FileInputStream fis = new FileInputStream(f)) {\n            }\n            catch(IOException e) {\n            }\n        ", stringArray);
        }

        @Test
        public static void tryWithResourcesSemiTerminated(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.io.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            File f = new File(\"file.txt\");\n            try (FileInputStream fis = new FileInputStream(f) ; ) {\n            }\n            catch(IOException e) {\n            }\n        ", stringArray);
        }

        @Test
        public static void multiCatch(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.io.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            File f = new File(\"file.txt\");\n            try(FileInputStream fis = new FileInputStream(f)) {}\n            catch(FileNotFoundException | RuntimeException e) {}\n        ", stringArray);
        }

        @Test
        public static void multipleResources(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.io.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            File f = new File(\"file.txt\");\n            try(FileInputStream fis = new FileInputStream(f); FileInputStream fis2 = new FileInputStream(f)) {}\n            catch(RuntimeException | IOException e) {}\n        ", stringArray);
        }

        @Test
        public static void tryCatchFinally(@NotNull TryCatchTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            try {}\n            catch(Exception e) {}\n            catch(RuntimeException e) {}\n            catch(Throwable t) {}\n            finally {}\n        ", new String[0]);
        }
    }
}

