/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveImport;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/RemoveUnusedImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "leaveImportIfRemovedTypeIsStillReferredTo", "", "jp", "Lorg/openrewrite/java/JavaParser;", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "removeImport", "Lorg/openrewrite/RecipeTest$AdHocRecipe;", "type", "", "removeNamedImport", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStaticImportIfNotReferenced", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "rewrite-test"})
public interface RemoveUnusedImportsTest
extends JavaRecipeTest {
    @NotNull
    public RecipeTest.AdHocRecipe removeImport(@NotNull String var1);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static RecipeTest.AdHocRecipe removeImport(@NotNull RemoveUnusedImportsTest this_, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this_.toRecipe((TreeVisitor)new RemoveImport(type));
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {}\n        ", null, "class A {}", 0, 40, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertUnchanged((Parser)jp, this_.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {\n               List list;\n            }\n        ");
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {}\n        ", null, "class A {}", 0, 40, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.*;\n            \n            class A {\n               Collection c;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            class A {\n               Collection c;\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertUnchanged((Parser)jp, this_.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {\n               Collection c;\n               Set s;\n            }\n        ");
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, "class A {}", 0, 40, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertUnchanged((Parser)jp, this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ");
        }

        @Test
        public static void removeStaticImportIfNotReferenced(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.time.DayOfWeek.MONDAY"), "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n                    package foo;\n                    public class B {\n                        public static final String STRING = \"string\";\n                        public static final String STRING2 = \"string2\";\n                    }\n                ", "\n                    package foo;\n                    public class C {\n                        public static final String ANOTHER = \"string\";\n                    }\n                "};
            Recipe recipe3 = recipe2;
            recipe2 = this_.removeImport("foo.B").doNext(this_.removeImport("foo.C"));
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, recipe2, "\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", (String[])recipe3, "\n            import static foo.B.STRING;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", 0, 32, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull RemoveUnusedImportsTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull RemoveUnusedImportsTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveUnusedImportsTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull RemoveUnusedImportsTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

