/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/ImportTest;", "Lorg/openrewrite/java/JavaTreeTest;", "classImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "compare", "compareSamePackageDifferentNameLengths", "starImport", "rewrite-test"})
public interface ImportTest
extends JavaTreeTest {
    @Test
    public void classImport(@NotNull JavaParser var1);

    @Test
    public void starImport(@NotNull JavaParser var1);

    @Test
    public void compare(@NotNull JavaParser var1);

    @Test
    public void compareSamePackageDifferentNameLengths(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void classImport(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            public class A {}\n        ", new String[0]);
        }

        @Test
        public static void starImport(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.*;\n            public class A {}\n        ", new String[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void compare(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            void b;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import b.B;\nimport c.c.C;"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List list2 = list = compilationUnit.getImports();
            boolean bl = false;
            J.Import import_ = (J.Import)list2.get(0);
            list2 = list;
            bl = false;
            J.Import c = (J.Import)list2.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo((J.Import)b) > 0 ? 1 : 0) != 0);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void compareSamePackageDifferentNameLengths(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            void b;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Configuration;"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List list2 = list = compilationUnit.getImports();
            boolean bl = false;
            J.Import import_ = (J.Import)list2.get(0);
            list2 = list;
            bl = false;
            J.Import c = (J.Import)list2.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo((J.Import)b) > 0 ? 1 : 0) != 0);
        }
    }
}

