/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/tree/NewArrayTest;", "Lorg/openrewrite/java/JavaTreeTest;", "dimensions", "", "jp", "Lorg/openrewrite/java/JavaParser;", "emptyDimension", "initializers", "newArray", "newArrayShortcut", "rewrite-test"})
public interface NewArrayTest
extends JavaTreeTest {
    @Test
    public void newArray(@NotNull JavaParser var1);

    @Test
    public void initializers(@NotNull JavaParser var1);

    @Test
    public void dimensions(@NotNull JavaParser var1);

    @Test
    public void emptyDimension(@NotNull JavaParser var1);

    @Test
    public void newArrayShortcut(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void newArray(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            int[] n = new int[0];\n        ", new String[0]);
        }

        @Test
        public static void initializers(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            int[] n = new int[] { 0, 1, 2 };    \n        ", new String[0]);
        }

        @Test
        public static void dimensions(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            int[][] n = new int [ 0 ] [ 1 ];\n        ", new String[0]);
        }

        @Test
        public static void emptyDimension(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n                int[][] n = new int [ 0 ] [ ];\n        ", new String[0]);
        }

        @Test
        public static void newArrayShortcut(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.lang.annotation.*;\n            @Target({ElementType.TYPE})\n            public @interface Produces {\n                String[] value() default \"*/*\";\n            }\n            \n            @Produces({\"something\"}) class A {}\n        ", new String[0]);
        }
    }
}

