/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.search.FindTypes;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\bf\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/search/FindTypesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/search/FindTypes;", "getRecipe", "()Lorg/openrewrite/java/search/FindTypes;", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "checkValidation", "classDecl", "classReference", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "multiCatch", "multiVariable", "newClass", "parameterizedType", "simpleName", "typeCast", "Companion", "rewrite-test"})
public interface FindTypesTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.FindTypesTest$Companion.$$INSTANCE;

    @NotNull
    public FindTypes getRecipe();

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static FindTypes getRecipe(@NotNull FindTypesTest $this) {
            return new FindTypes("a.A1");
        }

        @Test
        public static void simpleName(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B extends /*~~>*/A1 {}\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B extends A1 {}\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void fullyQualifiedName(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "public class B extends /*~~>*/a.A1 {}";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "public class B extends a.A1 {}", stringArray, n, string, 18, null);
        }

        @Test
        public static void annotation(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"public @interface A1 {}"};
            int n = 0;
            String string = "@/*~~>*/A1 public class B {}";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindTypes("A1"), "@A1 public class B {}", stringArray, n, string, 16, null);
        }

        @Test
        public static void array(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               /*~~>*/A1[] a = new /*~~>*/A1[0];\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void classDecl(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ", "public interface I1 {}"};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B extends /*~~>*/A1 implements /*~~>*/I1 {}\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.getRecipe().doNext((Recipe)new FindTypes("I1")), "\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", stringArray, n, string, 16, null);
        }

        @Test
        public static void method(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               public /*~~>*/A1 foo() throws /*~~>*/A1 { return null; }\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends /*~~>*/A1> T generic(T n, List<? super /*~~>*/A1> in) { return null; }\n               public void test() {\n                   /*~~>*/A1.stat();\n                   this.</*~~>*/A1>generic(null, null);\n               }\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) { return null; }\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void multiCatch(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(/*~~>*/A1 | RuntimeException e) {}\n               }\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void multiVariable(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 f1, f2;\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void newClass(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 a = new /*~~>*/A1();\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void parameterizedType(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            import java.util.Map;\n            public class B {\n               Map</*~~>*/A1, /*~~>*/A1> m;\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            import java.util.Map;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void typeCast(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 a = (/*~~>*/A1) null;\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ", stringArray, n, string, 18, null);
        }

        @Test
        public static void classReference(@NotNull FindTypesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            int n = 0;
            String string = "\n                import a.A1;\n                class B {\n                    Class<?> clazz = /*~~>*/A1.class;\n                }\n            ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n                import a.A1;\n                class B {\n                    Class<?> clazz = A1.class;\n                }\n            ", stringArray, n, string, 18, null);
        }

        @Test
        public static void checkValidation(@NotNull FindTypesTest $this) {
            Validated valid;
            FindTypes recipe2 = new FindTypes(null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("fullyQualifiedTypeName");
            recipe2 = new FindTypes("com.foo.Foo");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isTrue();
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindTypesTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull FindTypesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindTypesTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull FindTypesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindTypesTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindTypesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindTypesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull FindTypesTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull FindTypesTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindTypesTest$Companion;", "", "()V", "a1", "", "rewrite-test"})
    public static final class Companion {
        private static final String a1 = "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

