/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveImport;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/RemoveUnusedImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "leaveImportIfRemovedTypeIsStillReferredTo", "", "jp", "Lorg/openrewrite/java/JavaParser;", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "removeImport", "Lorg/openrewrite/RecipeTest$AdHocRecipe;", "type", "", "removeNamedImport", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStaticImportIfNotReferenced", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "rewrite-test"})
public interface RemoveUnusedImportsTest
extends JavaRecipeTest {
    @NotNull
    public RecipeTest.AdHocRecipe removeImport(@NotNull String var1);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static RecipeTest.AdHocRecipe removeImport(@NotNull RemoveUnusedImportsTest $this, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return $this.toRecipe((TreeVisitor)new RemoveImport(type));
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {}\n        ", null, 0, "class A {}", 24, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {\n               List list;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {}\n        ", null, 0, "class A {}", 24, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.List"), "\n            import java.util.*;\n            \n            class A {\n               Collection c;\n            }\n        ", null, 0, "\n            import java.util.Collection;\n            \n            class A {\n               Collection c;\n            }\n        ", 24, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {\n               Collection c;\n               Set s;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, 0, "class A {}", 24, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStaticImportIfNotReferenced(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.time.DayOfWeek.MONDAY"), "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, 0, "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 24, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)$this.removeImport("java.util.Collections"), "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, 0, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 24, null);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveUnusedImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import static foo.B.STRING;\n            \n            public class A {\n                String a = STRING;\n            }\n        ";
            int n = 0;
            String string2 = "\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            \n            public class A {\n                String a = STRING;\n            }\n        ";
            Recipe recipe2 = $this.removeImport("foo.B").doNext($this.removeImport("foo.C"));
            String[] stringArray = new String[]{"\n                    package foo;\n                    public class B {\n                        public static final String STRING = \"string\";\n                        public static final String STRING2 = \"string2\";\n                    }\n                ", "\n                    package foo;\n                    public class C {\n                        public static final String ANOTHER = \"string\";\n                    }\n                "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull RemoveUnusedImportsTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveUnusedImportsTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull RemoveUnusedImportsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull RemoveUnusedImportsTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }
}

