/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.DeleteMethodArgument;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/DeleteMethodArgumentTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "deleteArgumentsConsecutively", "jp", "Lorg/openrewrite/java/JavaParser;", "deleteMiddleArgument", "deleteMiddleArgumentDeclarative", "doNotDeleteEmptyContainingFormatting", "insertEmptyWhenLastArgumentIsDeleted", "Companion", "rewrite-test"})
public interface DeleteMethodArgumentTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.DeleteMethodArgumentTest$Companion.$$INSTANCE;

    @Test
    public void deleteMiddleArgumentDeclarative(@NotNull JavaParser var1);

    @Test
    public void deleteMiddleArgument(@NotNull JavaParser var1);

    @Test
    public void deleteArgumentsConsecutively(@NotNull JavaParser var1);

    @Test
    public void doNotDeleteEmptyContainingFormatting(@NotNull JavaParser var1);

    @Test
    public void insertEmptyWhenLastArgumentIsDeleted(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void deleteMiddleArgumentDeclarative(@NotNull DeleteMethodArgumentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class A {{ B.foo(0, 2); }}";
            int n = 0;
            String string2 = "public class A {{ B.foo(0, 1, 2); }}";
            Recipe recipe2 = (Recipe)new DeleteMethodArgument("B foo(int, int, int)", Integer.valueOf(1));
            String[] stringArray = new String[]{"\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void deleteMiddleArgument(@NotNull DeleteMethodArgumentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class A {{ B.foo(0, 2); }}";
            int n = 0;
            String string2 = "public class A {{ B.foo(0, 1, 2); }}";
            Recipe recipe2 = (Recipe)new DeleteMethodArgument("B foo(int, int, int)", Integer.valueOf(1));
            String[] stringArray = new String[]{"\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void deleteArgumentsConsecutively(@NotNull DeleteMethodArgumentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class A {{ B.foo(0); }}";
            int n = 0;
            String string2 = "public class A {{ B.foo(0, 1, 2); }}";
            Recipe recipe2 = new DeleteMethodArgument("B foo(int, int, int)", Integer.valueOf(1)).doNext((Recipe)new DeleteMethodArgument("B foo(int, int, int)", Integer.valueOf(1)));
            String[] stringArray = new String[]{"\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void doNotDeleteEmptyContainingFormatting(@NotNull DeleteMethodArgumentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class A {{ B.foo( ); }}";
            Recipe recipe2 = (Recipe)new DeleteMethodArgument("B foo(..)", Integer.valueOf(0));
            String[] stringArray = new String[]{"\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        "};
            $this.assertUnchanged((Parser)jp, recipe2, string, stringArray);
        }

        @Test
        public static void insertEmptyWhenLastArgumentIsDeleted(@NotNull DeleteMethodArgumentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class A {{ B.foo(); }}";
            int n = 0;
            String string2 = "public class A {{ B.foo(1); }}";
            Recipe recipe2 = (Recipe)new DeleteMethodArgument("B foo(..)", Integer.valueOf(0));
            String[] stringArray = new String[]{"\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void checkValidation(@NotNull DeleteMethodArgumentTest $this) {
            Validated valid;
            DeleteMethodArgument recipe2 = new DeleteMethodArgument(null, null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("argumentIndex");
            Object e2 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e2).getProperty()).isEqualTo("methodPattern");
            recipe2 = new DeleteMethodArgument(null, Integer.valueOf(0));
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e3 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e3).getProperty()).isEqualTo("methodPattern");
            recipe2 = new DeleteMethodArgument("b.B foo()", null);
            Validated validated3 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated3, (String)"valid");
            Assertions.assertThat((boolean)validated3.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e4 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e4).getProperty()).isEqualTo("argumentIndex");
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull DeleteMethodArgumentTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull DeleteMethodArgumentTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull DeleteMethodArgumentTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull DeleteMethodArgumentTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull DeleteMethodArgumentTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/DeleteMethodArgumentTest$Companion;", "", "()V", "b", "", "rewrite-test"})
    public static final class Companion {
        private static final String b = "\n            class B {\n               public static void foo() {}\n               public static void foo(int n) {}\n               public static void foo(int n1, int n2) {}\n               public static void foo(int n1, int n2, int n3) {}\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

