/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanReturn;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/SimplifyBooleanReturnTest;", "Lorg/openrewrite/RecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "dontAlterWhenElseContainsSomethingOtherThanReturn", "", "jp", "Lorg/openrewrite/java/JavaParser;", "dontAlterWhenElseIfPresent", "dontSimplifyToReturnUnlessLastStatement", "nestedIfsWithNoBlock", "onlySimplifyToReturnWhenLastStatement", "simplifyBooleanReturn", "wrapNotReturnsOfTernaryIfConditionsInParentheses", "rewrite-test"})
public interface SimplifyBooleanReturnTest
extends RecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void simplifyBooleanReturn(@NotNull JavaParser var1);

    @Test
    public void dontSimplifyToReturnUnlessLastStatement(@NotNull JavaParser var1);

    @Test
    public void nestedIfsWithNoBlock(@NotNull JavaParser var1);

    @Test
    public void dontAlterWhenElseIfPresent(@NotNull JavaParser var1);

    @Test
    public void dontAlterWhenElseContainsSomethingOtherThanReturn(@NotNull JavaParser var1);

    @Test
    public void onlySimplifyToReturnWhenLastStatement(@NotNull JavaParser var1);

    @Test
    public void wrapNotReturnsOfTernaryIfConditionsInParentheses(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull SimplifyBooleanReturnTest $this) {
            return (Recipe)new SimplifyBooleanReturn();
        }

        @Test
        public static void simplifyBooleanReturn(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                boolean ifNoElse() {\n                    if (isOddMillis()) {\n                        return true;\n                    }\n                    return false;\n                }\n                \n                static boolean isOddMillis() {\n                    boolean even = System.currentTimeMillis() % 2 == 0;\n                    if (even == true) {\n                        return false;\n                    }\n                    else {\n                        return true;\n                    }\n                }\n            }\n        ", null, 0, "\n            public class A {\n                boolean ifNoElse() {\n                    return isOddMillis();\n                }\n                \n                static boolean isOddMillis() {\n                    boolean even = System.currentTimeMillis() % 2 == 0;\n                    return !(even == true);\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void dontSimplifyToReturnUnlessLastStatement(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public boolean absurdEquals(Object o) {\n                    if(this == o) {\n                        return true;\n                    }\n                    if(this == o) {\n                        return true;\n                    }\n                    return false;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                public boolean absurdEquals(Object o) {\n                    if(this == o) {\n                        return true;\n                    }\n                    return this == o;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void nestedIfsWithNoBlock(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public boolean absurdEquals(Object o) {\n                    if(this == o)\n                        if(this == null) \n                            return true;\n                    return false;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void dontAlterWhenElseIfPresent(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public boolean foo(int n) {\n                    if (n == 1) {\n                        return false;\n                    } \n                    else if (n == 2) {\n                        return true;\n                    } \n                    else {\n                        return false;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void dontAlterWhenElseContainsSomethingOtherThanReturn(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public boolean foo(int n) {\n                    if (n == 1) {\n                        return true;\n                    } \n                    else {\n                        System.out.println(\"side effect\");\n                        return false;\n                    } \n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void onlySimplifyToReturnWhenLastStatement(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.*;\n            public class A {\n                public static boolean deepEquals(List<byte[]> l, List<byte[]> r) {\n                    for (int i = 0; i < l.size(); ++i) {\n                        if (!Arrays.equals(l.get(i), r.get(i))) {\n                            return false;\n                        }\n                    }\n                    return true;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void wrapNotReturnsOfTernaryIfConditionsInParentheses(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                Object failure;\n                public boolean equals(Object o) {\n                    if (failure != null ? !failure.equals(this.failure) : this.failure != null) {\n                        return false;\n                    }\n                    return true;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                Object failure;\n                public boolean equals(Object o) {\n                    return !(failure != null ? !failure.equals(this.failure) : this.failure != null);\n                }\n            }\n        ", 26, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull SimplifyBooleanReturnTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull SimplifyBooleanReturnTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull SimplifyBooleanReturnTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull SimplifyBooleanReturnTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

