/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/UnwrapParenthesesTest;", "Lorg/openrewrite/RecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "unwrapAssignment", "", "jp", "Lorg/openrewrite/java/JavaParser;", "unwrapIfCondition", "rewrite-test"})
public interface UnwrapParenthesesTest
extends RecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void unwrapAssignment(@NotNull JavaParser var1);

    @Test
    public void unwrapIfCondition(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull UnwrapParenthesesTest $this) {
            return new Recipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        @NotNull
                        public <T extends J> J visitParentheses(@NotNull J.Parentheses<T> parens, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter(parens, (String)"parens");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            this.doAfterVisit((TreeVisitor)new UnwrapParentheses(parens));
                            J j = super.visitParentheses(parens, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitParentheses(parens, p)");
                            return j;
                        }
                    };
                }
            };
        }

        @Test
        public static void unwrapAssignment(@NotNull UnwrapParenthesesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                boolean a;\n                {\n                    a = (true);\n                }\n            }\n        ", null, 0, "\n            public class A {\n                boolean a;\n                {\n                    a = true;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void unwrapIfCondition(@NotNull UnwrapParenthesesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    if((true)) {}\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    if(true) {}\n                }\n            }\n        ", 26, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull UnwrapParenthesesTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull UnwrapParenthesesTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UnwrapParenthesesTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull UnwrapParenthesesTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

