/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\bf\u0018\u00002\u00020\u0001:\u0001\u001eJ-\u0010\u0002\u001a\u00020\u00032\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\"\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/RecipeTest;", "addImports", "Lorg/openrewrite/Recipe;", "adds", "", "Lorg/openrewrite/java/AddImport;", "Lorg/openrewrite/ExecutionContext;", "([Lorg/openrewrite/java/AddImport;)Lorg/openrewrite/Recipe;", "addMultipleImports", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticImportField", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "dontAddImportForPrimitive", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "FixEmptyListMethodType", "rewrite-test"})
public interface AddImportTest
extends RecipeTest {
    @NotNull
    public Recipe addImports(AddImport<ExecutionContext> ... var1);

    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void addStaticImportField(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00050\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/Recipe;", "()V", "getVisitor", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-test"})
    private static final class FixEmptyListMethodType
    extends Recipe {
        @NotNull
        protected TreeVisitor<?, ExecutionContext> getVisitor() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.MethodInvocation methodInvocation = super.visitMethodInvocation(method, (Object)ctx);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation, (String)"super.visitMethodInvocation(method, ctx)");
                    J.MethodInvocation original = methodInvocation;
                    J.Identifier identifier = original.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"original.name");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)"emptyList")) {
                        J.MethodInvocation methodInvocation2 = original.withSelect(null);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"original.withSelect(null)");
                        return methodInvocation2;
                    }
                    return original;
                }
            };
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Recipe addImports(@NotNull AddImportTest $this, AddImport<ExecutionContext> ... adds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            AddImport<ExecutionContext>[] $this$map$iv = adds;
            boolean $i$f$map = false;
            AddImport<ExecutionContext>[] addImportArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo2 = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void add;
                void item$iv$iv;
                void var11_12 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RecipeTest.AdHocRecipe adHocRecipe = RecipeTest.DefaultImpls.toRecipe$default($this, (JavaVisitor)add, false, 1, null);
                collection.add(adHocRecipe);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                void r2;
                RecipeTest.AdHocRecipe $i$f$mapTo2 = (RecipeTest.AdHocRecipe)((Object)iterator$iv.next());
                RecipeTest.AdHocRecipe r1 = (RecipeTest.AdHocRecipe)((Object)accumulator$iv);
                boolean bl = false;
                Recipe recipe2 = r1.doNext((Recipe)r2);
                Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"r1.doNext(r2)");
                return recipe2;
            }
            return (Recipe)accumulator$iv;
        }

        @Test
        public static void addMultipleImports(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false), new AddImport("java.util.Set", null, false)), "\n            class A {}\n        ", null, 0, "\n            import java.util.List;\n            import java.util.Set;\n\n            class A {}\n        ", 24, null);
        }

        @Test
        public static void addNamedImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false)), "class A {}", null, 0, "\n            import java.util.List;\n            \n            class A {}\n        ", 24, null);
        }

        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, true)), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.*", null, true)), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.Collections", "*", false)), "\n            import java.util.List;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", null, 0, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", 24, null);
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false)), "\n            package a;\n            class A {}\n        ", null, 0, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 24, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List otherPackages = CollectionsKt.listOf((Object[])new String[]{"c", "c.c", "c.c.c"});
            Iterable $this$mapIndexed$iv = otherPackages;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void pkg;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = "package " + (String)pkg + ";\npublic class C" + (int)i + " {}";
                collection.add(string2);
            }
            List otherImports = (List)destination$iv$iv;
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void pkg;
                void $this$mapIndexedTo$iv$iv2;
                Object item$iv$iv;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Pair pair = it;
                item$iv$iv = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable i = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                    void i2;
                    void otherPkg;
                    int n = index$iv$iv2++;
                    boolean bl3 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv$iv2;
                    int n3 = n;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string3 = (String)otherPkg + ".C" + (int)i2;
                    collection.add(string3);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, (String)pkg + ".B");
                RecipeTest recipeTest = $this;
                Parser parser = (Parser)jp;
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                spreadBuilder.addSpread((Object)stringArray);
                spreadBuilder.add((Object)("\n                            package " + (String)pkg + ";\n                            public class B {}\n                        "));
                String string = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.1.INSTANCE, (int)30, null) + "\n\nclass A {}";
                int n = 0;
                String string4 = "\n                    package a;\n        \n                    import c.C0;\n                    import c.c.C1;\n                    import c.c.c.C2;\n        \n                    class A {}\n                ";
                Recipe recipe2 = $this.addImports(new AddImport((String)pkg + ".B", null, false));
                String[] stringArray2 = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
                RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, recipe2, string4, stringArray2, n, string, 16, null);
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false)), "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false)), "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("C", null, false)), "class A {}", null, 8, null);
        }

        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("int", null, false)), "class A {}", null, 8, null);
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.List", null, false)), "\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", null, 0, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n            \n            class A {}\n        ", 24, null);
        }

        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.Collections", "emptyList", false)), "\n            import java.util.*;\n            class A {}\n        ", null, 0, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {}\n        ", 24, null);
        }

        @Test
        public static void addStaticImportField(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import static mycompany.Type.FIELD;\n            \n            class A {}\n        ";
            int n = 0;
            String string2 = "class A {}";
            String[] stringArray = new String[]{"\n                package mycompany;\n                public class Type {\n                    public static String FIELD;\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("mycompany.Type", "FIELD", false)), string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.Collections", "*", true)), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, new Recipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation m, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return m.withSelect(null);
                        }
                    };
                }
            }.doNext($this.addImports(new AddImport("java.util.Collections", "emptyList", true))), "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, 0, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 24, null);
        }

        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, $this.addImports(new AddImport("java.util.Collections", "emptyList", true)), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, new FixEmptyListMethodType().doNext($this.addImports(new AddImport("java.util.Collections", "*", true))), "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, 0, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 24, null);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull AddImportTest $this) {
            return RecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull AddImportTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull AddImportTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull AddImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull AddImportTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull AddImportTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull AddImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull AddImportTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

