/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/tree/TypeParameterAndWildcardTest;", "", "annotatedTypeParametersOnReturnTypeExpression", "", "jp", "Lorg/openrewrite/java/JavaParser;", "annotatedTypeParametersOnWildcardBounds", "emptyWildcard", "extendsAndSuper", "multipleExtends", "wildcardExtends", "Companion", "rewrite-test"})
public interface TypeParameterAndWildcardTest {
    public static final Companion Companion = org.openrewrite.java.tree.TypeParameterAndWildcardTest$Companion.$$INSTANCE;

    @Test
    public void annotatedTypeParametersOnWildcardBounds(@NotNull JavaParser var1);

    @Test
    public void annotatedTypeParametersOnReturnTypeExpression(@NotNull JavaParser var1);

    @Test
    public void extendsAndSuper(@NotNull JavaParser var1);

    @Test
    public void multipleExtends(@NotNull JavaParser var1);

    @Test
    public void wildcardExtends(@NotNull JavaParser var1);

    @Test
    public void emptyWildcard(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void annotatedTypeParametersOnWildcardBounds(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSource = "import java.util.List;\npublic class A {\n    List<? extends @NotNull B> checks;\n}";
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{aSource, "public class B {}"}).get(0);
            Assertions.assertEquals((Object)aSource, (Object)a.print());
        }

        @Test
        public static void annotatedTypeParametersOnReturnTypeExpression(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSource = "import java.util.List;\npublic class A {\n    public List<\n        @NotNull(groups = Prioritized.P1.class)\n        @javax.validation.Valid\n        B> foo() {\n        return null;\n    }\n}";
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{aSource, "public class B {}"}).get(0);
            Assertions.assertEquals((Object)aSource, (Object)a.print());
        }

        @Test
        public static void extendsAndSuper(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = (String[])ArraysKt.plus((Object[])new String[]{"\n            import java.util.List;\n            public class A {\n                public <P  extends B> void foo(List<P> out, List<? super C> in) {}\n            }\n        "}, (Collection)org.openrewrite.java.tree.TypeParameterAndWildcardTest$Companion.access$getBc$p(Companion));
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(Arrays.copyOf(stringArray, stringArray.length)).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"public <P  extends B> void foo(List<P> out, List<? super C> in) {}", (Object)((J.MethodDecl)((J.ClassDecl)e).getMethods().get(0)).printTrimmed());
        }

        @Test
        public static void multipleExtends(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = (String[])ArraysKt.plus((Object[])new String[]{"public class A< T extends  B & C > {}"}, (Collection)org.openrewrite.java.tree.TypeParameterAndWildcardTest$Companion.access$getBc$p(Companion));
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(Arrays.copyOf(stringArray, stringArray.length)).get(0);
            Assertions.assertEquals((Object)"public class A< T extends  B & C > {}", (Object)a.printTrimmed());
        }

        @Test
        public static void wildcardExtends(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List< ?  extends  B > bs;\n            }\n        ", "public class B {}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            TypeTree typeTree = ((J.VariableDecls)e2).getTypeExpr();
            if (typeTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ParameterizedType");
            }
            J.ParameterizedType typeParam = (J.ParameterizedType)typeTree;
            Assertions.assertEquals((Object)"List< ?  extends  B >", (Object)typeParam.print());
        }

        @Test
        public static void emptyWildcard(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List< ? > a;\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            TypeTree typeTree = ((J.VariableDecls)e2).getTypeExpr();
            if (typeTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ParameterizedType");
            }
            J.ParameterizedType typeParam = (J.ParameterizedType)typeTree;
            Assertions.assertEquals((Object)"List< ? >", (Object)typeParam.print());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/tree/TypeParameterAndWildcardTest$Companion;", "", "()V", "bc", "", "", "rewrite-test"})
    public static final class Companion {
        private static final List<String> bc;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            bc = CollectionsKt.listOf((Object[])new String[]{"public interface B {}", "public interface C {}"});
        }

        public static final /* synthetic */ List access$getBc$p(Companion $this) {
            Companion companion = $this;
            return bc;
        }
    }
}

