/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/tree/ForLoopTest;", "", "forLoop", "", "jp", "Lorg/openrewrite/java/JavaParser;", "format", "formatInfiniteLoop", "formatLoopNoCondition", "formatLoopNoInit", "infiniteLoop", "initializerIsAnAssignment", "multiVariableInitialization", "statementTerminatorForSingleLineForLoops", "rewrite-test"})
public interface ForLoopTest {
    @Test
    public void forLoop(@NotNull JavaParser var1);

    @Test
    public void infiniteLoop(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatInfiniteLoop(@NotNull JavaParser var1);

    @Test
    public void formatLoopNoInit(@NotNull JavaParser var1);

    @Test
    public void formatLoopNoCondition(@NotNull JavaParser var1);

    @Test
    public void statementTerminatorForSingleLineForLoops(@NotNull JavaParser var1);

    @Test
    public void initializerIsAnAssignment(@NotNull JavaParser var1);

    @Test
    public void multiVariableInitialization(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void forLoop(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for(int i = 0; i < 10; i++) {\n                    }\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)statement;
            J.ForLoop.Control control = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control, (String)"forLoop.control");
            Assertions.assertTrue((boolean)(control.getInit() instanceof J.VariableDecls));
            J.ForLoop.Control control2 = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control2, (String)"forLoop.control");
            Assertions.assertTrue((boolean)(control2.getCondition() instanceof J.Binary));
            J.ForLoop.Control control3 = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control3, (String)"forLoop.control");
            Assertions.assertEquals((int)1, (int)control3.getUpdate().size());
        }

        @Test
        public static void infiniteLoop(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for(;;) {\n                    }\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)statement;
            J.ForLoop.Control control = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control, (String)"forLoop.control");
            Assertions.assertTrue((boolean)(control.getInit() instanceof J.Empty));
            J.ForLoop.Control control2 = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control2, (String)"forLoop.control");
            Assertions.assertTrue((boolean)(control2.getCondition() instanceof J.Empty));
            J.ForLoop.Control control3 = forLoop.getControl();
            Intrinsics.checkNotNullExpressionValue((Object)control3, (String)"forLoop.control");
            Assertions.assertTrue((boolean)(control3.getUpdate().get(0) instanceof J.Empty));
        }

        @Test
        public static void format(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for ( int i = 0 ; i < 10 ; i++ ) {\n                    }\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)statement;
            Assertions.assertEquals((Object)"for ( int i = 0 ; i < 10 ; i++ ) {\n}", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void formatInfiniteLoop(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for ( ; ; ) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)statement;
            Assertions.assertEquals((Object)"for ( ; ; ) {}", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void formatLoopNoInit(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    int i = 0;\n                    for ( ; i < 10 ; i++ ) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Object e3 = block.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)e3;
            Assertions.assertEquals((Object)"for ( ; i < 10 ; i++ ) {}", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void formatLoopNoCondition(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    int i = 0;\n                    for(; i < 10; i++) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Object e3 = block.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)e3;
            Assertions.assertEquals((Object)"for(; i < 10; i++) {}", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void statementTerminatorForSingleLineForLoops(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for(;;) test();\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop forLoop = (J.ForLoop)e3;
            Assertions.assertEquals((Object)"for(;;) test();", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void initializerIsAnAssignment(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int[] a;\n                public void test() {\n                    int i=0;\n                    for(i=0; i<a.length; i++) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Statement forLoop = (Statement)block.getStatements().get(1);
            Assertions.assertEquals((Object)"for(i=0; i<a.length; i++) {}", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void multiVariableInitialization(@NotNull ForLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    for(int i, j = 0;;) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Assertions.assertEquals((Object)"for(int i, j = 0;;) {}", (Object)((Statement)block.getStatements().get(0)).printTrimmed());
        }
    }
}

