/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/MethodMatcherTest;", "", "argRegex", "Lkotlin/text/Regex;", "signature", "", "dotDotMatchesArrayArgs", "", "jp", "Lorg/openrewrite/java/JavaParser;", "matchesArguments", "matchesArgumentsWithDotDot", "matchesArgumentsWithWildcards", "matchesArrayArguments", "matchesConstructorUsage", "matchesMethod", "matchesMethodName", "matchesMethodSymbolsWithVarargs", "matchesMethodTargetType", "matchesPrimitiveArgument", "matchesSuperclassArgumentTypes", "matchesSuperclassType", "matchesUnqualifiedJavaLangArguments", "nameRegex", "typeRegex", "rewrite-test"})
public interface MethodMatcherTest {
    @NotNull
    public Regex typeRegex(@NotNull String var1);

    @NotNull
    public Regex nameRegex(@NotNull String var1);

    @NotNull
    public Regex argRegex(@NotNull String var1);

    @Test
    public void matchesSuperclassType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodTargetType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodName(@NotNull JavaParser var1);

    @Test
    public void matchesArguments(@NotNull JavaParser var1);

    @Test
    public void matchesUnqualifiedJavaLangArguments(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithWildcards(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithDotDot(@NotNull JavaParser var1);

    @Test
    public void matchesSuperclassArgumentTypes(@NotNull JavaParser var1);

    @Test
    public void matchesMethodSymbolsWithVarargs(@NotNull JavaParser var1);

    @Test
    public void dotDotMatchesArrayArgs(@NotNull JavaParser var1);

    @Test
    public void matchesArrayArguments(@NotNull JavaParser var1);

    @Test
    @Disabled(value="Reproduces issue https://github.com/openrewrite/rewrite/issues/28")
    public void matchesPrimitiveArgument(@NotNull JavaParser var1);

    @Test
    public void matchesConstructorUsage(@NotNull JavaParser var1);

    @Test
    public void matchesMethod(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Regex typeRegex(@NotNull MethodMatcherTest $this, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getTargetTypePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).targetTypePattern");
            Pattern pattern2 = pattern;
            boolean bl = false;
            return new Regex(pattern2);
        }

        @NotNull
        public static Regex nameRegex(@NotNull MethodMatcherTest $this, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getMethodNamePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).methodNamePattern");
            Pattern pattern2 = pattern;
            boolean bl = false;
            return new Regex(pattern2);
        }

        @NotNull
        public static Regex argRegex(@NotNull MethodMatcherTest $this, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getArgumentPattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).argumentPattern");
            Pattern pattern2 = pattern;
            boolean bl = false;
            return new Regex(pattern2);
        }

        @Test
        public static void matchesSuperclassType(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodTargetType(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.typeRegex("*..MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)$this.typeRegex("MyClass foo()").matches((CharSequence)"MyClass"));
            Assertions.assertTrue((boolean)$this.typeRegex("com.bar.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)$this.typeRegex("com.*.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
        }

        @Test
        public static void matchesMethodName(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.nameRegex("A foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)$this.nameRegex("A *()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)$this.nameRegex("A fo*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)$this.nameRegex("A *oo()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesArguments(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo()").matches((CharSequence)""));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(java.util.Map)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesUnqualifiedJavaLangArguments(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo(String)").matches((CharSequence)"java.lang.String"));
        }

        @Test
        public static void matchesArgumentsWithWildcards(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo(java.util.*)").matches((CharSequence)"java.util.Map"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(java..*)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesArgumentsWithDotDot(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo(.., int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(.., int)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(int, ..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(int, ..)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(..)").matches((CharSequence)""));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(..)").matches((CharSequence)"int,int"));
        }

        @Test
        public static void matchesSuperclassArgumentTypes(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodSymbolsWithVarargs(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.argRegex("A foo(String, Object...)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void dotDotMatchesArrayArgs(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.argRegex("A foo(..)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void matchesArrayArguments(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo(String[])").matches((CharSequence)"java.lang.String[]"));
        }

        @Test
        @Disabled(value="Reproduces issue https://github.com/openrewrite/rewrite/issues/28")
        public static void matchesPrimitiveArgument(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)$this.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)$this.argRegex("A foo(int[])").matches((CharSequence)"int[]"));
            Assertions.assertFalse((boolean)$this.argRegex("A foo(int[])").matches((CharSequence)"int"));
        }

        @Test
        public static void matchesConstructorUsage(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(new String[]{"package a;\n\nclass A { \n    {\n        A a = new A(); \n    }\n}"}).get(0);
            MethodMatcher methodMatcher = new MethodMatcher("a.A A()");
            J.CompilationUnit compilationUnit = cu;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"cu");
            List list = compilationUnit.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes.first()");
            J.Block block = ((J.ClassDecl)object).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu.classes.first().body");
            List list2 = block.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object2 = CollectionsKt.first((List)list2);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<*>");
            }
            List list3 = ((J.Block)object2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"(cu.classes.first().body\u2026              .statements");
            Object object3 = CollectionsKt.first((List)list3);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            List list4 = ((J.VariableDecls)object3).getVars();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"((cu.classes.first().bod\u2026 as J.VariableDecls).vars");
            Object object4 = CollectionsKt.first((List)list4);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"((cu.classes.first().bod\u2026riableDecls).vars.first()");
            Expression expression = ((J.VariableDecls.NamedVar)object4).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            Assertions.assertTrue((boolean)methodMatcher.matches((J.NewClass)expression));
        }

        @Test
        public static void matchesMethod(@NotNull MethodMatcherTest $this, @NotNull JavaParser jp) {
            J.ClassDecl classDecl;
            J.CompilationUnit cu;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List list = jp.parse(new String[]{"package a;\n\nclass A {\n    void setInt(int value) {}\n    int getInt() {}\n    void setInteger(Integer value) {}\n    Integer getInteger(){}\n}"});
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\"\"\"\n           \u2026        \"\"\".trimIndent())");
            J.CompilationUnit compilationUnit = cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"cu");
            List list2 = compilationUnit.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDecl classDecl2 = classDecl = (J.ClassDecl)CollectionsKt.first((List)list2);
            Intrinsics.checkNotNullExpressionValue((Object)classDecl2, (String)"classDecl");
            J.Block block = classDecl2.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"classDecl.body");
            Object e = block.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.MethodDecl setIntMethod = (J.MethodDecl)e;
            J.Block block2 = classDecl.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"classDecl.body");
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.MethodDecl getIntMethod = (J.MethodDecl)e2;
            J.Block block3 = classDecl.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"classDecl.body");
            Object e3 = block3.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.MethodDecl setIntegerMethod = (J.MethodDecl)e3;
            J.Block block4 = classDecl.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"classDecl.body");
            Object e4 = block4.getStatements().get(3);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.MethodDecl getIntegerMethod = (J.MethodDecl)e4;
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInt(int)").matches(setIntMethod, classDecl));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInt()").matches(getIntMethod, classDecl));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInteger(Integer)").matches(setIntegerMethod, classDecl));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInteger()").matches(getIntegerMethod, classDecl));
        }
    }
}

