/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest;", "", "annotationEquality", "", "jp", "Lorg/openrewrite/java/JavaParser;", "assignEquality", "fieldAccessEquality", "identEquality", "literalEquality", "tagAnnotationEquality", "rewrite-test"})
public interface SemanticallyEqualTest {
    @Test
    public void tagAnnotationEquality(@NotNull JavaParser var1);

    @Test
    public void annotationEquality(@NotNull JavaParser var1);

    @Test
    public void identEquality(@NotNull JavaParser var1);

    @Test
    public void fieldAccessEquality(@NotNull JavaParser var1);

    @Test
    public void assignEquality(@NotNull JavaParser var1);

    @Test
    public void literalEquality(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void tagAnnotationEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @Tag(FastTests.class)\n                @Tag(FastTests.class)\n                @Tag(SlowTests.class)\n                class A {}\n            ", "\n                @interface Tags {\n                    Tag[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Tags.class)\n                @interface Tag {\n                    Class value();\n                }\n            ", "public interface FastTests {}", "public interface SlowTests {}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Annotation fastTest = (J.Annotation)((J.ClassDecl)e2).getAnnotations().get(0);
            Object e3 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0]");
            Object e4 = ((J.CompilationUnit)e3).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"cu[0].classes[0]");
            J.Annotation fastTest2 = (J.Annotation)((J.ClassDecl)e4).getAnnotations().get(1);
            Object e5 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"cu[0]");
            Object e6 = ((J.CompilationUnit)e5).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0].classes[0]");
            J.Annotation slowTest = (J.Annotation)((J.ClassDecl)e6).getAnnotations().get(2);
            Object object = new SemanticallyEqual((Tree)fastTest).visit((Tree)fastTest2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(fastTest).visit(fastTest2)");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
            Object object2 = new SemanticallyEqual((Tree)fastTest).visit((Tree)slowTest);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SemanticallyEqual(fastTest).visit(slowTest)");
            Assertions.assertThat((boolean)((Boolean)object2)).isFalse();
        }

        @Test
        public static void annotationEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class A {}\n            ", "\n                @interface MyAnnotation { \n                    boolean value();\n                    String srcValue(); \n                }\n            "});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Annotation annotation = (J.Annotation)((J.ClassDecl)e2).getAnnotations().get(0);
            jp.reset();
            Object e3 = jp.parse(new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class B {}\n            ", "\n                @interface MyAnnotation { \n                    boolean value();\n                    String srcValue(); \n                }\n            "}).get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"jp.parse(\n            \"\"\u2026         \"\"\"\n        )[0]");
            Object e4 = ((J.CompilationUnit)e3).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"jp.parse(\n            \"\"\u2026\"\n        )[0].classes[0]");
            J.Annotation otherAnnot = (J.Annotation)((J.ClassDecl)e4).getAnnotations().get(0);
            Object object = new SemanticallyEqual((Tree)annotation).visit((Tree)otherAnnot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(annotation).visit(otherAnnot)");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
        }

        @Test
        public static void identEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDecl)e2).getAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].annotations[0]");
            NameTree ident = ((J.Annotation)e3).getAnnotationType();
            Object object = new SemanticallyEqual((Tree)ident).visit((Tree)J.Ident.build((UUID)Tree.randomId(), (String)"MyAnnotation", (JavaType)JavaType.buildType((String)"MyAnnotation"), (Formatting)Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(ident)\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
            Object object2 = new SemanticallyEqual((Tree)ident).visit((Tree)J.Ident.build((UUID)Tree.randomId(), (String)"YourAnnotation", (JavaType)JavaType.buildType((String)"YourAnnotation"), (Formatting)Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SemanticallyEqual(ident)\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object2)).isFalse();
        }

        @Test
        public static void fieldAccessEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @Category(FastTest.class)\n                class A {\n                }\n            ", "@interface Category { Class<?>[] value(); }", "class FastTest {}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDecl)e2).getAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].annotations[0]");
            J.Annotation.Arguments arguments = ((J.Annotation)e3).getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"cu[0].classes[0].annotations[0].args");
            Expression annotFieldAccess = (Expression)arguments.getArgs().get(0);
            Object object = new SemanticallyEqual((Tree)annotFieldAccess).visit((Tree)new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"FastTest", (JavaType)JavaType.buildType((String)"FastTest"), (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), JavaType.buildType((String)"java.lang.Class"), Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(annotF\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
            Object object2 = new SemanticallyEqual((Tree)annotFieldAccess).visit((Tree)new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"SlowTest", (JavaType)JavaType.buildType((String)"SlowTest"), (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), JavaType.buildType((String)"java.lang.Class"), Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SemanticallyEqual(annotF\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object2)).isFalse();
        }

        @Test
        public static void assignEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDecl)e2).getAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].annotations[0]");
            J.Annotation.Arguments arguments = ((J.Annotation)e3).getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"cu[0].classes[0].annotations[0].args");
            Expression assign = (Expression)arguments.getArgs().get(0);
            Object object = new SemanticallyEqual((Tree)assign).visit((Tree)new J.Assign(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"value", null, (Formatting)Formatting.EMPTY), (Expression)new J.Literal(Tree.randomId(), (Object)true, "true", JavaType.Primitive.Boolean, Formatting.EMPTY), (JavaType)JavaType.Primitive.Boolean, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(assign\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
            Object object2 = new SemanticallyEqual((Tree)assign).visit((Tree)new J.Assign(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"otherValue", null, (Formatting)Formatting.EMPTY), (Expression)new J.Literal(Tree.randomId(), (Object)true, "true", JavaType.Primitive.Boolean, Formatting.EMPTY), (JavaType)JavaType.Primitive.Boolean, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SemanticallyEqual(assign\u2026Y\n            )\n        )");
            Assertions.assertThat((boolean)((Boolean)object2)).isFalse();
            Object object3 = new SemanticallyEqual((Tree)assign).visit((Tree)new J.Assign(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"value", null, (Formatting)Formatting.EMPTY), (Expression)new J.Literal(Tree.randomId(), (Object)false, "true", JavaType.Primitive.Boolean, Formatting.EMPTY), (JavaType)JavaType.Primitive.Boolean, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"SemanticallyEqual(assign\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object3)).isFalse();
        }

        @Test
        public static void literalEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                class A {\n                    int i = 0;\n                    String str = \"thisString\";\n                    String str2 = null;\n                }\n            "});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e4 = ((J.VariableDecls)e3).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"(cu[0].classes[0].body.s\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e4).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal intLiteral = (J.Literal)expression;
            Object e5 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"cu[0]");
            Object e6 = ((J.CompilationUnit)e5).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0].classes[0]");
            J.Block block2 = ((J.ClassDecl)e6).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"cu[0].classes[0].body");
            Object e7 = block2.getStatements().get(1);
            if (e7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e8 = ((J.VariableDecls)e7).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e8, (String)"(cu[0].classes[0].body.s\u2026 J.VariableDecls).vars[0]");
            Expression expression2 = ((J.VariableDecls.NamedVar)e8).getInitializer();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal strLiteral = (J.Literal)expression2;
            Object e9 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e9, (String)"cu[0]");
            Object e10 = ((J.CompilationUnit)e9).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e10, (String)"cu[0].classes[0]");
            J.Block block3 = ((J.ClassDecl)e10).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"cu[0].classes[0].body");
            Object e11 = block3.getStatements().get(2);
            if (e11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e12 = ((J.VariableDecls)e11).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e12, (String)"(cu[0].classes[0].body.s\u2026 J.VariableDecls).vars[0]");
            Expression expression3 = ((J.VariableDecls.NamedVar)e12).getInitializer();
            if (expression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal nullLiteral = (J.Literal)expression3;
            Object object = new SemanticallyEqual((Tree)intLiteral).visit((Tree)new J.Literal(Tree.randomId(), (Object)0, "0", JavaType.Primitive.Int, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SemanticallyEqual(intLit\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object)).isTrue();
            Object object2 = new SemanticallyEqual((Tree)strLiteral).visit((Tree)new J.Literal(Tree.randomId(), (Object)"thisString", "thisString", JavaType.Primitive.String, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SemanticallyEqual(strLit\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object2)).isTrue();
            Object object3 = new SemanticallyEqual((Tree)nullLiteral).visit((Tree)new J.Literal(Tree.randomId(), null, "null", JavaType.Primitive.String, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"SemanticallyEqual(nullLi\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object3)).isTrue();
            Object object4 = new SemanticallyEqual((Tree)strLiteral).visit((Tree)new J.Literal(Tree.randomId(), (Object)0, "0", JavaType.Primitive.Int, Formatting.EMPTY));
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"SemanticallyEqual(strLit\u2026          )\n            )");
            Assertions.assertThat((boolean)((Boolean)object4)).isFalse();
        }
    }
}

