/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/NewClassTest;", "", "anonymousInnerClass", "", "jp", "Lorg/openrewrite/java/JavaParser;", "concreteClassWithParams", "concreteInnerClass", "format", "formatRawType", "Companion", "rewrite-test"})
public interface NewClassTest {
    public static final Companion Companion = org.openrewrite.java.tree.NewClassTest$Companion.$$INSTANCE;

    @Test
    public void anonymousInnerClass(@NotNull JavaParser var1);

    @Test
    public void concreteInnerClass(@NotNull JavaParser var1);

    @Test
    public void concreteClassWithParams(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatRawType(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void anonymousInnerClass(NewClassTest $this, @NotNull JavaParser jp) {
            J.VariableDecls.NamedVar b;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String c = "\n            import a.*;\n            public class C {\n                A.B anonB = new A.B() {};\n            }\n        ";
            Object e = jp.parse(new String[]{c, Companion.getA()}).get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"jp.parse(c, a)[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"jp.parse(c, a)[0].classes[0]");
            Object e3 = ((J.ClassDecl)e2).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"jp.parse(c, a)[0].classes[0].fields[0]");
            J.VariableDecls.NamedVar namedVar = b = (J.VariableDecls.NamedVar)((J.VariableDecls)e3).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)namedVar, (String)"b");
            JavaType.Class clazz = TestKt.asClass(namedVar.getType());
            Assertions.assertEquals((Object)"a.A.B", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
        }

        @Test
        public static void concreteInnerClass(NewClassTest $this, @NotNull JavaParser jp) {
            J.VariableDecls.NamedVar b;
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String c = "\n            import a.*;\n            public class C {\n                A.B anonB = new A.B();\n            }\n        ";
            J.CompilationUnit compilationUnit = cu = (J.CompilationUnit)jp.parse(new String[]{c, Companion.getA()}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"cu.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"cu.classes[0].fields[0]");
            J.VariableDecls.NamedVar namedVar = b = (J.VariableDecls.NamedVar)((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)namedVar, (String)"b");
            JavaType.Class clazz = TestKt.asClass(namedVar.getType());
            Assertions.assertEquals((Object)"a.A.B", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            Expression expression = b.getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            TypeTree typeTree = ((J.NewClass)expression).getClazz();
            Assertions.assertEquals((Object)"A.B", (Object)(typeTree != null ? typeTree.printTrimmed() : null));
        }

        @Test
        public static void concreteClassWithParams(NewClassTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                Object l = new ArrayList<String>(0);\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            J.NewClass newClass = (J.NewClass)expression;
            Object object = newClass.getArgs();
            Assertions.assertEquals((int)1, object != null && (object = object.getArgs()) != null ? Integer.valueOf(object.size()) : null);
        }

        @Test
        public static void format(NewClassTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                Object l = new ArrayList< String > ( 0 ) { };\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            J.NewClass newClass = (J.NewClass)expression;
            Assertions.assertEquals((Object)"new ArrayList< String > ( 0 ) { }", (Object)newClass.printTrimmed());
        }

        @Test
        public static void formatRawType(NewClassTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List<String> l = new ArrayList < > ();\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            J.NewClass newClass = (J.NewClass)expression;
            Assertions.assertEquals((Object)"new ArrayList < > ()", (Object)newClass.printTrimmed());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/NewClassTest$Companion;", "", "()V", "a", "", "getA", "()Ljava/lang/String;", "rewrite-test"})
    public static final class Companion {
        @NotNull
        private static final String a = "\n            package a;\n            public class A {\n               public static class B { }\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final String getA() {
            return a;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            a = a;
        }
    }
}

