/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/JavaTypeTest;", "", "innerClassType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "isAssignableFrom", "memberVisibility", "packageName", "sameFullyQualifiedNameWithDifferentMembers", "sameFullyQualifiedNameWithDifferentTypeHierarchy", "selfReferentialTypeIsShared", "typeFlyweightsAreSharedBetweenParsers", "rewrite-test"})
public interface JavaTypeTest {
    @Test
    public void memberVisibility(@NotNull JavaParser var1);

    @Disabled(value="flaky on collection.isAssignableFrom(list)")
    @Test
    public void isAssignableFrom(@NotNull JavaParser var1);

    @Test
    public void innerClassType(@NotNull JavaParser var1);

    @Test
    public void packageName(@NotNull JavaParser var1);

    @Test
    public void selfReferentialTypeIsShared(@NotNull JavaParser var1);

    @Test
    public void typeFlyweightsAreSharedBetweenParsers(@NotNull JavaParser var1);

    @Test
    public void sameFullyQualifiedNameWithDifferentMembers(@NotNull JavaParser var1);

    @Test
    public void sameFullyQualifiedNameWithDifferentTypeHierarchy(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void memberVisibility(JavaTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String b = "public class B {\n    protected int n;\n}";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public class A extends B {\n}", b}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            JavaType.Class clazz = TestKt.asClass(((J.ClassDecl)e).getType());
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            JavaType.Class clazz2 = clazz.getSupertype();
            if (clazz2 == null) {
                Intrinsics.throwNpe();
            }
            Object e2 = clazz2.getMembers().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].type.asClas\u2026!!.supertype!!.members[0]");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((JavaType.Var)e2).getFlags().contains(Flag.Protected));
        }

        /*
         * WARNING - void declaration
         */
        @Disabled(value="flaky on collection.isAssignableFrom(list)")
        @Test
        public static void isAssignableFrom(JavaTypeTest $this, @NotNull JavaParser jp) {
            void listArr;
            void list;
            void $this$mapTo$iv$iv;
            JavaType.Class clazz;
            Collection collection;
            void $this$mapTo$iv$iv2;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\nimport java.util.Collection;\npublic class A {\n    public List[] listArr;\n    public Collection[] collArr;\n}"}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list2 = compilationUnit.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"a.imports");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                J.Import import_ = (J.Import)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                J.FieldAccess fieldAccess = v2.getQualid();
                Intrinsics.checkExpressionValueIsNotNull((Object)fieldAccess, (String)"it.qualid");
                if (TypeUtils.asClass((JavaType)fieldAccess.getType()) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(clazz);
            }
            List list3 = (List)destination$iv$iv;
            $this$map$iv = list3;
            boolean bl = false;
            JavaType.Class clazz2 = (JavaType.Class)$this$map$iv.get(0);
            $this$map$iv = list3;
            bl = false;
            JavaType.Class collection2 = (JavaType.Class)$this$map$iv.get(1);
            Object e = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            List list4 = ((J.ClassDecl)e).getFields();
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"a.classes[0].fields");
            Iterable $this$map$iv2 = list4;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void v6 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                TypeTree typeTree = v6.getTypeExpr();
                if (typeTree == null) {
                    Intrinsics.throwNpe();
                }
                if (TypeUtils.asClass((JavaType)typeTree.getType()) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(clazz);
            }
            List list5 = (List)destination$iv$iv2;
            iterable = list5;
            boolean bl3 = false;
            list3 = (JavaType.Class)iterable.get(0);
            iterable = list5;
            bl3 = false;
            JavaType.Class collectionArr = (JavaType.Class)iterable.get(1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)collection2.isAssignableFrom((JavaType.Class)list));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isAssignableFrom(collection2));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)JavaType.Class.OBJECT.isAssignableFrom(collection2));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)collectionArr.isAssignableFrom((JavaType.Class)listArr));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)listArr.isAssignableFrom(collectionArr));
        }

        @Test
        public static void innerClassType(JavaTypeTest $this, @NotNull JavaParser jp) {
            JavaType.Class t;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            JavaType.Class clazz = t = JavaType.Class.build((String)"com.foo.Foo.Bar");
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"t");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"com.foo.Foo.Bar", (Object)clazz.getFullyQualifiedName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"com.foo", (Object)t.getPackageName());
        }

        @Test
        public static void packageName(JavaTypeTest $this, @NotNull JavaParser jp) {
            JavaType.Class c;
            JavaType.Class b;
            JavaType.Class a;
            JavaType.Class t;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            JavaType.Class clazz = t = JavaType.Class.build((String)"com.foo.Foo");
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"t");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"com.foo", (Object)clazz.getPackageName());
            JavaType.Class clazz2 = a = JavaType.Class.build((String)"a.A1");
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"a");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)clazz2.getPackageName());
            JavaType.Class clazz3 = b = JavaType.Class.build((String)"a.A.B");
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz3, (String)"b");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)clazz3.getPackageName());
            JavaType.Class clazz4 = c = JavaType.Class.build((String)"A.C");
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz4, (String)"c");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)clazz4.getPackageName());
        }

        @Test
        public static void selfReferentialTypeIsShared(JavaTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public class A { A a; }"}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            JavaType outerType = ((J.ClassDecl)e).getType();
            Object e2 = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0]");
            Object e3 = ((J.ClassDecl)e2).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0]");
            TypeTree typeTree = ((J.VariableDecls)e3).getTypeExpr();
            JavaType fieldType = typeTree != null ? typeTree.getType() : null;
            org.junit.jupiter.api.Assertions.assertTrue((outerType == fieldType ? 1 : 0) != 0);
        }

        @Test
        public static void typeFlyweightsAreSharedBetweenParsers(JavaTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"public class A {}"}).get(0);
            J.CompilationUnit a2 = (J.CompilationUnit)jp.reset().parse(new String[]{"public class A {}"}).get(0);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            JavaType t1 = ((J.ClassDecl)e).getType();
            J.CompilationUnit compilationUnit2 = a2;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"a2");
            Object e2 = compilationUnit2.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a2.classes[0]");
            JavaType t2 = ((J.ClassDecl)e2).getType();
            Assertions.assertThat((Object)t1).isSameAs((Object)t2);
        }

        @Test
        public static void sameFullyQualifiedNameWithDifferentMembers(JavaTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"public class A { String foo; }"}).get(0);
            J.CompilationUnit a2 = (J.CompilationUnit)jp.reset().parse(new String[]{"public class A { String bar; }"}).get(0);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            JavaType javaType = ((J.ClassDecl)e).getType();
            J.CompilationUnit compilationUnit2 = a2;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"a2");
            Object e2 = compilationUnit2.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a2.classes[0]");
            org.junit.jupiter.api.Assertions.assertTrue((javaType != ((J.ClassDecl)e2).getType() ? 1 : 0) != 0);
        }

        @Test
        public static void sameFullyQualifiedNameWithDifferentTypeHierarchy(JavaTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A extends B {}\n            class B {}\n        "}).get(0);
            J.CompilationUnit a2 = (J.CompilationUnit)jp.reset().parse(new String[]{"\n            public class A {}\n            class B {}\n        "}).get(0);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            JavaType javaType = ((J.ClassDecl)e).getType();
            J.CompilationUnit compilationUnit2 = a2;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"a2");
            Object e2 = compilationUnit2.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a2.classes[0]");
            org.junit.jupiter.api.Assertions.assertTrue((javaType != ((J.ClassDecl)e2).getType() ? 1 : 0) != 0);
        }
    }
}

