/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/BreakTest;", "", "breakFromLabeledWhileLoop", "", "jp", "Lorg/openrewrite/java/JavaParser;", "breakFromWhileLoop", "formatLabeledBreak", "rewrite-test"})
public interface BreakTest {
    @Test
    public void breakFromWhileLoop(@NotNull JavaParser var1);

    @Test
    public void breakFromLabeledWhileLoop(@NotNull JavaParser var1);

    @Test
    public void formatLabeledBreak(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void breakFromWhileLoop(BreakTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    while(true) break;\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement;
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Break));
            Statement statement2 = whileLoop.getBody();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Break");
            }
            Assertions.assertNull((Object)((J.Break)statement2).getLabel());
        }

        @Test
        public static void breakFromLabeledWhileLoop(BreakTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    labeled: while(true)\n                        break labeled;\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement2 = ((J.Label)statement).getStatement();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement2;
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Break));
            Statement statement3 = whileLoop.getBody();
            if (statement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Break");
            }
            J.Ident ident = ((J.Break)statement3).getLabel();
            Assertions.assertEquals((Object)"labeled", (Object)(ident != null ? ident.getSimpleName() : null));
        }

        @Test
        public static void formatLabeledBreak(BreakTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    labeled : while(true)\n                        break labeled;\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement2 = ((J.Label)statement).getStatement();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement2;
            Assertions.assertEquals((Object)"break labeled", (Object)whileLoop.getBody().printTrimmed());
        }
    }
}

