/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/search/FindMethodTest;", "", "findStaticMethodCalls", "", "jp", "Lorg/openrewrite/java/JavaParser;", "findStaticallyImportedMethodCalls", "matchOnInnerClass", "matchVarargs", "rewrite-test"})
public interface FindMethodTest {
    @Test
    public void findStaticMethodCalls(@NotNull JavaParser var1);

    @Test
    public void findStaticallyImportedMethodCalls(@NotNull JavaParser var1);

    @Test
    public void matchVarargs(@NotNull JavaParser var1);

    @Test
    public void matchOnInnerClass(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void findStaticMethodCalls(FindMethodTest $this, @NotNull JavaParser jp) {
            J.MethodInvocation m;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.Collections;\n            public class A {\n               Object o = Collections.emptyList();\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findMethodCalls("java.util.Collections emptyList()");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findMethodC\u2026Collections emptyList()\")");
            J.MethodInvocation methodInvocation = m = (J.MethodInvocation)CollectionsKt.first((List)list);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodInvocation, (String)"m");
            Assertions.assertEquals((Object)"emptyList", (Object)methodInvocation.getSimpleName());
            Assertions.assertEquals((Object)"Collections.emptyList()", (Object)m.printTrimmed());
        }

        @Test
        public static void findStaticallyImportedMethodCalls(FindMethodTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import static java.util.Collections.emptyList;\n            public class A {\n               Object o = emptyList();\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findMethodCalls("java.util.Collections emptyList()");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findMethodC\u2026Collections emptyList()\")");
            J.MethodInvocation m = (J.MethodInvocation)CollectionsKt.firstOrNull((List)list);
            J.MethodInvocation methodInvocation = m;
            JavaType.Class clazz = TestKt.asClass((JavaType)(methodInvocation != null && (methodInvocation = methodInvocation.getType()) != null ? methodInvocation.getDeclaringType() : null));
            Assertions.assertEquals((Object)"java.util.Collections", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
        }

        @Test
        public static void matchVarargs(FindMethodTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            public class A {\n                public void foo(String s, Object... o) {}\n            }\n        ";
            String b = "\n            public class B {\n               public void test() {\n                   new A().foo(\"s\", \"a\", 1);\n               }\n            }\n        ";
            Object e = jp.parse(new String[]{b, a}).get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"jp.parse(b, a)[0]");
            List list = ((J.ClassDecl)((J.CompilationUnit)e).getClasses().get(0)).findMethodCalls("A foo(String, Object...)");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jp.parse(b, a)[0].classe\u2026 foo(String, Object...)\")");
            Collection collection = list;
            boolean bl = false;
            Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
        }

        @Test
        public static void matchOnInnerClass(FindMethodTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String b = "\n            public class B {\n               public static class C {\n                   public void foo() {}\n               }\n            }\n        ";
            String a = "\n            public class A {\n               void test() {\n                   new B.C().foo();\n               }\n            }\n        ";
            Object e = jp.parse(new String[]{a, b}).get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"jp.parse(a, b)[0]");
            Assertions.assertEquals((int)1, (int)((J.ClassDecl)((J.CompilationUnit)e).getClasses().get(0)).findMethodCalls("B.C foo()").size());
        }
    }
}

