/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/search/HasImportTest;", "", "hasImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "hasStarImport", "hasStarImportOnInnerClass", "rewrite-test"})
public interface HasImportTest {
    @Test
    public void hasImport(@NotNull JavaParser var1);

    @Test
    public void hasStarImport(@NotNull JavaParser var1);

    @Test
    public void hasStarImportOnInnerClass(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void hasImport(HasImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("\n            import java.util.List;\n            class A {}\n        ", new String[0]);
            Assertions.assertTrue((boolean)a.hasImport("java.util.List"));
            Assertions.assertFalse((boolean)a.hasImport("java.util.Set"));
        }

        @Test
        public static void hasStarImport(HasImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("\n            import java.util.*;\n            class A {}\n        ", new String[0]);
            Assertions.assertTrue((boolean)a.hasImport("java.util.List"));
        }

        @Test
        public static void hasStarImportOnInnerClass(HasImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public static class B { }\n            }\n        ";
            String c = "\n            import a.*;\n            public class C {\n                A.B b = new A.B();\n            }\n        ";
            Assertions.assertTrue((boolean)jp.parse(c, a).hasImport("a.A.B"));
            Assertions.assertTrue((boolean)jp.parse(c, a).hasImport("a.A"));
        }
    }
}

