/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/search/FindTypeTest;", "", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "classDecl", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "multiCatch", "multiVariable", "newClass", "paramaterizedType", "simpleName", "typeCast", "Companion", "rewrite-test"})
public interface FindTypeTest {
    public static final Companion Companion = org.openrewrite.java.search.FindTypeTest$Companion.$$INSTANCE;

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void paramaterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void simpleName(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            \n            public class B extends A1 {}\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)1, (int)b.findType("a.A1").size());
        }

        @Test
        public static void fullyQualifiedName(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("public class B extends a.A1 {}", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)1, (int)b.findType("a.A1").size());
        }

        @Test
        public static void annotation(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a1 = "public @interface A1 {}";
            J.CompilationUnit b = jp.parse("@A1 public class B {}", a1);
            Assertions.assertEquals((int)1, (int)b.findType("A1").size());
        }

        @Test
        public static void array(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)2, (int)b.findType("a.A1").size());
        }

        @Test
        public static void classDecl(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String i1 = "public interface I1 {}";
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ", i1});
            Assertions.assertEquals((int)1, (int)b.findType("a.A1").size());
            Assertions.assertEquals((int)1, (int)b.findType("I1").size());
        }

        @Test
        public static void method(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)2, (int)b.findType("a.A1").size());
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) { return null; }\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)4, (int)b.findType("a.A1").size());
        }

        @Test
        public static void multiCatch(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)1, (int)b.findType("a.A1").size());
        }

        @Test
        public static void multiVariable(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)1, (int)b.findType("a.A1").size());
        }

        @Test
        public static void newClass(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)2, (int)b.findType("a.A1").size());
        }

        @Test
        public static void paramaterizedType(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)2, (int)b.findType("a.A1").size());
        }

        @Test
        public static void typeCast(FindTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit b = jp.parse("\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ", "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ");
            Assertions.assertEquals((int)2, (int)b.findType("a.A1").size());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindTypeTest$Companion;", "", "()V", "a1", "", "rewrite-test"})
    public static final class Companion {
        private static final String a1 = "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

