/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/AddImportTest;", "", "addMultipleImports", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "dontAddImportWhenClassHasNoPackage", "importsAddedInAlphabeticalOrder", "namedImportAddedAfterPackageDeclaration", "rewrite-test"})
public interface AddImportTest {
    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void addMultipleImports(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("class A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Refactor refactor2 = refactor.visit(sourceVisitorArray2);
            addImport = new AddImport();
            n = 0;
            sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            refactor = refactor2;
            bl = false;
            bl2 = false;
            $this$apply = addImport;
            boolean bl4 = false;
            $this$apply.setType("java.util.Set");
            $this$apply.setOnlyIfReferenced(false);
            addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import java.util.List;\n            import java.util.Set;\n            \n            class A {}\n        ");
        }

        @Test
        public static void addNamedImport(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("class A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import java.util.List;\n            \n            class A {}\n        ");
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\nclass A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(AddImportTest $this, @NotNull JavaParser jp) {
            SourceVisitor[] sourceVisitorArray;
            int n;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            List otherPackages = CollectionsKt.listOf((Object[])new String[]{"c", "c.c", "c.c.c"});
            Iterable $this$mapIndexed$iv = otherPackages;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void pkg;
                int n2 = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n2;
                sourceVisitorArray = (SourceVisitor[])item$iv$iv;
                int n3 = n;
                Collection collection2 = collection;
                boolean bl2 = false;
                String string = "package " + (String)pkg + ";\npublic class C" + (int)i + " {}";
                collection2.add(string);
            }
            List otherImports = (List)destination$iv$iv;
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapIndexedTo$iv$iv2;
                void pkg;
                Object item$iv$iv;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Pair pair = it;
                item$iv$iv = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                String b = "\n                package " + (String)pkg + ";\n                public class B {}\n            ";
                J.CompilationUnit cu = jp.parse("package a;\n\nimport c.C0;\nimport c.c.C1;\nimport c.c.c.C2;\n\nclass A {}", CollectionsKt.plus((Collection)otherImports, (Object)b));
                AddImport addImport = new AddImport();
                n = 0;
                Object object = sourceVisitorArray = new SourceVisitor[1];
                Object object2 = cu.refactor();
                boolean bl3 = false;
                boolean bl4 = false;
                Object $this$apply = addImport;
                boolean bl5 = false;
                $this$apply.setType((String)pkg + ".B");
                $this$apply.setOnlyIfReferenced(false);
                AddImport addImport2 = addImport;
                sourceVisitorArray[n] = (SourceVisitor)addImport2;
                Change change = object2.visit(object).fix();
                Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor().visit(AddI\u2026                   .fix()");
                J.CompilationUnit fixed2 = (J.CompilationUnit)change.getFixed();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                $this$apply = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                    void i;
                    void otherPkg;
                    int n4 = index$iv$iv2++;
                    Collection collection = destination$iv$iv2;
                    boolean bl6 = false;
                    if (n4 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n5 = n4;
                    String string = (String)item$iv$iv2;
                    int n6 = n5;
                    object2 = collection;
                    boolean bl7 = false;
                    object = (String)otherPkg + ".C" + (int)i;
                    object2.add(object);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, (String)pkg + ".B");
                J.CompilationUnit compilationUnit = fixed2;
                Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
                TestKt.assertRefactored(compilationUnit, "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.1.INSTANCE, (int)30, null) + "\n\nclass A {}");
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\nimport java.util.List;\nclass A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ");
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\nimport java.util.*;\nclass A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ");
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\nimport static java.util.List.*;\nclass A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n\n            class A {}\n        ");
        }

        @Test
        public static void addNamedStaticImport(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.*;\nclass A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("emptyList");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n\n            class A {}\n        ");
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(AddImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("class A {}", new String[0]);
            AddImport addImport = new AddImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("C");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            sourceVisitorArray[n] = (SourceVisitor)addImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(AddIm\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "class A {}");
        }
    }
}

