/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/AddAnnotationTest;", "", "addAnnotationToClass", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addAnnotationToField", "addAnnotationToMethod", "addAnnotationToMethodParameters", "Companion", "rewrite-test"})
public interface AddAnnotationTest {
    public static final Companion Companion = org.openrewrite.java.AddAnnotationTest$Companion.$$INSTANCE;

    @Test
    public void addAnnotationToClass(@NotNull JavaParser var1);

    @Test
    public void addAnnotationToField(@NotNull JavaParser var1);

    @Test
    public void addAnnotationToMethod(@NotNull JavaParser var1);

    @Test
    public void addAnnotationToMethodParameters(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void addAnnotationToClass(AddAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\npublic class UsersController {\n    class Inner {\n    }\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            sourceVisitorArray[0] = (SourceVisitor)new AddAnnotation.Scoped((Tree)compilationUnit.getClasses().get(0), "lombok.RequiredArgsConstructor", new Expression[0]);
            Refactor refactor2 = refactor.visit(sourceVisitorArray);
            SourceVisitor[] sourceVisitorArray2 = new SourceVisitor[1];
            Object e = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.Block block = ((J.ClassDecl)e).getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"a.classes[0].body");
            sourceVisitorArray2[0] = (SourceVisitor)new AddAnnotation.Scoped((Tree)block.getStatements().get(0), "lombok.RequiredArgsConstructor", new Expression[0]);
            Change change = refactor2.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            package a;\n            \n            import lombok.RequiredArgsConstructor;\n            \n            @RequiredArgsConstructor\n            public class UsersController {\n                @RequiredArgsConstructor\n                class Inner {\n                }\n            }\n        ");
        }

        @Test
        public static void addAnnotationToField(AddAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\npublic class UsersController {\n    private final UserService userService;\n    NameService nameService;\n}", "\n            package b;\n            public @interface MyAnnotation {\n            }\n        ");
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            sourceVisitorArray[0] = (SourceVisitor)new AddAnnotation.Scoped((Tree)((J.ClassDecl)e).getFields().get(0), "b.MyAnnotation", new Expression[0]);
            Refactor refactor2 = refactor.visit(sourceVisitorArray);
            SourceVisitor[] sourceVisitorArray2 = new SourceVisitor[1];
            Object e2 = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0]");
            sourceVisitorArray2[0] = (SourceVisitor)new AddAnnotation.Scoped((Tree)((J.ClassDecl)e2).getFields().get(1), "b.MyAnnotation", new Expression[0]);
            Change change = refactor2.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            package a;\n            \n            import b.MyAnnotation;\n            \n            public class UsersController {\n                @MyAnnotation\n                private final UserService userService;\n            \n                @MyAnnotation\n                NameService nameService;\n            }\n        ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addAnnotationToMethod(AddAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            void $this$fold$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("package a;\n\npublic class UsersController {\n    UsersController() {\n    }\n\n    public void onInit() {\n    }\n\n    void onInit2() {\n    }\n    \n    <T> T onInit3() {\n        return null;\n    }\n}", "\n            package b;\n            public @interface MyAnnotation {\n            }\n        ");
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            List list = ((J.ClassDecl)e).getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].methods");
            Iterable iterable = list;
            Refactor initial$iv = a.refactor();
            boolean $i$f$fold = false;
            Refactor accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void method;
                J.MethodDecl methodDecl = (J.MethodDecl)element$iv;
                Refactor refactor = accumulator$iv;
                boolean bl = false;
                accumulator$iv = refactor.visit(new SourceVisitor[]{(SourceVisitor)new AddAnnotation.Scoped((Tree)method, "b.MyAnnotation", new Expression[0])});
            }
            Change change = accumulator$iv.fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.classes[0].methods\n   \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            package a;\n            \n            import b.MyAnnotation;\n            \n            public class UsersController {\n                @MyAnnotation\n                UsersController() {\n                }\n            \n                @MyAnnotation\n                public void onInit() {\n                }\n            \n                @MyAnnotation\n                void onInit2() {\n                }\n                \n                @MyAnnotation\n                <T> T onInit3() {\n                    return null;\n                }\n            }\n        ");
        }

        @Test
        public static void addAnnotationToMethodParameters(AddAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("package a;\n\npublic class UsersController {\n    public void getUsers(Integer maxUsers) {\n    }\n}", "\n            package b;\n            public @interface MyAnnotation {\n            }\n        ");
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].methods[0]");
            J.MethodDecl.Parameters parameters = ((J.MethodDecl)e2).getParams();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"a.classes[0].methods[0].params");
            sourceVisitorArray[0] = (SourceVisitor)new AddAnnotation.Scoped((Tree)parameters.getParams().get(0), "b.MyAnnotation", new Expression[0]);
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            package a;\n            \n            import b.MyAnnotation;\n            \n            public class UsersController {\n                public void getUsers(@MyAnnotation Integer maxUsers) {\n                }\n            }\n        ");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/AddAnnotationTest$Companion;", "", "()V", "annot", "", "rewrite-test"})
    public static final class Companion {
        private static final String annot = "\n            package b;\n            public @interface MyAnnotation {\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

