/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/ImportTest;", "", "compare", "", "jp", "Lorg/openrewrite/java/JavaParser;", "compareSamePackageDifferentNameLengths", "format", "hasStarImportOnInnerClass", "matchImport", "matchStarImport", "rewrite-test"})
public interface ImportTest {
    @Test
    public void matchImport(@NotNull JavaParser var1);

    @Test
    public void matchStarImport(@NotNull JavaParser var1);

    @Test
    public void hasStarImportOnInnerClass(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void compare(@NotNull JavaParser var1);

    @Test
    public void compareSamePackageDifferentNameLengths(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void matchImport(ImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.util.List;\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = compilationUnit.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.imports");
            Assertions.assertTrue((boolean)((J.Import)CollectionsKt.first((List)list)).isFromType("java.util.List"));
        }

        @Test
        public static void matchStarImport(ImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.util.*;\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = compilationUnit.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.imports");
            Assertions.assertTrue((boolean)((J.Import)CollectionsKt.first((List)list)).isFromType("java.util.List"));
        }

        @Test
        public static void hasStarImportOnInnerClass(ImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public static class B { }\n            }\n        ";
            String c = "\n            import a.*;\n            public class C {\n                A.B b = new A.B();\n            }\n        ";
            J.CompilationUnit compilationUnit = cu = jp.parse(c, a);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            List list = compilationUnit.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cu.imports");
            J.Import import_ = (J.Import)CollectionsKt.first((List)list);
            Assertions.assertTrue((boolean)import_.isFromType("a.A.B"));
            Assertions.assertTrue((boolean)import_.isFromType("a.A"));
        }

        @Test
        public static void format(ImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.util.List;\n            import static java.util.Collections.*;\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Assertions.assertEquals((Object)"import java.util.List", (Object)((J.Import)compilationUnit.getImports().get(0)).printTrimmed());
            Assertions.assertEquals((Object)"import static java.util.Collections.*", (Object)((J.Import)a.getImports().get(1)).printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void compare(ImportTest $this, @NotNull JavaParser jp) {
            void b;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("import b.B;\nimport c.c.C;", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list2 = list = compilationUnit.getImports();
            boolean bl = false;
            J.Import import_ = (J.Import)list2.get(0);
            list2 = list;
            bl = false;
            J.Import c = (J.Import)list2.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo((J.Import)b) > 0 ? 1 : 0) != 0);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void compareSamePackageDifferentNameLengths(ImportTest $this, @NotNull JavaParser jp) {
            void b;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("import org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Configuration;", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list2 = list = compilationUnit.getImports();
            boolean bl = false;
            J.Import import_ = (J.Import)list2.get(0);
            list2 = list;
            bl = false;
            J.Import c = (J.Import)list2.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo((J.Import)b) > 0 ? 1 : 0) != 0);
        }
    }
}

