/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/search/FindInheritedFieldsTest;", "", "findArrayOfType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "findInheritedField", "rewrite-test"})
public interface FindInheritedFieldsTest {
    @Test
    public void findInheritedField(@NotNull JavaParser var1);

    @Test
    public void findArrayOfType(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void findInheritedField(FindInheritedFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit b;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            import java.util.*;\n            public class A {\n               protected List list;\n               private Set set;\n            }\n        ";
            J.CompilationUnit compilationUnit = b = jp.parse("public class B extends A { }", a);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"b");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findInheritedFields("java.util.List");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"b.classes[0].findInheritedFields(\"java.util.List\")");
            JavaType.Var var = (JavaType.Var)CollectionsKt.firstOrNull((List)list);
            Assertions.assertEquals((Object)"list", (Object)(var != null ? var.getName() : null));
            List fields = ((J.ClassDecl)b.getClasses().get(0)).findInheritedFields("java.util.Set");
            Assertions.assertTrue((boolean)fields.isEmpty());
        }

        @Test
        public static void findArrayOfType(FindInheritedFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit b;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            public class A {\n               String[] s;\n            }\n        ";
            J.CompilationUnit compilationUnit = b = jp.parse("public class B extends A { }", a);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"b");
            List fields = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findInheritedFields("java.lang.String");
            Assertions.assertEquals((int)1, (int)fields.size());
            Object e = fields.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"fields[0]");
            Assertions.assertEquals((Object)"s", (Object)((JavaType.Var)e).getName());
            Assertions.assertTrue((boolean)((J.ClassDecl)b.getClasses().get(0)).findInheritedFields("java.util.Set").isEmpty());
        }
    }
}

