/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ReorderMethodArgumentsTest;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "", "refactorReorderArguments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg", "refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation", "refactorReorderArgumentsWithNoSourceAttachment", "rewrite-test"})
public interface ReorderMethodArgumentsTest {
    @Test
    public void refactorReorderArguments(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWithNoSourceAttachment(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorReorderArguments(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo(String s, Integer m, Integer n) {}\n   public void foo(Integer n, Integer m, String s) {}\n}";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\n           \"mystring\",\n           1,\n           2\n       );\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            List foos = cu.findMethodCalls("a.A foo(..)");
            Change change = cu.refactor().fold((Iterable)foos, (Function)refactorReorderArguments.fixed.1.INSTANCE).fold((Iterable)foos, (Function)refactorReorderArguments.fixed.2.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       2,\n                       1,\n                       \"anotherstring\"\n                   );\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWithNoSourceAttachment(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String arg0, Integer... arg1) {}\n               public void foo(Integer arg0, Integer arg1, String arg2) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\"s\", 0, 1);\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("a.A foo(..)"), (Function)refactorReorderArgumentsWithNoSourceAttachment.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(0, 1, \"s\");\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String s, Integer n, Object... o) {}\n               public void bar(String s, Object... o) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\"mystring\", 0, \"a\", \"b\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("a.A foo(..)"), (Function)refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor().fold(cu.fi\u2026rrayOf())\n        }.fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", \"a\", \"b\", 0);\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String s, Object... o) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   public void test() {\n       new A().foo(\"mystring\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("a.A foo(..)"), (Function)refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor().fold(cu.fi\u2026rrayOf())\n        }.fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               public void test() {\n                   new A().foo(\"mystring\");\n               }\n            }\n        ");
        }
    }
}

