/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeMethodTargetToVariable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/ChangeMethodTargetToVariableTest;", "", "refactorExplicitStaticToVariable", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorStaticImportToVariable", "rewrite-test"})
public interface ChangeMethodTargetToVariableTest {
    @Test
    public void refactorExplicitStaticToVariable(@NotNull JavaParser var1);

    @Test
    public void refactorStaticImportToVariable(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorExplicitStaticToVariable(ChangeMethodTargetToVariableTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import a.*;\nimport b.B;\npublic class C {\n   A a;\n   public void test() {\n       B.foo();\n   }\n}";
            J.CompilationUnit compilationUnit = cu = jp.parse(c, new String[]{a, b});
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.VariableDecls f = (J.VariableDecls)((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("a.A").get(0);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("b.B foo()"), new Function<T2, SourceVisitor<T>>(f){
                final /* synthetic */ J.VariableDecls $f;

                @NotNull
                public final ChangeMethodTargetToVariable.Scoped apply(J.MethodInvocation it) {
                    J.VariableDecls variableDecls = this.$f;
                    Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"f");
                    return new ChangeMethodTargetToVariable.Scoped(it, (J.VariableDecls.NamedVar)variableDecls.getVars().get(0));
                }
                {
                    this.$f = variableDecls;
                }
            }).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor().fold(cu.fi\u2026.vars[0])\n        }.fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import a.A;\n            public class C {\n               A a;\n               public void test() {\n                   a.foo();\n               }\n            }\n        ");
        }

        @Test
        public static void refactorStaticImportToVariable(ChangeMethodTargetToVariableTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import a.*;\nimport static b.B.*;\npublic class C {\n   A a;\n   public void test() {\n       foo();\n   }\n}";
            J.CompilationUnit compilationUnit = cu = jp.parse(c, new String[]{a, b});
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.VariableDecls f = (J.VariableDecls)((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("a.A").get(0);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("b.B foo()"), new Function<T2, SourceVisitor<T>>(f){
                final /* synthetic */ J.VariableDecls $f;

                @NotNull
                public final ChangeMethodTargetToVariable.Scoped apply(J.MethodInvocation it) {
                    J.VariableDecls variableDecls = this.$f;
                    Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"f");
                    return new ChangeMethodTargetToVariable.Scoped(it, (J.VariableDecls.NamedVar)variableDecls.getVars().get(0));
                }
                {
                    this.$f = variableDecls;
                }
            }).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor().fold(cu.fi\u2026.vars[0])\n        }.fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import a.A;\n            public class C {\n               A a;\n               public void test() {\n                   a.foo();\n               }\n            }\n        ");
        }
    }
}

