/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodNameTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/ChangeMethodNameTest;", "", "refactorMethodNameForMethodWithArrayArg", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorMethodNameForMethodWithSingleArg", "refactorMethodNameForMethodWithSingleArgDeclarative", "refactorMethodNameForMethodWithVarargArg", "refactorMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken", "Companion", "rewrite-test"})
public interface ChangeMethodNameTest {
    public static final Companion Companion = org.openrewrite.java.ChangeMethodNameTest$Companion.$$INSTANCE;

    @Test
    public void refactorMethodNameForMethodWithSingleArgDeclarative(@NotNull JavaParser var1);

    @Test
    public void refactorMethodNameForMethodWithSingleArg(@NotNull JavaParser var1);

    @Test
    public void refactorMethodNameForMethodWithArrayArg(@NotNull JavaParser var1);

    @Test
    public void refactorMethodNameForMethodWithVarargArg(@NotNull JavaParser var1);

    @Test
    public void refactorMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorMethodNameForMethodWithSingleArgDeclarative(ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "class A {\n   public void test() {\n       new B().singleArg(\"boo\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeMethodNameTest$Companion.access$getB$p(Companion));
            ChangeMethodName changeMethodName = new ChangeMethodName();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ChangeMethodName $this$apply = changeMethodName;
            boolean bl3 = false;
            $this$apply.setMethod("B singleArg(String)");
            $this$apply.setName("bar");
            ChangeMethodName changeMethodName2 = changeMethodName;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodName2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            class A {\n               public void test() {\n                   new B().bar(\"boo\");\n               }\n            }\n        ");
        }

        @Test
        public static void refactorMethodNameForMethodWithSingleArg(ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "class A {\n   public void test() {\n       new B().singleArg(\"boo\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeMethodNameTest$Companion.access$getB$p(Companion));
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("B singleArg(String)"), (Function)refactorMethodNameForMethodWithSingleArg.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            class A {\n               public void test() {\n                   new B().bar(\"boo\");\n               }\n            }\n        ");
        }

        @Test
        public static void refactorMethodNameForMethodWithArrayArg(ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "class A {\n   public void test() {\n       new B().arrArg(new String[] {\"boo\"});\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeMethodNameTest$Companion.access$getB$p(Companion));
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("B arrArg(String[])"), (Function)refactorMethodNameForMethodWithArrayArg.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            class A {\n               public void test() {\n                   new B().bar(new String[] {\"boo\"});\n               }\n            }\n        ");
        }

        @Test
        public static void refactorMethodNameForMethodWithVarargArg(ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "class A {\n   public void test() {\n       new B().varargArg(\"boo\", \"again\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeMethodNameTest$Companion.access$getB$p(Companion));
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("B varargArg(String...)"), (Function)refactorMethodNameForMethodWithVarargArg.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            class A {\n               public void test() {\n                   new B().bar(\"boo\", \"again\");\n               }\n            }\n        ");
        }

        @Test
        public static void refactorMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String b = "class B {\n   public void error() {}\n   public void foo() {}\n}";
            String a = "class A {\n   public void test() {\n       new B().error();\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, b);
            Change change = cu.refactor().fold((Iterable)cu.findMethodCalls("B error()"), (Function)refactorMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken.fixed.1.INSTANCE).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026 }\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            class A {\n               public void test() {\n                   new B().foo();\n               }\n            }\n        ");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/ChangeMethodNameTest$Companion;", "", "()V", "b", "", "rewrite-test"})
    public static final class Companion {
        private static final String b;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            b = "class B {\n   public void singleArg(String s) {}\n   public void arrArg(String[] s) {}\n   public void varargArg(String... s) {}\n}";
        }

        public static final /* synthetic */ String access$getB$p(Companion $this) {
            Companion companion = $this;
            return b;
        }
    }
}

