/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.template.processor.RecipeWriter;
import org.openrewrite.java.template.processor.RuleDescriptor;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"com.google.errorprone.refaster.annotation.BeforeTemplate", "com.google.errorprone.refaster.annotation.AfterTemplate"})
@SupportedOptions(value={"rewrite.generatedAnnotation", "rewrite.javaParserClasspathFrom"})
public class RefasterTemplateProcessor
extends TypeAwareProcessor {
    static final String BEFORE_TEMPLATE = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    static final String AFTER_TEMPLATE = "com.google.errorprone.refaster.annotation.AfterTemplate";
    static final String REWRITE_GENERATED_ANNOTATION = "rewrite.generatedAnnotation";
    static final String REWRITE_JAVA_PARSER_CLASSPATH_FROM = "rewrite.javaParserClasspathFrom";
    static Set<String> UNSUPPORTED_ANNOTATIONS = Stream.of("com.google.errorprone.refaster.annotation.AllowCodeBetweenLines", "com.google.errorprone.refaster.annotation.Matches", "com.google.errorprone.refaster.annotation.MayOptionallyUse", "com.google.errorprone.refaster.annotation.NoAutoboxing", "com.google.errorprone.refaster.annotation.NotMatches", "com.google.errorprone.refaster.annotation.OfKind", "com.google.errorprone.refaster.annotation.Placeholder", "com.google.errorprone.refaster.annotation.Repeated").collect(Collectors.toSet());
    private static final Map<String, Integer> printedMessages = new TreeMap<String, Integer>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            final JCTree.JCCompilationUnit cu = this.toUnit(element);
            if (cu == null) continue;
            final RecipeWriter recipeWriter = new RecipeWriter(this.javacProcessingEnv, cu);
            new TreeScanner(){

                @Override
                public void visitClassDef(JCTree.JCClassDecl classDecl) {
                    super.visitClassDef(classDecl);
                    RuleDescriptor descriptor = RuleDescriptor.create(RefasterTemplateProcessor.this.javacProcessingEnv, cu, classDecl);
                    recipeWriter.writeRecipeForClassDeclaration(classDecl, descriptor);
                }
            }.scan(cu);
        }
        return false;
    }

    public static Map<Name, Integer> findParameterOrder(JCTree.JCMethodDecl method, final int arity) {
        final AtomicInteger parameterOccurrence = new AtomicInteger();
        final HashMap<Name, Integer> parameterOrder = new HashMap<Name, Integer>();
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                JCTree.JCMethodInvocation jcMethodInvocation;
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym) && !parameterOrder.containsKey(jcIdent.sym.name)) {
                        parameterOrder.put(jcIdent.sym.name, parameterOccurrence.getAndIncrement());
                    }
                } else if (jcTree instanceof JCTree.JCMethodInvocation && RefasterTemplateProcessor.isAnyOfCall(jcMethodInvocation = (JCTree.JCMethodInvocation)jcTree)) {
                    super.scan((JCTree)((List)jcMethodInvocation.getArguments()).get(arity));
                    return;
                }
                super.scan(jcTree);
            }
        }.scan(method);
        return parameterOrder;
    }

    public static @Nullable JCTree.JCExpression getReturnExpression(JCTree.JCMethodDecl method) {
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).last();
        if (statement instanceof JCTree.JCReturn) {
            return ((JCTree.JCReturn)statement).expr;
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            return ((JCTree.JCExpressionStatement)statement).expr;
        }
        return null;
    }

    public static boolean isAnyOfCall(JCTree.JCMethodInvocation call) {
        JCTree.JCExpression meth = call.meth;
        if (meth instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)meth;
            return "anyOf".equals(fieldAccess.name.toString()) && "Refaster".equals(((JCTree.JCIdent)fieldAccess.selected).name.toString());
        }
        return false;
    }

    public static void printNoteOnce(ProcessingEnvironment processingEnv, String message, Symbol.ClassSymbol symbol) {
        if (printedMessages.compute(message, (k, v) -> v == null ? 1 : v + 1) == 1) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message, symbol);
        }
    }

    public static java.util.List<JCTree.JCAnnotation> getMethodTreeAnnotations(MethodTree method, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCAnnotation)annotationTree).attribute != null && ((JCTree.JCAnnotation)annotationTree).attribute.type instanceof Type.ClassType && ((JCTree.JCAnnotation)annotationTree).attribute.type.tsym != null && typePredicate.test(((JCTree.JCAnnotation)annotationTree).attribute.type.tsym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }
}

