/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.JavaFileObject;
import org.openrewrite.java.template.internal.JavacTreeMaker;
import org.openrewrite.java.template.internal.Permit;
import org.openrewrite.java.template.internal.TreeMirrorMaker;

public class JavacResolution {
    private final Attr attr;
    private final TreeMirrorMaker mirrorMaker;
    private final Log log;
    private static Field memberEnterDotEnv;

    public JavacResolution(Context context) {
        this.attr = Attr.instance(context);
        this.mirrorMaker = new TreeMirrorMaker(new JavacTreeMaker(TreeMaker.instance(context)));
        this.log = Log.instance(context);
    }

    public Map<JCTree, JCTree> resolveAll(final Context context, final JCTree.JCCompilationUnit cu, final List<? extends Tree> trees) {
        final AtomicReference resolved = new AtomicReference();
        new TreeScanner(){
            private final Stack<JCTree> cursor = new Stack();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scan(JCTree tree) {
                this.cursor.push(tree);
                for (Tree t : trees) {
                    if (t != tree) continue;
                    EnvFinder finder = new EnvFinder(context);
                    for (JCTree p : this.cursor) {
                        p.accept(finder);
                    }
                    JCTree copy = JavacResolution.this.mirrorMaker.copy(finder.copyAt());
                    JavaFileObject oldFileObject = JavacResolution.this.log.useSource(cu.getSourceFile());
                    try {
                        JavacResolution.this.memberEnterAndAttribute(copy, finder.get(), context);
                        resolved.set(JavacResolution.this.mirrorMaker.getOriginalToCopyMap());
                    }
                    finally {
                        JavacResolution.this.log.useSource(oldFileObject);
                    }
                    return;
                }
                super.scan(tree);
                this.cursor.pop();
            }
        }.scan(cu);
        return (Map)resolved.get();
    }

    private static Field getMemberEnterDotEnv() {
        if (memberEnterDotEnv != null) {
            return memberEnterDotEnv;
        }
        try {
            memberEnterDotEnv = Permit.getField(MemberEnter.class, "env");
            return memberEnterDotEnv;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Env<AttrContext> getEnvOfMemberEnter(MemberEnter memberEnter) {
        Field f = JavacResolution.getMemberEnterDotEnv();
        try {
            return (Env)f.get(memberEnter);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setEnvOfMemberEnter(MemberEnter memberEnter, Env<AttrContext> env) {
        Field f = JavacResolution.getMemberEnterDotEnv();
        try {
            f.set(memberEnter, env);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberEnterAndAttribute(JCTree copy, Env<AttrContext> env, Context context) {
        MemberEnter memberEnter = MemberEnter.instance(context);
        Env<AttrContext> oldEnv = JavacResolution.getEnvOfMemberEnter(memberEnter);
        JavacResolution.setEnvOfMemberEnter(memberEnter, env);
        try {
            copy.accept(memberEnter);
        }
        catch (Exception exception) {
        }
        finally {
            JavacResolution.setEnvOfMemberEnter(memberEnter, oldEnv);
        }
        this.attrib(copy, env);
    }

    private void attrib(JCTree tree, Env<AttrContext> env) {
        if (env == null || env.enclClass == null) {
            return;
        }
        if (env.enclClass.type == null) {
            try {
                env.enclClass.type = Type.noType;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tree instanceof JCTree.JCBlock) {
            this.attr.attribStat(tree, env);
        } else if (tree instanceof JCTree.JCMethodDecl) {
            this.attr.attribStat(((JCTree.JCMethodDecl)tree).body, env);
        } else if (tree instanceof JCTree.JCVariableDecl) {
            this.attr.attribStat(tree, env);
        } else {
            throw new IllegalStateException("Called with something that isn't a block, method decl, or variable decl");
        }
    }

    private static final class EnvFinder
    extends JCTree.Visitor {
        private Env<AttrContext> env;
        private final Enter enter;
        private final MemberEnter memberEnter;
        private JCTree copyAt;

        EnvFinder(Context context) {
            this.enter = Enter.instance(context);
            this.memberEnter = MemberEnter.instance(context);
        }

        Env<AttrContext> get() {
            return this.env;
        }

        JCTree copyAt() {
            return this.copyAt;
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.enter.getTopLevelEnv(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            if (tree.sym != null) {
                this.env = this.enter.getClassEnv(tree.sym);
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getMethodEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getInitEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.copyAt != null) {
                return;
            }
            this.copyAt = tree;
        }

        @Override
        public void visitTree(JCTree that) {
        }
    }
}

