/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;

public class ClasspathJarNameDetector {
    public static String classpathFor(JCTree input, List<Symbol> imports) {
        final LinkedHashSet<String> jarNames = new LinkedHashSet<String>();
        for (Symbol anImport : imports) {
            jarNames.add(ClasspathJarNameDetector.jarNameFor(anImport));
        }
        new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.ClassSymbol && Character.isUpperCase(((JCTree.JCFieldAccess)tree).getIdentifier().toString().charAt(0))) {
                    jarNames.add(ClasspathJarNameDetector.jarNameFor(((JCTree.JCFieldAccess)tree).sym));
                }
                super.scan(tree);
            }
        }.scan(input);
        return jarNames.stream().filter(Objects::nonNull).map(jarName -> '\"' + jarName + '\"').sorted().collect(Collectors.joining(", "));
    }

    private static String jarNameFor(Symbol anImport) {
        Symbol.ClassSymbol enclClass;
        Symbol.ClassSymbol classSymbol = enclClass = anImport instanceof Symbol.ClassSymbol ? (Symbol.ClassSymbol)anImport : anImport.enclClass();
        while (enclClass.enclClass() != null && enclClass.enclClass() != enclClass) {
            enclClass = enclClass.enclClass();
        }
        JavaFileObject classfile = enclClass.classfile;
        if (classfile != null) {
            String uriStr = classfile.toUri().toString();
            Matcher matcher = Pattern.compile("([^/]*)?\\.jar!/").matcher(uriStr);
            if (matcher.find()) {
                String jarName = matcher.group(1);
                return jarName.replaceAll("-\\d.*$", "");
            }
        }
        return null;
    }
}

