/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.tree;

import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.ProtoVisitor;
import org.openrewrite.protobuf.internal.ProtoPrinter;
import org.openrewrite.protobuf.tree.FullName;
import org.openrewrite.protobuf.tree.ProtoContainer;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;
import org.openrewrite.protobuf.tree.TypeTree;

public interface Proto
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptProto((ProtoVisitor)v.adapt(ProtoVisitor.class), p);
    }

    @Nullable
    default public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
        return (Proto)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(ProtoVisitor.class);
    }

    public Space getPrefix();

    public <P extends Proto> P withPrefix(Space var1);

    public static class Syntax
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Space keywordSuffix;
        private final ProtoRightPadded<Constant> level;

        public Constant getLevel() {
            return this.level.getElement();
        }

        public Syntax withLevel(Constant level) {
            return this.getPadding().withLevel(this.level.withElement(level));
        }

        public int getLevelVersion() {
            return this.level.getElement().getValueSource().contains("2") ? 2 : 3;
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitSyntax(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Syntax)) {
                return false;
            }
            Syntax other = (Syntax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Syntax;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Syntax(UUID id, Space prefix, Markers markers, Space keywordSuffix, ProtoRightPadded<Constant> level) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.keywordSuffix = keywordSuffix;
            this.level = level;
        }

        private Syntax(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Space keywordSuffix, ProtoRightPadded<Constant> level) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.keywordSuffix = keywordSuffix;
            this.level = level;
        }

        @NonNull
        public Syntax withId(UUID id) {
            return this.id == id ? this : new Syntax(this.padding, id, this.prefix, this.markers, this.keywordSuffix, this.level);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Syntax withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Syntax(this.padding, this.id, prefix, this.markers, this.keywordSuffix, this.level);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Syntax withMarkers(Markers markers) {
            return this.markers == markers ? this : new Syntax(this.padding, this.id, this.prefix, markers, this.keywordSuffix, this.level);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Syntax withKeywordSuffix(Space keywordSuffix) {
            return this.keywordSuffix == keywordSuffix ? this : new Syntax(this.padding, this.id, this.prefix, this.markers, keywordSuffix, this.level);
        }

        public Space getKeywordSuffix() {
            return this.keywordSuffix;
        }

        public static class Padding {
            private final Syntax t;

            public ProtoRightPadded<Constant> getLevel() {
                return this.t.level;
            }

            public Syntax withLevel(ProtoRightPadded<Constant> level) {
                return this.t.level == level ? this.t : new Syntax(this.t.id, this.t.prefix, this.t.markers, this.t.keywordSuffix, level);
            }

            public Padding(Syntax t) {
                this.t = t;
            }
        }
    }

    public static final class StringLiteral
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final boolean singleQuote;
        private final String literal;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitStringLiteral(this, p);
        }

        public StringLiteral(UUID id, Space prefix, Markers markers, boolean singleQuote, String literal) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.singleQuote = singleQuote;
            this.literal = literal;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean isSingleQuote() {
            return this.singleQuote;
        }

        public String getLiteral() {
            return this.literal;
        }

        @NonNull
        public String toString() {
            return "Proto.StringLiteral(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", singleQuote=" + this.isSingleQuote() + ", literal=" + this.getLiteral() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringLiteral)) {
                return false;
            }
            StringLiteral other = (StringLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public StringLiteral withId(UUID id) {
            return this.id == id ? this : new StringLiteral(id, this.prefix, this.markers, this.singleQuote, this.literal);
        }

        @NonNull
        public StringLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringLiteral(this.id, prefix, this.markers, this.singleQuote, this.literal);
        }

        @NonNull
        public StringLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringLiteral(this.id, this.prefix, markers, this.singleQuote, this.literal);
        }

        @NonNull
        public StringLiteral withSingleQuote(boolean singleQuote) {
            return this.singleQuote == singleQuote ? this : new StringLiteral(this.id, this.prefix, this.markers, singleQuote, this.literal);
        }

        @NonNull
        public StringLiteral withLiteral(String literal) {
            return this.literal == literal ? this : new StringLiteral(this.id, this.prefix, this.markers, this.singleQuote, literal);
        }
    }

    public static final class Service
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final Block body;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitService(this, p);
        }

        public Service(UUID id, Space prefix, Markers markers, Identifier name, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "Proto.Service(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Service withId(UUID id) {
            return this.id == id ? this : new Service(id, this.prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Service withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Service(this.id, prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Service withMarkers(Markers markers) {
            return this.markers == markers ? this : new Service(this.id, this.prefix, markers, this.name, this.body);
        }

        @NonNull
        public Service withName(Identifier name) {
            return this.name == name ? this : new Service(this.id, this.prefix, this.markers, name, this.body);
        }

        @NonNull
        public Service withBody(Block body) {
            return this.body == body ? this : new Service(this.id, this.prefix, this.markers, this.name, body);
        }
    }

    public static final class Rpc
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final RpcInOut request;
        private final Keyword returns;
        private final RpcInOut response;
        @Nullable
        private final Block body;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitRpc(this, p);
        }

        public Rpc(UUID id, Space prefix, Markers markers, Identifier name, RpcInOut request, Keyword returns, RpcInOut response, @Nullable Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.request = request;
            this.returns = returns;
            this.response = response;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        public RpcInOut getRequest() {
            return this.request;
        }

        public Keyword getReturns() {
            return this.returns;
        }

        public RpcInOut getResponse() {
            return this.response;
        }

        @Nullable
        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "Proto.Rpc(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", request=" + this.getRequest() + ", returns=" + this.getReturns() + ", response=" + this.getResponse() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rpc)) {
                return false;
            }
            Rpc other = (Rpc)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Rpc withId(UUID id) {
            return this.id == id ? this : new Rpc(id, this.prefix, this.markers, this.name, this.request, this.returns, this.response, this.body);
        }

        @NonNull
        public Rpc withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Rpc(this.id, prefix, this.markers, this.name, this.request, this.returns, this.response, this.body);
        }

        @NonNull
        public Rpc withMarkers(Markers markers) {
            return this.markers == markers ? this : new Rpc(this.id, this.prefix, markers, this.name, this.request, this.returns, this.response, this.body);
        }

        @NonNull
        public Rpc withName(Identifier name) {
            return this.name == name ? this : new Rpc(this.id, this.prefix, this.markers, name, this.request, this.returns, this.response, this.body);
        }

        @NonNull
        public Rpc withRequest(RpcInOut request) {
            return this.request == request ? this : new Rpc(this.id, this.prefix, this.markers, this.name, request, this.returns, this.response, this.body);
        }

        @NonNull
        public Rpc withReturns(Keyword returns) {
            return this.returns == returns ? this : new Rpc(this.id, this.prefix, this.markers, this.name, this.request, returns, this.response, this.body);
        }

        @NonNull
        public Rpc withResponse(RpcInOut response) {
            return this.response == response ? this : new Rpc(this.id, this.prefix, this.markers, this.name, this.request, this.returns, response, this.body);
        }

        @NonNull
        public Rpc withBody(@Nullable Block body) {
            return this.body == body ? this : new Rpc(this.id, this.prefix, this.markers, this.name, this.request, this.returns, this.response, body);
        }
    }

    public static class RpcInOut
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Keyword stream;
        private final ProtoRightPadded<FullName> type;

        public FullName getType() {
            return this.type.getElement();
        }

        public RpcInOut withType(FullName type) {
            return this.getPadding().withType(this.type.withElement(type));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitRpcInOut(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RpcInOut)) {
                return false;
            }
            RpcInOut other = (RpcInOut)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof RpcInOut;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public RpcInOut(UUID id, Space prefix, Markers markers, @Nullable Keyword stream, ProtoRightPadded<FullName> type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.stream = stream;
            this.type = type;
        }

        private RpcInOut(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable Keyword stream, ProtoRightPadded<FullName> type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.stream = stream;
            this.type = type;
        }

        @NonNull
        public RpcInOut withId(UUID id) {
            return this.id == id ? this : new RpcInOut(this.padding, id, this.prefix, this.markers, this.stream, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public RpcInOut withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RpcInOut(this.padding, this.id, prefix, this.markers, this.stream, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public RpcInOut withMarkers(Markers markers) {
            return this.markers == markers ? this : new RpcInOut(this.padding, this.id, this.prefix, markers, this.stream, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public RpcInOut withStream(@Nullable Keyword stream) {
            return this.stream == stream ? this : new RpcInOut(this.padding, this.id, this.prefix, this.markers, stream, this.type);
        }

        @Nullable
        public Keyword getStream() {
            return this.stream;
        }

        public static class Padding {
            private final RpcInOut t;

            @Nullable
            public ProtoRightPadded<FullName> getType() {
                return this.t.type;
            }

            public RpcInOut withType(@Nullable ProtoRightPadded<FullName> type) {
                return this.t.type == type ? this.t : new RpcInOut(this.t.id, this.t.prefix, this.t.markers, this.t.stream, type);
            }

            public Padding(RpcInOut t) {
                this.t = t;
            }
        }
    }

    public static class Reserved
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final ProtoContainer<Proto> reservations;

        @Nullable
        public List<Proto> getReservations() {
            return this.reservations == null ? null : this.reservations.getElements();
        }

        public Reserved withReservations(@Nullable List<Proto> reservations) {
            return this.getPadding().withReservations(ProtoContainer.withElementsNullable(this.reservations, reservations));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitReserved(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reserved)) {
                return false;
            }
            Reserved other = (Reserved)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Reserved;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Reserved(UUID id, Space prefix, Markers markers, @Nullable ProtoContainer<Proto> reservations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.reservations = reservations;
        }

        private Reserved(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable ProtoContainer<Proto> reservations) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.reservations = reservations;
        }

        @NonNull
        public Reserved withId(UUID id) {
            return this.id == id ? this : new Reserved(this.padding, id, this.prefix, this.markers, this.reservations);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Reserved withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Reserved(this.padding, this.id, prefix, this.markers, this.reservations);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Reserved withMarkers(Markers markers) {
            return this.markers == markers ? this : new Reserved(this.padding, this.id, this.prefix, markers, this.reservations);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final Reserved t;

            @Nullable
            public ProtoContainer<Proto> getReservations() {
                return this.t.reservations;
            }

            public Reserved withReservations(@Nullable ProtoContainer<Proto> reservations) {
                return this.t.reservations == reservations ? this.t : new Reserved(this.t.id, this.t.prefix, this.t.markers, reservations);
            }

            public Padding(Reserved t) {
                this.t = t;
            }
        }
    }

    public static class Range
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<Constant> from;
        private final Constant to;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitRange(this, p);
        }

        public Constant getFrom() {
            return this.from.getElement();
        }

        public Range withFrom(Constant from) {
            return this.getPadding().withFrom(this.from.withElement(from));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Range(UUID id, Space prefix, Markers markers, ProtoRightPadded<Constant> from, Constant to) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.to = to;
        }

        private Range(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<Constant> from, Constant to) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.to = to;
        }

        @NonNull
        public Range withId(UUID id) {
            return this.id == id ? this : new Range(this.padding, id, this.prefix, this.markers, this.from, this.to);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Range withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Range(this.padding, this.id, prefix, this.markers, this.from, this.to);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Range withMarkers(Markers markers) {
            return this.markers == markers ? this : new Range(this.padding, this.id, this.prefix, markers, this.from, this.to);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Range withTo(Constant to) {
            return this.to == to ? this : new Range(this.padding, this.id, this.prefix, this.markers, this.from, to);
        }

        public Constant getTo() {
            return this.to;
        }

        public static class Padding {
            private final Range t;

            public ProtoRightPadded<Constant> getFrom() {
                return this.t.from;
            }

            public Range withFrom(ProtoRightPadded<Constant> from) {
                return this.t.from == from ? this.t : new Range(this.t.id, this.t.prefix, this.t.markers, from, this.t.to);
            }

            public Padding(Range t) {
                this.t = t;
            }
        }
    }

    public static final class Primitive
    implements TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        public Primitive(UUID id, Space prefix, Markers markers, Type type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "Proto.Primitive(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Primitive withId(UUID id) {
            return this.id == id ? this : new Primitive(id, this.prefix, this.markers, this.type);
        }

        @NonNull
        public Primitive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Primitive(this.id, prefix, this.markers, this.type);
        }

        @NonNull
        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.prefix, markers, this.type);
        }

        @NonNull
        public Primitive withType(Type type) {
            return this.type == type ? this : new Primitive(this.id, this.prefix, this.markers, type);
        }

        public static enum Type {
            DOUBLE,
            FLOAT,
            INT32,
            INT64,
            UINT32,
            UINT64,
            SINT32,
            SINT64,
            FIXED32,
            FIXED64,
            SFIXED32,
            SFIXED64,
            BOOL,
            STRING,
            BYTES;

        }
    }

    public static final class Package
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final FullIdentifier name;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitPackage(this, p);
        }

        public Package(UUID id, Space prefix, Markers markers, FullIdentifier name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public FullIdentifier getName() {
            return this.name;
        }

        @NonNull
        public String toString() {
            return "Proto.Package(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Package withId(UUID id) {
            return this.id == id ? this : new Package(id, this.prefix, this.markers, this.name);
        }

        @NonNull
        public Package withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Package(this.id, prefix, this.markers, this.name);
        }

        @NonNull
        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.prefix, markers, this.name);
        }

        @NonNull
        public Package withName(FullIdentifier name) {
            return this.name == name ? this : new Package(this.id, this.prefix, this.markers, name);
        }
    }

    public static class OptionDeclaration
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<FullName> name;
        private final Constant assignment;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitOptionDeclaration(this, p);
        }

        public FullName getName() {
            return this.name.getElement();
        }

        public OptionDeclaration withName(FullName name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OptionDeclaration)) {
                return false;
            }
            OptionDeclaration other = (OptionDeclaration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof OptionDeclaration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public OptionDeclaration(UUID id, Space prefix, Markers markers, ProtoRightPadded<FullName> name, Constant assignment) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assignment = assignment;
        }

        private OptionDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<FullName> name, Constant assignment) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assignment = assignment;
        }

        @NonNull
        public OptionDeclaration withId(UUID id) {
            return this.id == id ? this : new OptionDeclaration(this.padding, id, this.prefix, this.markers, this.name, this.assignment);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public OptionDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new OptionDeclaration(this.padding, this.id, prefix, this.markers, this.name, this.assignment);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public OptionDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new OptionDeclaration(this.padding, this.id, this.prefix, markers, this.name, this.assignment);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public OptionDeclaration withAssignment(Constant assignment) {
            return this.assignment == assignment ? this : new OptionDeclaration(this.padding, this.id, this.prefix, this.markers, this.name, assignment);
        }

        public Constant getAssignment() {
            return this.assignment;
        }

        public static class Padding {
            private final OptionDeclaration t;

            public ProtoRightPadded<FullName> getName() {
                return this.t.name;
            }

            public OptionDeclaration withName(ProtoRightPadded<FullName> name) {
                return this.t.name == name ? this.t : new OptionDeclaration(this.t.id, this.t.prefix, this.t.markers, name, this.t.assignment);
            }

            public Padding(OptionDeclaration t) {
                this.t = t;
            }
        }
    }

    public static class Option
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<FullName> name;
        private final Constant assignment;

        public FullName getName() {
            return this.name.getElement();
        }

        public Option withName(FullName name) {
            return this.getPadding().withName(this.getPadding().getName().withElement(name));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitOption(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Option)) {
                return false;
            }
            Option other = (Option)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Option;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Option(UUID id, Space prefix, Markers markers, ProtoRightPadded<FullName> name, Constant assignment) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assignment = assignment;
        }

        private Option(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<FullName> name, Constant assignment) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assignment = assignment;
        }

        @NonNull
        public Option withId(UUID id) {
            return this.id == id ? this : new Option(this.padding, id, this.prefix, this.markers, this.name, this.assignment);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Option withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Option(this.padding, this.id, prefix, this.markers, this.name, this.assignment);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Option withMarkers(Markers markers) {
            return this.markers == markers ? this : new Option(this.padding, this.id, this.prefix, markers, this.name, this.assignment);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Option withAssignment(Constant assignment) {
            return this.assignment == assignment ? this : new Option(this.padding, this.id, this.prefix, this.markers, this.name, assignment);
        }

        public Constant getAssignment() {
            return this.assignment;
        }

        public static class Padding {
            private final Option t;

            public ProtoRightPadded<FullName> getName() {
                return this.t.name;
            }

            public Option withName(ProtoRightPadded<FullName> name) {
                return this.t.name == name ? this.t : new Option(this.t.id, this.t.prefix, this.t.markers, name, this.t.assignment);
            }

            public Padding(Option t) {
                this.t = t;
            }
        }
    }

    public static final class OneOf
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final Block fields;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitOneOf(this, p);
        }

        public OneOf(UUID id, Space prefix, Markers markers, Identifier name, Block fields) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.fields = fields;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        public Block getFields() {
            return this.fields;
        }

        @NonNull
        public String toString() {
            return "Proto.OneOf(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", fields=" + this.getFields() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOf)) {
                return false;
            }
            OneOf other = (OneOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public OneOf withId(UUID id) {
            return this.id == id ? this : new OneOf(id, this.prefix, this.markers, this.name, this.fields);
        }

        @NonNull
        public OneOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new OneOf(this.id, prefix, this.markers, this.name, this.fields);
        }

        @NonNull
        public OneOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new OneOf(this.id, this.prefix, markers, this.name, this.fields);
        }

        @NonNull
        public OneOf withName(Identifier name) {
            return this.name == name ? this : new OneOf(this.id, this.prefix, this.markers, name, this.fields);
        }

        @NonNull
        public OneOf withFields(Block fields) {
            return this.fields == fields ? this : new OneOf(this.id, this.prefix, this.markers, this.name, fields);
        }
    }

    public static final class Message
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final Block body;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitMessage(this, p);
        }

        public Message(UUID id, Space prefix, Markers markers, Identifier name, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "Proto.Message(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Message withId(UUID id) {
            return this.id == id ? this : new Message(id, this.prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Message withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Message(this.id, prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Message withMarkers(Markers markers) {
            return this.markers == markers ? this : new Message(this.id, this.prefix, markers, this.name, this.body);
        }

        @NonNull
        public Message withName(Identifier name) {
            return this.name == name ? this : new Message(this.id, this.prefix, this.markers, name, this.body);
        }

        @NonNull
        public Message withBody(Block body) {
            return this.body == body ? this : new Message(this.id, this.prefix, this.markers, this.name, body);
        }
    }

    public static class MapField
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<Keyword> map;
        private final ProtoRightPadded<Keyword> keyType;
        private final ProtoRightPadded<TypeTree> valueType;
        private final ProtoRightPadded<Identifier> name;
        private final Constant number;
        @Nullable
        private final ProtoContainer<Option> options;

        public Keyword getKeyType() {
            return this.keyType.getElement();
        }

        public MapField withKeyType(Keyword keyType) {
            return this.getPadding().withKeyType(this.getPadding().getKeyType().withElement(keyType));
        }

        public TypeTree getValueType() {
            return this.valueType.getElement();
        }

        public MapField withValueType(TypeTree valueType) {
            return this.getPadding().withValueType(this.getPadding().getValueType().withElement(valueType));
        }

        public Identifier getName() {
            return this.name.getElement();
        }

        public MapField withName(Identifier name) {
            return this.getPadding().withName(this.getPadding().getName().withElement(name));
        }

        @Nullable
        public List<Option> getOptions() {
            return this.options == null ? null : this.options.getElements();
        }

        public MapField withOptions(@Nullable List<Option> options) {
            return this.getPadding().withOptions(ProtoContainer.withElementsNullable(this.options, options));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitMapField(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapField)) {
                return false;
            }
            MapField other = (MapField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MapField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MapField(UUID id, Space prefix, Markers markers, ProtoRightPadded<Keyword> map, ProtoRightPadded<Keyword> keyType, ProtoRightPadded<TypeTree> valueType, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.map = map;
            this.keyType = keyType;
            this.valueType = valueType;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        private MapField(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<Keyword> map, ProtoRightPadded<Keyword> keyType, ProtoRightPadded<TypeTree> valueType, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.map = map;
            this.keyType = keyType;
            this.valueType = valueType;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        @NonNull
        public MapField withId(UUID id) {
            return this.id == id ? this : new MapField(this.padding, id, this.prefix, this.markers, this.map, this.keyType, this.valueType, this.name, this.number, this.options);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MapField withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapField(this.padding, this.id, prefix, this.markers, this.map, this.keyType, this.valueType, this.name, this.number, this.options);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MapField withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapField(this.padding, this.id, this.prefix, markers, this.map, this.keyType, this.valueType, this.name, this.number, this.options);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MapField withNumber(Constant number) {
            return this.number == number ? this : new MapField(this.padding, this.id, this.prefix, this.markers, this.map, this.keyType, this.valueType, this.name, number, this.options);
        }

        public Constant getNumber() {
            return this.number;
        }

        public static class Padding {
            private final MapField t;

            public ProtoRightPadded<Keyword> getMap() {
                return this.t.map;
            }

            public MapField withMap(ProtoRightPadded<Keyword> map) {
                return this.t.map == map ? this.t : new MapField(this.t.id, this.t.prefix, this.t.markers, map, this.t.keyType, this.t.valueType, this.t.name, this.t.number, this.t.options);
            }

            public ProtoRightPadded<Keyword> getKeyType() {
                return this.t.keyType;
            }

            public MapField withKeyType(ProtoRightPadded<Keyword> keyType) {
                return this.t.keyType == keyType ? this.t : new MapField(this.t.id, this.t.prefix, this.t.markers, this.t.map, keyType, this.t.valueType, this.t.name, this.t.number, this.t.options);
            }

            public ProtoRightPadded<TypeTree> getValueType() {
                return this.t.valueType;
            }

            public MapField withValueType(ProtoRightPadded<TypeTree> valueType) {
                return this.t.valueType == valueType ? this.t : new MapField(this.t.id, this.t.prefix, this.t.markers, this.t.map, this.t.keyType, valueType, this.t.name, this.t.number, this.t.options);
            }

            public ProtoRightPadded<Identifier> getName() {
                return this.t.name;
            }

            public MapField withName(ProtoRightPadded<Identifier> name) {
                return this.t.name == name ? this.t : new MapField(this.t.id, this.t.prefix, this.t.markers, this.t.map, this.t.keyType, this.t.valueType, name, this.t.number, this.t.options);
            }

            @Nullable
            public ProtoContainer<Option> getOptions() {
                return this.t.options;
            }

            public MapField withOptions(@Nullable ProtoContainer<Option> options) {
                return this.t.options == options ? this.t : new MapField(this.t.id, this.t.prefix, this.t.markers, this.t.map, this.t.keyType, this.t.valueType, this.t.name, this.t.number, options);
            }

            public Padding(MapField t) {
                this.t = t;
            }
        }
    }

    public static final class Keyword
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String keyword;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitKeyword(this, p);
        }

        public Keyword(UUID id, Space prefix, Markers markers, String keyword) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.keyword = keyword;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getKeyword() {
            return this.keyword;
        }

        @NonNull
        public String toString() {
            return "Proto.Keyword(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", keyword=" + this.getKeyword() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Keyword)) {
                return false;
            }
            Keyword other = (Keyword)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Keyword withId(UUID id) {
            return this.id == id ? this : new Keyword(id, this.prefix, this.markers, this.keyword);
        }

        @NonNull
        public Keyword withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Keyword(this.id, prefix, this.markers, this.keyword);
        }

        @NonNull
        public Keyword withMarkers(Markers markers) {
            return this.markers == markers ? this : new Keyword(this.id, this.prefix, markers, this.keyword);
        }

        @NonNull
        public Keyword withKeyword(String keyword) {
            return this.keyword == keyword ? this : new Keyword(this.id, this.prefix, this.markers, keyword);
        }
    }

    public static class Import
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Keyword modifier;
        private final ProtoRightPadded<StringLiteral> name;

        public StringLiteral getName() {
            return this.name.getElement();
        }

        public Import withName(StringLiteral name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitImport(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Import;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Import(UUID id, Space prefix, Markers markers, @Nullable Keyword modifier, ProtoRightPadded<StringLiteral> name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifier = modifier;
            this.name = name;
        }

        private Import(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable Keyword modifier, ProtoRightPadded<StringLiteral> name) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifier = modifier;
            this.name = name;
        }

        @NonNull
        public Import withId(UUID id) {
            return this.id == id ? this : new Import(this.padding, id, this.prefix, this.markers, this.modifier, this.name);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.padding, this.id, prefix, this.markers, this.modifier, this.name);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.padding, this.id, this.prefix, markers, this.modifier, this.name);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Import withModifier(@Nullable Keyword modifier) {
            return this.modifier == modifier ? this : new Import(this.padding, this.id, this.prefix, this.markers, modifier, this.name);
        }

        @Nullable
        public Keyword getModifier() {
            return this.modifier;
        }

        public static class Padding {
            private final Import t;

            public ProtoRightPadded<StringLiteral> getName() {
                return this.t.name;
            }

            public Import withName(ProtoRightPadded<StringLiteral> name) {
                return this.t.name == name ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, this.t.modifier, name);
            }

            public Padding(Import t) {
                this.t = t;
            }
        }
    }

    public static final class Identifier
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String name;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public Identifier(UUID id, Space prefix, Markers markers, String name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public String toString() {
            return "Proto.Identifier(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.name);
        }

        @NonNull
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.name);
        }

        @NonNull
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.name);
        }

        @NonNull
        public Identifier withName(String name) {
            return this.name == name ? this : new Identifier(this.id, this.prefix, this.markers, name);
        }
    }

    public static class FullIdentifier
    implements FullName,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final ProtoRightPadded<FullName> target;
        private final Identifier name;

        @Nullable
        public FullName getTarget() {
            return this.target == null ? null : this.target.getElement();
        }

        @Nullable
        public FullName withTarget(@Nullable FullName target) {
            if (target == null) {
                return this.getPadding().withTarget(null);
            }
            return this.getPadding().withTarget(this.target == null ? ProtoRightPadded.build(target) : this.target.withElement(target));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitFullIdentifier(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FullIdentifier)) {
                return false;
            }
            FullIdentifier other = (FullIdentifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FullIdentifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public FullIdentifier(UUID id, Space prefix, Markers markers, @Nullable ProtoRightPadded<FullName> target, Identifier name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
        }

        private FullIdentifier(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable ProtoRightPadded<FullName> target, Identifier name) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
        }

        @NonNull
        public FullIdentifier withId(UUID id) {
            return this.id == id ? this : new FullIdentifier(this.padding, id, this.prefix, this.markers, this.target, this.name);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public FullIdentifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FullIdentifier(this.padding, this.id, prefix, this.markers, this.target, this.name);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public FullIdentifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new FullIdentifier(this.padding, this.id, this.prefix, markers, this.target, this.name);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public FullIdentifier withName(Identifier name) {
            return this.name == name ? this : new FullIdentifier(this.padding, this.id, this.prefix, this.markers, this.target, name);
        }

        public Identifier getName() {
            return this.name;
        }

        public static class Padding {
            private final FullIdentifier t;

            @Nullable
            public ProtoRightPadded<FullName> getTarget() {
                return this.t.target;
            }

            public FullIdentifier withTarget(@Nullable ProtoRightPadded<FullName> target) {
                return this.t.target == target ? this.t : new FullIdentifier(this.t.id, this.t.prefix, this.t.markers, target, this.t.name);
            }

            public Padding(FullIdentifier t) {
                this.t = t;
            }
        }
    }

    public static class EnumField
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<Identifier> name;
        private final Constant number;
        @Nullable
        private final ProtoContainer<Option> options;

        public Identifier getName() {
            return this.name.getElement();
        }

        public EnumField withName(Identifier fieldName) {
            return this.getPadding().withName(this.name.withElement(fieldName));
        }

        @Nullable
        public List<Option> getOptions() {
            return this.options == null ? null : this.options.getElements();
        }

        public EnumField withOptions(List<Option> fieldOptions) {
            return this.getPadding().withOptions(ProtoContainer.withElementsNullable(this.options, fieldOptions));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitEnumField(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumField)) {
                return false;
            }
            EnumField other = (EnumField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof EnumField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public EnumField(UUID id, Space prefix, Markers markers, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        private EnumField(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        @NonNull
        public EnumField withId(UUID id) {
            return this.id == id ? this : new EnumField(this.padding, id, this.prefix, this.markers, this.name, this.number, this.options);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public EnumField withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumField(this.padding, this.id, prefix, this.markers, this.name, this.number, this.options);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public EnumField withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumField(this.padding, this.id, this.prefix, markers, this.name, this.number, this.options);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public EnumField withNumber(Constant number) {
            return this.number == number ? this : new EnumField(this.padding, this.id, this.prefix, this.markers, this.name, number, this.options);
        }

        public Constant getNumber() {
            return this.number;
        }

        public static class Padding {
            private final EnumField t;

            public ProtoRightPadded<Identifier> getName() {
                return this.t.name;
            }

            public EnumField withName(ProtoRightPadded<Identifier> name) {
                return this.t.name == name ? this.t : new EnumField(this.t.id, this.t.prefix, this.t.markers, name, this.t.number, this.t.options);
            }

            @Nullable
            public ProtoContainer<Option> getOptions() {
                return this.t.options;
            }

            public EnumField withOptions(@Nullable ProtoContainer<Option> options) {
                return this.t.options == options ? this.t : new EnumField(this.t.id, this.t.prefix, this.t.markers, this.t.name, this.t.number, options);
            }

            public Padding(EnumField t) {
                this.t = t;
            }
        }
    }

    public static class ExtensionName
    implements FullName {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ProtoRightPadded<FullIdentifier> extension;

        public FullIdentifier getExtension() {
            return this.extension.getElement();
        }

        public ExtensionName withExtension(FullIdentifier extension) {
            return this.getPadding().withExtension(this.extension.withElement(extension));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitExtensionName(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtensionName)) {
                return false;
            }
            ExtensionName other = (ExtensionName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ExtensionName;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ExtensionName(UUID id, Space prefix, Markers markers, ProtoRightPadded<FullIdentifier> extension) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.extension = extension;
        }

        private ExtensionName(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ProtoRightPadded<FullIdentifier> extension) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.extension = extension;
        }

        @NonNull
        public ExtensionName withId(UUID id) {
            return this.id == id ? this : new ExtensionName(this.padding, id, this.prefix, this.markers, this.extension);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ExtensionName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExtensionName(this.padding, this.id, prefix, this.markers, this.extension);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ExtensionName withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExtensionName(this.padding, this.id, this.prefix, markers, this.extension);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final ExtensionName t;

            public ProtoRightPadded<FullIdentifier> getExtension() {
                return this.t.extension;
            }

            public ExtensionName withExtension(ProtoRightPadded<FullIdentifier> extension) {
                return this.t.extension == extension ? this.t : new ExtensionName(this.t.id, this.t.prefix, this.t.markers, extension);
            }

            public Padding(ExtensionName t) {
                this.t = t;
            }
        }
    }

    public static class Field
    implements FullName {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Keyword label;
        private final TypeTree type;
        private final ProtoRightPadded<Identifier> name;
        private final Constant number;
        @Nullable
        private final ProtoContainer<Option> options;

        public Identifier getName() {
            return this.name.getElement();
        }

        public Field withName(Identifier fieldName) {
            return this.getPadding().withName(this.name.withElement(fieldName));
        }

        @Nullable
        public List<Option> getOptions() {
            return this.options == null ? null : this.options.getElements();
        }

        public Field withOptions(List<Option> fieldOptions) {
            return this.getPadding().withOptions(ProtoContainer.withElementsNullable(this.options, fieldOptions));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitField(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Field(UUID id, Space prefix, Markers markers, @Nullable Keyword label, TypeTree type, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.type = type;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        private Field(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable Keyword label, TypeTree type, ProtoRightPadded<Identifier> name, Constant number, @Nullable ProtoContainer<Option> options) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.type = type;
            this.name = name;
            this.number = number;
            this.options = options;
        }

        @NonNull
        public Field withId(UUID id) {
            return this.id == id ? this : new Field(this.padding, id, this.prefix, this.markers, this.label, this.type, this.name, this.number, this.options);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Field withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Field(this.padding, this.id, prefix, this.markers, this.label, this.type, this.name, this.number, this.options);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Field withMarkers(Markers markers) {
            return this.markers == markers ? this : new Field(this.padding, this.id, this.prefix, markers, this.label, this.type, this.name, this.number, this.options);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Field withLabel(@Nullable Keyword label) {
            return this.label == label ? this : new Field(this.padding, this.id, this.prefix, this.markers, label, this.type, this.name, this.number, this.options);
        }

        @Nullable
        public Keyword getLabel() {
            return this.label;
        }

        @NonNull
        public Field withType(TypeTree type) {
            return this.type == type ? this : new Field(this.padding, this.id, this.prefix, this.markers, this.label, type, this.name, this.number, this.options);
        }

        public TypeTree getType() {
            return this.type;
        }

        @NonNull
        public Field withNumber(Constant number) {
            return this.number == number ? this : new Field(this.padding, this.id, this.prefix, this.markers, this.label, this.type, this.name, number, this.options);
        }

        public Constant getNumber() {
            return this.number;
        }

        public static class Padding {
            private final Field t;

            public ProtoRightPadded<Identifier> getName() {
                return this.t.name;
            }

            public Field withName(ProtoRightPadded<Identifier> name) {
                return this.t.name == name ? this.t : new Field(this.t.id, this.t.prefix, this.t.markers, this.t.label, this.t.type, name, this.t.number, this.t.options);
            }

            @Nullable
            public ProtoContainer<Option> getOptions() {
                return this.t.options;
            }

            public Field withOptions(@Nullable ProtoContainer<Option> fieldOptions) {
                return this.t.options == fieldOptions ? this.t : new Field(this.t.id, this.t.prefix, this.t.markers, this.t.label, this.t.type, this.t.name, this.t.number, fieldOptions);
            }

            public Padding(Field t) {
                this.t = t;
            }
        }
    }

    public static final class Extend
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final FullIdentifier name;
        private final Block body;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitExtend(this, p);
        }

        public Extend(UUID id, Space prefix, Markers markers, FullIdentifier name, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public FullIdentifier getName() {
            return this.name;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "Proto.Extend(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extend)) {
                return false;
            }
            Extend other = (Extend)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Extend withId(UUID id) {
            return this.id == id ? this : new Extend(id, this.prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Extend withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Extend(this.id, prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Extend withMarkers(Markers markers) {
            return this.markers == markers ? this : new Extend(this.id, this.prefix, markers, this.name, this.body);
        }

        @NonNull
        public Extend withName(FullIdentifier name) {
            return this.name == name ? this : new Extend(this.id, this.prefix, this.markers, name, this.body);
        }

        @NonNull
        public Extend withBody(Block body) {
            return this.body == body ? this : new Extend(this.id, this.prefix, this.markers, this.name, body);
        }
    }

    public static final class Enum
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final Block body;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitEnum(this, p);
        }

        public Enum(UUID id, Space prefix, Markers markers, Identifier name, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "Proto.Enum(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Enum)) {
                return false;
            }
            Enum other = (Enum)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Enum withId(UUID id) {
            return this.id == id ? this : new Enum(id, this.prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Enum withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Enum(this.id, prefix, this.markers, this.name, this.body);
        }

        @NonNull
        public Enum withMarkers(Markers markers) {
            return this.markers == markers ? this : new Enum(this.id, this.prefix, markers, this.name, this.body);
        }

        @NonNull
        public Enum withName(Identifier name) {
            return this.name == name ? this : new Enum(this.id, this.prefix, this.markers, name, this.body);
        }

        @NonNull
        public Enum withBody(Block body) {
            return this.body == body ? this : new Enum(this.id, this.prefix, this.markers, this.name, body);
        }
    }

    public static final class Empty
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public String toString() {
            return "Proto.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static class Document
    implements Proto,
    SourceFile {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final Syntax syntax;
        private final List<ProtoRightPadded<Proto>> body;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<Proto> getBody() {
            return ProtoRightPadded.getElements(this.body);
        }

        public Document withBody(List<Proto> body) {
            return this.getPadding().withBody(ProtoRightPadded.withElements(this.body, body));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new ProtoPrinter();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Document;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Document(UUID id, Path sourcePath, @Nullable FileAttributes fileAttributes, Space prefix, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, Syntax syntax, List<ProtoRightPadded<Proto>> body, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.syntax = syntax;
            this.body = body;
            this.eof = eof;
        }

        private Document(@Nullable WeakReference<Padding> padding, UUID id, Path sourcePath, @Nullable FileAttributes fileAttributes, Space prefix, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, Syntax syntax, List<ProtoRightPadded<Proto>> body, Space eof) {
            this.padding = padding;
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.syntax = syntax;
            this.body = body;
            this.eof = eof;
        }

        @NonNull
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(this.padding, id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Document withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Document(this.padding, this.id, sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public Document withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Document(this.padding, this.id, this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        public Document withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        private Document withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        @NonNull
        public Document withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.syntax, this.body, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        public Document withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.syntax, this.body, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public Document withSyntax(Syntax syntax) {
            return this.syntax == syntax ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, syntax, this.body, this.eof);
        }

        public Syntax getSyntax() {
            return this.syntax;
        }

        @NonNull
        public Document withEof(Space eof) {
            return this.eof == eof ? this : new Document(this.padding, this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.syntax, this.body, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding {
            private final Document t;

            public List<ProtoRightPadded<Proto>> getBody() {
                return this.t.body;
            }

            public Document withBody(List<ProtoRightPadded<Proto>> body) {
                return this.t.body == body ? this.t : new Document(this.t.id, this.t.sourcePath, this.t.fileAttributes, this.t.prefix, this.t.markers, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.syntax, body, this.t.eof);
            }

            public Padding(Document t) {
                this.t = t;
            }
        }
    }

    public static final class Constant
    implements Proto {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Object value;
        private final String valueSource;

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitConstant(this, p);
        }

        public Constant(UUID id, Space prefix, Markers markers, Object value, String valueSource) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @NonNull
        public String toString() {
            return "Proto.Constant(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ")";
        }

        @NonNull
        public Constant withId(UUID id) {
            return this.id == id ? this : new Constant(id, this.prefix, this.markers, this.value, this.valueSource);
        }

        @NonNull
        public Constant withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Constant(this.id, prefix, this.markers, this.value, this.valueSource);
        }

        @NonNull
        public Constant withMarkers(Markers markers) {
            return this.markers == markers ? this : new Constant(this.id, this.prefix, markers, this.value, this.valueSource);
        }

        @NonNull
        public Constant withValue(Object value) {
            return this.value == value ? this : new Constant(this.id, this.prefix, this.markers, value, this.valueSource);
        }

        @NonNull
        public Constant withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Constant(this.id, this.prefix, this.markers, this.value, valueSource);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constant)) {
                return false;
            }
            Constant other = (Constant)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }
    }

    public static class Block
    implements Proto {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ProtoRightPadded<Proto>> statements;
        private final Space end;

        public List<Proto> getStatements() {
            return ProtoRightPadded.getElements(this.statements);
        }

        public Block withStatements(List<Proto> statements) {
            return this.getPadding().withStatements(ProtoRightPadded.withElements(this.statements, statements));
        }

        @Override
        public <P> Proto acceptProto(ProtoVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Block;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Block(UUID id, Space prefix, Markers markers, List<ProtoRightPadded<Proto>> statements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statements = statements;
            this.end = end;
        }

        private Block(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<ProtoRightPadded<Proto>> statements, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statements = statements;
            this.end = end;
        }

        @NonNull
        public Block withId(UUID id) {
            return this.id == id ? this : new Block(this.padding, id, this.prefix, this.markers, this.statements, this.end);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.padding, this.id, prefix, this.markers, this.statements, this.end);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.padding, this.id, this.prefix, markers, this.statements, this.end);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.padding, this.id, this.prefix, this.markers, this.statements, end);
        }

        public Space getEnd() {
            return this.end;
        }

        public static class Padding {
            private final Block t;

            public List<ProtoRightPadded<Proto>> getStatements() {
                return this.t.statements;
            }

            public Block withStatements(List<ProtoRightPadded<Proto>> statements) {
                return this.t.statements == statements ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, statements, this.t.end);
            }

            public Padding(Block t) {
                this.t = t;
            }
        }
    }
}

