/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.Space;

public class ProtoRightPadded<T> {
    private final T element;
    private final Space after;
    private final Markers markers;

    public ProtoRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    public static <T> List<T> getElements(List<ProtoRightPadded<T>> ls) {
        ArrayList<T> list = new ArrayList<T>();
        for (ProtoRightPadded<T> l : ls) {
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <P extends Proto> List<ProtoRightPadded<P>> withElements(List<ProtoRightPadded<P>> before, List<P> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        }
        ArrayList<ProtoRightPadded<P>> after = new ArrayList<ProtoRightPadded<P>>(elements.size());
        Map beforeById = before.stream().collect(Collectors.toMap(j -> ((Proto)j.getElement()).getId(), Function.identity()));
        for (Proto t : elements) {
            if (beforeById.get(t.getId()) != null) {
                ProtoRightPadded found = (ProtoRightPadded)beforeById.get(t.getId());
                after.add(found.withElement(t));
                continue;
            }
            after.add(new ProtoRightPadded<Proto>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T> ProtoRightPadded<T> build(T element) {
        return new ProtoRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    public String toString() {
        return "ProtoRightPadded(element=" + this.element.getClass().getSimpleName() + ", after=" + this.after + ')';
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtoRightPadded)) {
            return false;
        }
        ProtoRightPadded other = (ProtoRightPadded)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProtoRightPadded;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ProtoRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public Space getAfter() {
        return this.after;
    }

    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @NonNull
    @Generated
    public ProtoRightPadded<T> withElement(T element) {
        return this.element == element ? this : new ProtoRightPadded<T>(element, this.after, this.markers);
    }

    @NonNull
    @Generated
    public ProtoRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new ProtoRightPadded<T>(this.element, after, this.markers);
    }

    @NonNull
    @Generated
    public ProtoRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new ProtoRightPadded<T>(this.element, this.after, markers);
    }
}

