/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;

public class ProtoContainer<T> {
    private transient Padding<T> padding;
    private static final ProtoContainer<?> EMPTY = new ProtoContainer(Space.EMPTY, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    private final List<ProtoRightPadded<T>> elements;
    private final Markers markers;

    private ProtoContainer(Space before, List<ProtoRightPadded<T>> elements, Markers markers) {
        this.before = before;
        this.elements = elements;
        this.markers = markers;
    }

    public static <T> ProtoContainer<T> build(List<ProtoRightPadded<T>> elements) {
        return ProtoContainer.build(Space.EMPTY, elements, Markers.EMPTY);
    }

    @JsonCreator
    public static <T> ProtoContainer<T> build(Space before, List<ProtoRightPadded<T>> elements, Markers markers) {
        if (before.isEmpty() && elements.isEmpty()) {
            return ProtoContainer.empty();
        }
        return new ProtoContainer<T>(before, elements, markers);
    }

    public static <T> ProtoContainer<T> empty() {
        return EMPTY;
    }

    public ProtoContainer<T> withBefore(Space before) {
        return this.getBefore() == before ? this : ProtoContainer.build(before, this.elements, this.markers);
    }

    public ProtoContainer<T> withMarkers(Markers markers) {
        return this.getMarkers() == markers ? this : ProtoContainer.build(this.before, this.elements, markers);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<T> getElements() {
        return ProtoRightPadded.getElements(this.elements);
    }

    public Space getBefore() {
        return this.before;
    }

    public ProtoContainer<T> map(UnaryOperator<T> map) {
        return this.getPadding().withElements(ListUtils.map(this.elements, t -> t.map(map)));
    }

    public Space getLastSpace() {
        return this.elements.isEmpty() ? Space.EMPTY : this.elements.get(this.elements.size() - 1).getAfter();
    }

    public Padding<T> getPadding() {
        if (this.padding == null) {
            this.padding = new Padding(this);
        }
        return this.padding;
    }

    @Nullable
    public static <P extends Proto> ProtoContainer<P> withElementsNullable(@Nullable ProtoContainer<P> before, @Nullable List<P> elements) {
        if (before == null) {
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return ProtoContainer.build(Space.EMPTY, ProtoRightPadded.withElements(Collections.emptyList(), elements), Markers.EMPTY);
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return before.getPadding().withElements(ProtoRightPadded.withElements(before.elements, elements));
    }

    public static <P extends Proto> ProtoContainer<P> withElements(ProtoContainer<P> before, @Nullable List<P> elements) {
        if (elements == null) {
            return before.getPadding().withElements(Collections.emptyList());
        }
        return before.getPadding().withElements(ProtoRightPadded.withElements(before.elements, elements));
    }

    public String toString() {
        return "ProtoContainer(before=" + this.before + ", elementCount=" + this.elements.size() + ')';
    }

    public static class Padding<T> {
        private final ProtoContainer<T> c;

        public List<ProtoRightPadded<T>> getElements() {
            return ((ProtoContainer)this.c).elements;
        }

        public ProtoContainer<T> withElements(List<ProtoRightPadded<T>> elements) {
            return ((ProtoContainer)this.c).elements == elements ? this.c : ProtoContainer.build(((ProtoContainer)this.c).before, elements, ((ProtoContainer)this.c).markers);
        }

        public Padding(ProtoContainer<T> c) {
            this.c = c;
        }
    }
}

