/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public class PropertiesPrinter<P>
extends PropertiesVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> PROPERTIES_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public Properties visitFile(Properties.File file, PrintOutputCapture<P> p) {
        this.beforeSyntax(file, p);
        this.visit(file.getContent(), p);
        p.append(file.getEof());
        this.afterSyntax(file, p);
        return file;
    }

    @Override
    public Properties visitEntry(Properties.Entry entry, PrintOutputCapture<P> p) {
        this.beforeSyntax(entry, p);
        p.append(entry.getKey()).append(entry.getBeforeEquals());
        if (entry.getDelimiter() != Properties.Entry.Delimiter.NONE) {
            p.append(entry.getDelimiter().getCharacter().charValue());
        }
        this.beforeSyntax(entry.getValue().getPrefix(), entry.getValue().getMarkers(), p);
        p.append(entry.getValue().getText());
        this.afterSyntax(entry.getValue().getMarkers(), p);
        this.afterSyntax(entry, p);
        return entry;
    }

    @Override
    public Properties visitComment(Properties.Comment comment, PrintOutputCapture<P> p) {
        this.beforeSyntax(comment, p);
        if (comment.getDelimiter() == null) {
            p.append('#');
        } else {
            p.append(comment.getDelimiter().getCharacter().charValue());
        }
        p.append(comment.getMessage());
        this.afterSyntax(comment, p);
        return comment;
    }

    private void beforeSyntax(Properties props, PrintOutputCapture<P> p) {
        this.beforeSyntax(props.getPrefix(), props.getMarkers(), p);
    }

    private void beforeSyntax(String prefix, Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), PROPERTIES_MARKER_WRAPPER));
        }
        p.append(prefix);
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), PROPERTIES_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Properties props, PrintOutputCapture<P> p) {
        this.afterSyntax(props.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), PROPERTIES_MARKER_WRAPPER));
        }
    }
}

