/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class DeleteProperty
extends Recipe {
    @Option(displayName="Property key matcher", description="The key(s) to be deleted. This is a glob expression.", example="management.metrics.binders.files.enabled or management.metrics.*")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    @Incubating(since="7.17.0")
    private final Boolean relaxedBinding;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.properties")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Delete Property";
    }

    public String getDescription() {
        return "Deletes key/value pairs from properties files.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public PropertiesVisitor<ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
                Properties.File f = (Properties.File)super.visitFile(file, executionContext);
                String prefix = null;
                List<Properties.Content> contents = f.getContent();
                ArrayList<Properties.Content> newContents = new ArrayList<Properties.Content>();
                for (int i = 0; i < contents.size(); ++i) {
                    Properties.Content content = contents.get(i);
                    if (content instanceof Properties.Entry && this.isMatch(((Properties.Entry)content).getKey())) {
                        if (i != 0) continue;
                        prefix = ((Properties.Entry)content).getPrefix();
                        continue;
                    }
                    if (prefix != null) {
                        content = (Properties.Content)content.withPrefix(prefix);
                        prefix = null;
                    }
                    newContents.add(content);
                }
                return contents.size() == newContents.size() ? f : f.withContent(newContents);
            }

            private boolean isMatch(String key) {
                if (!Boolean.FALSE.equals(DeleteProperty.this.relaxedBinding)) {
                    return StringUtils.matchesGlob((String)NameCaseConvention.LOWER_CAMEL.format(key), (String)NameCaseConvention.LOWER_CAMEL.format(DeleteProperty.this.propertyKey));
                }
                return StringUtils.matchesGlob((String)key, (String)DeleteProperty.this.propertyKey);
            }
        };
    }

    public DeleteProperty(String propertyKey, @Nullable Boolean relaxedBinding, @Nullable String fileMatcher) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
        this.fileMatcher = fileMatcher;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "DeleteProperty(propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

