/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class FindProperties
extends Recipe {
    @Option(displayName="Property key", description="The property key to look for.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    @Incubating(since="7.17.0")
    private final Boolean relaxedBinding;

    public String getDisplayName() {
        return "Find property";
    }

    public String getDescription() {
        return "Finds occurrences of a property key.";
    }

    public static Set<Properties.Entry> find(Properties p, final String propertyKey, final @Nullable Boolean relaxedBinding) {
        PropertiesVisitor<Set<Properties.Entry>> findVisitor = new PropertiesVisitor<Set<Properties.Entry>>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, Set<Properties.Entry> ps) {
                if (!Boolean.FALSE.equals(relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)entry.getKey(), (String)propertyKey) : entry.getKey().equals(propertyKey)) {
                    ps.add(entry);
                }
                return super.visitEntry(entry, ps);
            }
        };
        HashSet<Properties.Entry> ps = new HashSet<Properties.Entry>();
        findVisitor.visit(p, ps);
        return ps;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!Boolean.FALSE.equals(FindProperties.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)entry.getKey(), (String)FindProperties.this.propertyKey) : entry.getKey().equals(FindProperties.this.propertyKey)) {
                    entry = entry.withValue(entry.getValue().withMarkers(entry.getValue().getMarkers().searchResult()));
                }
                return super.visitEntry(entry, ctx);
            }
        };
    }

    public FindProperties(String propertyKey, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    public String toString() {
        return "FindProperties(propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperties)) {
            return false;
        }
        FindProperties other = (FindProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

