/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.search;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.marker.PropertiesSearchResult;
import org.openrewrite.properties.tree.Properties;

public final class FindProperties
extends Recipe {
    @Option(displayName="Property key", description="A property glob expression that properties are matched against.", example="guava*")
    private final String propertyKey;
    private final UUID id = Tree.randomId();

    public static Set<Properties.Entry> find(Properties p, final String propertyKey) {
        PropertiesVisitor<Set<Properties.Entry>> findVisitor = new PropertiesVisitor<Set<Properties.Entry>>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, Set<Properties.Entry> ps) {
                if (entry.getKey().equals(propertyKey)) {
                    ps.add(entry);
                }
                return super.visitEntry(entry, ps);
            }
        };
        HashSet<Properties.Entry> ps = new HashSet<Properties.Entry>();
        findVisitor.visit(p, ps);
        return ps;
    }

    public String getDisplayName() {
        return "Find property";
    }

    public String getDescription() {
        return "Find uses of a property by key or keys by pattern.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                Properties p = super.visitEntry(entry, ctx);
                if (entry.getKey().equals(FindProperties.this.propertyKey)) {
                    p = p.withMarkers(p.getMarkers().addOrUpdate((Marker)new PropertiesSearchResult(FindProperties.this.id, FindProperties.this)));
                }
                return p;
            }
        };
    }

    public FindProperties(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindProperties(propertyKey=" + this.getPropertyKey() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperties)) {
            return false;
        }
        FindProperties other = (FindProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

