/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class ResolvedDependency
implements Serializable {
    private final @Nullable MavenRepository repository;
    private final ResolvedGroupArtifactVersion gav;
    private final Dependency requested;
    private List<ResolvedDependency> dependencies;
    private final List<License> licenses;
    private final @Nullable String type;
    private final @Nullable String classifier;
    private final @Nullable Boolean optional;
    private final int depth;
    private @Nullable List<GroupArtifact> effectiveExclusions;

    public List<GroupArtifact> getEffectiveExclusions() {
        return this.effectiveExclusions == null ? Collections.emptyList() : this.effectiveExclusions;
    }

    void unsafeSetDependencies(List<ResolvedDependency> dependencies) {
        this.dependencies = dependencies;
    }

    void unsafeSetEffectiveExclusions(List<GroupArtifact> effectiveExclusions) {
        this.effectiveExclusions = effectiveExclusions;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getType() {
        return this.type == null ? "jar" : this.type;
    }

    public boolean isDirect() {
        return this.depth == 0;
    }

    public boolean isTransitive() {
        return this.depth != 0;
    }

    public @Nullable String getDatedSnapshotVersion() {
        return this.gav.getDatedSnapshotVersion();
    }

    public List<ResolvedDependency> findDependencies(String groupId, String artifactId) {
        return this.findDependencies0(groupId, artifactId, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private List<ResolvedDependency> findDependencies0(String groupId, String artifactId, Set<ResolvedDependency> visited) {
        ArrayList<ResolvedDependency> dependencies = new ArrayList<ResolvedDependency>();
        if (StringUtils.matchesGlob((String)this.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)this.getArtifactId(), (String)artifactId)) {
            dependencies.add(this);
        } else if (!visited.add(this)) {
            return Collections.emptyList();
        }
        for (ResolvedDependency dependency : this.dependencies) {
            dependency.findDependencies0(groupId, artifactId, visited).stream().filter(found -> {
                if (this.getRequested().getExclusions() != null) {
                    for (GroupArtifact exclusion : this.getRequested().getExclusions()) {
                        if (!StringUtils.matchesGlob((String)found.getGroupId(), (String)exclusion.getGroupId()) || !StringUtils.matchesGlob((String)found.getArtifactId(), (String)exclusion.getArtifactId())) continue;
                        return false;
                    }
                }
                return true;
            }).forEach(dependencies::add);
        }
        return dependencies;
    }

    public @Nullable ResolvedDependency findDependency(String groupId, String artifactId) {
        return this.findDependency0(groupId, artifactId, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private @Nullable ResolvedDependency findDependency0(String groupId, String artifactId, Set<ResolvedDependency> visited) {
        if (StringUtils.matchesGlob((String)this.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)this.getArtifactId(), (String)artifactId)) {
            return this;
        }
        if (!visited.add(this)) {
            return null;
        }
        block0: for (ResolvedDependency dependency : this.dependencies) {
            ResolvedDependency found = dependency.findDependency0(groupId, artifactId, visited);
            if (found == null) continue;
            if (this.getRequested().getExclusions() != null) {
                for (GroupArtifact exclusion : this.getRequested().getExclusions()) {
                    if (!StringUtils.matchesGlob((String)found.getGroupId(), (String)exclusion.getGroupId()) || !StringUtils.matchesGlob((String)found.getArtifactId(), (String)exclusion.getArtifactId())) continue;
                    continue block0;
                }
            }
            return found;
        }
        return null;
    }

    public String toString() {
        return (this.repository == null ? "" : this.repository.getUri() + "/") + this.gav.getGroupId().replace('.', '/') + "/" + this.gav.getArtifactId() + "/" + this.gav.getVersion() + "/" + this.gav.getArtifactId() + "-" + this.gav.getVersion() + ".pom";
    }

    @Generated
    private static List<ResolvedDependency> $default$dependencies() {
        return Collections.emptyList();
    }

    @Generated
    private static List<License> $default$licenses() {
        return Collections.emptyList();
    }

    @NonNull
    @Generated
    public static ResolvedDependencyBuilder builder() {
        return new ResolvedDependencyBuilder();
    }

    @Generated
    public @Nullable MavenRepository getRepository() {
        return this.repository;
    }

    @Generated
    public ResolvedGroupArtifactVersion getGav() {
        return this.gav;
    }

    @Generated
    public Dependency getRequested() {
        return this.requested;
    }

    @Generated
    public List<ResolvedDependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public List<License> getLicenses() {
        return this.licenses;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable Boolean getOptional() {
        return this.optional;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedDependency)) {
            return false;
        }
        ResolvedDependency other = (ResolvedDependency)o;
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        MavenRepository this$repository = this.getRepository();
        MavenRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        ResolvedGroupArtifactVersion this$gav = this.getGav();
        ResolvedGroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        Dependency this$requested = this.getRequested();
        Dependency other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<License> this$licenses = this.getLicenses();
        List<License> other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        List<GroupArtifact> this$effectiveExclusions = this.getEffectiveExclusions();
        List<GroupArtifact> other$effectiveExclusions = other.getEffectiveExclusions();
        return !(this$effectiveExclusions == null ? other$effectiveExclusions != null : !((Object)this$effectiveExclusions).equals(other$effectiveExclusions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        MavenRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        ResolvedGroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        Dependency $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<License> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        List<GroupArtifact> $effectiveExclusions = this.getEffectiveExclusions();
        result = result * 59 + ($effectiveExclusions == null ? 43 : ((Object)$effectiveExclusions).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public ResolvedDependency withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new ResolvedDependency(repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withGav(ResolvedGroupArtifactVersion gav) {
        return this.gav == gav ? this : new ResolvedDependency(this.repository, gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withRequested(Dependency requested) {
        return this.requested == requested ? this : new ResolvedDependency(this.repository, this.gav, requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withDependencies(List<ResolvedDependency> dependencies) {
        return this.dependencies == dependencies ? this : new ResolvedDependency(this.repository, this.gav, this.requested, dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withLicenses(List<License> licenses) {
        return this.licenses == licenses ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withType(@Nullable String type) {
        return this.type == type ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withOptional(@Nullable Boolean optional) {
        return this.optional == optional ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withDepth(int depth) {
        return this.depth == depth ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, depth, this.effectiveExclusions);
    }

    @NonNull
    @Generated
    public ResolvedDependency withEffectiveExclusions(@Nullable List<GroupArtifact> effectiveExclusions) {
        return this.effectiveExclusions == effectiveExclusions ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, effectiveExclusions);
    }

    @Generated
    public ResolvedDependency(@Nullable MavenRepository repository, ResolvedGroupArtifactVersion gav, Dependency requested, List<ResolvedDependency> dependencies, List<License> licenses, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, int depth, @Nullable List<GroupArtifact> effectiveExclusions) {
        this.repository = repository;
        this.gav = gav;
        this.requested = requested;
        this.dependencies = dependencies;
        this.licenses = licenses;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.depth = depth;
        this.effectiveExclusions = effectiveExclusions;
    }

    @Generated
    public static class ResolvedDependencyBuilder {
        @Generated
        private MavenRepository repository;
        @Generated
        private ResolvedGroupArtifactVersion gav;
        @Generated
        private Dependency requested;
        @Generated
        private boolean dependencies$set;
        @Generated
        private List<ResolvedDependency> dependencies$value;
        @Generated
        private boolean licenses$set;
        @Generated
        private List<License> licenses$value;
        @Generated
        private String type;
        @Generated
        private String classifier;
        @Generated
        private Boolean optional;
        @Generated
        private int depth;
        @Generated
        private List<GroupArtifact> effectiveExclusions;

        @Generated
        ResolvedDependencyBuilder() {
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder repository(@Nullable MavenRepository repository) {
            this.repository = repository;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder gav(ResolvedGroupArtifactVersion gav) {
            this.gav = gav;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder requested(Dependency requested) {
            this.requested = requested;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder dependencies(List<ResolvedDependency> dependencies) {
            this.dependencies$value = dependencies;
            this.dependencies$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder licenses(List<License> licenses) {
            this.licenses$value = licenses;
            this.licenses$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder optional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependencyBuilder effectiveExclusions(@Nullable List<GroupArtifact> effectiveExclusions) {
            this.effectiveExclusions = effectiveExclusions;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedDependency build() {
            List dependencies$value = this.dependencies$value;
            if (!this.dependencies$set) {
                dependencies$value = ResolvedDependency.$default$dependencies();
            }
            List licenses$value = this.licenses$value;
            if (!this.licenses$set) {
                licenses$value = ResolvedDependency.$default$licenses();
            }
            return new ResolvedDependency(this.repository, this.gav, this.requested, dependencies$value, licenses$value, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
        }

        @NonNull
        @Generated
        public String toString() {
            return "ResolvedDependency.ResolvedDependencyBuilder(repository=" + this.repository + ", gav=" + this.gav + ", requested=" + this.requested + ", dependencies$value=" + this.dependencies$value + ", licenses$value=" + this.licenses$value + ", type=" + this.type + ", classifier=" + this.classifier + ", optional=" + this.optional + ", depth=" + this.depth + ", effectiveExclusions=" + this.effectiveExclusions + ")";
        }
    }
}

