/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.openrewrite.Recipe;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.search.FindDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.tree.Xml;

public class RetainVersions {
    public static List<Recipe> plan(MavenVisitor<?> visitor, List<String> retainVersions) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (String gav : retainVersions) {
            String[] split = gav.split(":");
            String requestedRetainedGroupId = split[0];
            String requestedRetainedArtifactId = split[1];
            String requestedRetainedVersion = split.length == 3 ? split[2] : null;
            Set<Xml.Tag> existingDependencies = FindDependency.find((Xml.Document)visitor.getCursor().firstEnclosingOrThrow(Xml.Document.class), requestedRetainedGroupId, requestedRetainedArtifactId);
            if (requestedRetainedVersion != null && RetainVersions.noneMatch(existingDependencies, it -> it.getChild("version").isPresent())) {
                recipes.add(new ChangeDependencyGroupIdAndArtifactId(requestedRetainedGroupId, requestedRetainedArtifactId, null, null, requestedRetainedVersion, null, true, true));
                continue;
            }
            for (Xml.Tag existingDependency : existingDependencies) {
                String retainedGroupId = (String)existingDependency.getChildValue("groupId").orElseThrow(() -> new IllegalStateException("Dependency tag must have groupId"));
                String retainedArtifactId = (String)existingDependency.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("Dependency tag must have artifactId"));
                String retainedVersion = requestedRetainedVersion;
                if (retainedVersion == null) {
                    if (existingDependency.getChildValue("version").isPresent()) continue;
                    ResolvedManagedDependency managedDependency = visitor.findManagedDependency(retainedGroupId, retainedArtifactId);
                    retainedVersion = Objects.requireNonNull(managedDependency, String.format("'%s' from 'retainVersions' did not have a version specified and was not in the project's dependency management", gav)).getVersion();
                }
                recipes.add(new ChangeDependencyGroupIdAndArtifactId(retainedGroupId, retainedArtifactId, null, null, retainedVersion, null, true, true));
            }
        }
        return recipes;
    }

    private static <T> boolean noneMatch(Set<T> existingDependencies, Predicate<T> predicate) {
        for (T existingDependency : existingDependencies) {
            if (!predicate.test(existingDependency)) continue;
            return false;
        }
        return true;
    }
}

