/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.DependencyGraph;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class EffectiveDependencies
extends Recipe {
    private final transient DependencyGraph dependencyGraph = new DependencyGraph(this);
    @Option(displayName="Scope", description="Match dependencies with the specified scope", valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final String scope;

    public String getDisplayName() {
        return "Effective dependencies";
    }

    public String getDescription() {
        return "Emit the data of binary dependency relationships.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Scope aScope = Scope.fromName(this.scope);
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                String javaProject = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                String javaSourceSet = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("main");
                for (Map.Entry<Scope, List<ResolvedDependency>> scopedDependencies : mrr.getDependencies().entrySet()) {
                    if (!scopedDependencies.getKey().isInClasspathOf(aScope)) continue;
                    EffectiveDependencies.this.emitDependency(mrr.getPom().getGav(), scopedDependencies.getValue(), ctx, javaProject, javaSourceSet);
                }
                return document;
            }
        };
    }

    private void emitDependency(ResolvedGroupArtifactVersion gav, List<ResolvedDependency> dependencies, ExecutionContext ctx, String javaProject, String javaSourceSet) {
        for (ResolvedDependency d : dependencies) {
            this.dependencyGraph.insertRow(ctx, new DependencyGraph.Row(javaProject, javaSourceSet, String.format("%s:%s:%s", gav.getGroupId(), gav.getArtifactId(), gav.getVersion()), String.format("%s:%s:%s", d.getGav().getGroupId(), d.getGav().getArtifactId(), d.getGav().getVersion())));
            this.emitDependency(d.getGav(), d.getDependencies(), ctx, javaProject, javaSourceSet);
        }
    }

    public EffectiveDependencies(String scope) {
        this.scope = scope;
    }

    public DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "EffectiveDependencies(dependencyGraph=" + (Object)((Object)this.getDependencyGraph()) + ", scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveDependencies)) {
            return false;
        }
        EffectiveDependencies other = (EffectiveDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EffectiveDependencies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

