/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.utilities.RetainVersions;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends ScanningRecipe<Set<GroupArtifact>> {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    private static final Collection<String> implicitlyDefinedVersionProperties = Arrays.asList("${version}", "${project.version}", "${pom.version}", "${project.parent.version}");
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors)", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="This flag can be set to explicitly override a managed dependency's version. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;
    @Option(displayName="Retain versions", description="Accepts a list of GAVs. For each GAV, if it is a project direct dependency, and it is removed from dependency management after the changes from this recipe, then it will be retained with an explicit version. The version can be omitted from the GAV to use the old value from dependency management", example="com.jcraft:jsch", required=false)
    @Nullable
    private final List<String> retainVersions;

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group and (optionally) an artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    public Set<GroupArtifact> getInitialValue(ExecutionContext ctx) {
        return new HashSet<GroupArtifact>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<GroupArtifact> projectArtifacts) {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                ResolvedPom pom = this.getResolutionResult().getPom();
                projectArtifacts.add(new GroupArtifact(pom.getGroupId(), pom.getArtifactId()));
                return document;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<GroupArtifact> projectArtifacts) {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return new MavenIsoVisitor<ExecutionContext>(){
            private final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                try {
                    if (this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                        t = this.upgradeDependency(ctx, t);
                    } else if (this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                        if (this.isManagedDependencyImportTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                            this.doAfterVisit((TreeVisitor)new UpgradeDependencyManagementImportVisitor());
                        } else {
                            TreeVisitor<Xml, ExecutionContext> upgradeManagedDependency = this.upgradeManagedDependency(tag, ctx, t);
                            if (upgradeManagedDependency != null) {
                                this.doAfterVisit(upgradeManagedDependency);
                                this.maybeUpdateModel();
                            }
                        }
                    } else if (this.isPluginDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                        t = this.upgradePluginDependency(ctx, t);
                    }
                }
                catch (MavenDownloadingException e) {
                    return e.warn(t);
                }
                if (t != tag && this.PROJECT_MATCHER.matches(this.getCursor())) {
                    this.maybeUpdateModel();
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, true, null).getVisitor());
                }
                return t;
            }

            private Xml.Tag upgradeDependency(ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                String newerVersion;
                ResolvedDependency d = this.findDependency(t);
                if (d != null && d.getRepository() != null && (newerVersion = this.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), ctx)) != null) {
                    Optional version = t.getChild("version");
                    if (version.isPresent()) {
                        String requestedVersion = d.getRequested().getVersion();
                        if (requestedVersion != null && requestedVersion.startsWith("${") && !implicitlyDefinedVersionProperties.contains(requestedVersion)) {
                            this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor());
                        } else {
                            t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor().getParentOrThrow());
                        }
                    } else if (Boolean.TRUE.equals(UpgradeDependencyVersion.this.overrideManagedVersion)) {
                        ResolvedManagedDependency dm = this.findManagedDependency(t);
                        if (dm != null && dm.getRequested().getVersion() != null && dm.getRequested().getVersion().startsWith("${") && !implicitlyDefinedVersionProperties.contains(dm.getRequested().getVersion())) {
                            this.doAfterVisit(new ChangePropertyValue(dm.getRequested().getVersion().substring(2, dm.getRequested().getVersion().length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor());
                        } else {
                            Xml.Tag versionTag = Xml.Tag.build((String)("<version>" + newerVersion + "</version>"));
                            t = (Xml.Tag)new AddToTagVisitor(t, versionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)0, this.getCursor().getParent());
                        }
                    }
                }
                return t;
            }

            @Nullable
            private TreeVisitor<Xml, ExecutionContext> upgradeManagedDependency(Xml.Tag tag, ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                ResolvedManagedDependency managedDependency = this.findManagedDependency(t);
                if (managedDependency != null) {
                    String groupId = managedDependency.getGroupId();
                    String artifactId = managedDependency.getArtifactId();
                    String version = managedDependency.getVersion();
                    if (version != null && !projectArtifacts.contains(new GroupArtifact(groupId, artifactId)) && StringUtils.matchesGlob((String)groupId, (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)artifactId, (String)UpgradeDependencyVersion.this.artifactId)) {
                        return this.upgradeVersion(ctx, t, managedDependency.getRequested().getVersion(), groupId, artifactId, version);
                    }
                } else {
                    for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
                        ResolvedGroupArtifactVersion bom;
                        String artifactId;
                        String group;
                        if (dm.getBomGav() == null || projectArtifacts.contains(new GroupArtifact(group = this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId())), artifactId = this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse("")))) || !Objects.equals(group, (bom = dm.getBomGav()).getGroupId()) || !Objects.equals(artifactId, bom.getArtifactId())) continue;
                        return this.upgradeVersion(ctx, t, Objects.requireNonNull(dm.getRequestedBom()).getVersion(), bom.getGroupId(), bom.getArtifactId(), bom.getVersion());
                    }
                }
                return null;
            }

            private Xml.Tag upgradePluginDependency(ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                String newerVersion;
                String groupId = t.getChildValue("groupId").orElse(null);
                String artifactId = t.getChildValue("artifactId").orElse(null);
                String version = t.getChildValue("version").orElse(null);
                if (groupId != null && artifactId != null && version != null && (newerVersion = this.findNewerVersion(groupId, artifactId, this.resolveVersion(version), ctx)) != null) {
                    if (version.startsWith("${") && !implicitlyDefinedVersionProperties.contains(version)) {
                        this.doAfterVisit(new ChangePropertyValue(version.substring(2, version.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor());
                    } else {
                        Optional versionTag = t.getChild("version");
                        assert (versionTag.isPresent());
                        t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor().getParentOrThrow());
                    }
                }
                return t;
            }

            private String resolveVersion(String version) {
                if (version.startsWith("${") && !implicitlyDefinedVersionProperties.contains(version)) {
                    Map<String, String> properties = this.getResolutionResult().getPom().getProperties();
                    String property = version.substring(2, version.length() - 1);
                    return properties.getOrDefault(property, version);
                }
                return version;
            }

            @Nullable
            public TreeVisitor<Xml, ExecutionContext> upgradeVersion(ExecutionContext ctx, Xml.Tag tag, @Nullable String requestedVersion, String groupId, String artifactId, String version2) throws MavenDownloadingException {
                String newerVersion = this.findNewerVersion(groupId, artifactId, version2, ctx);
                if (newerVersion == null) {
                    return null;
                }
                if (requestedVersion != null && requestedVersion.startsWith("${")) {
                    return new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor();
                }
                Xml.Tag childVersionTag = tag.getChild("version").orElse(null);
                if (childVersionTag != null) {
                    return new ChangeTagValueVisitor(childVersionTag, newerVersion);
                }
                return null;
            }

            @Nullable
            private String findNewerVersion(String groupId, String artifactId, String version, ExecutionContext ctx) throws MavenDownloadingException {
                String finalVersion;
                String string = finalVersion = !Semver.isVersion((String)version) ? "0.0.0" : version;
                if (versionComparator instanceof LatestPatch && !versionComparator.isValid(finalVersion, finalVersion)) {
                    return null;
                }
                try {
                    MavenMetadata mavenMetadata = UpgradeDependencyVersion.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    ArrayList<String> versions = new ArrayList<String>();
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!versionComparator.isValid(finalVersion, v)) continue;
                        versions.add(v);
                    }
                    if (!Semver.isVersion((String)finalVersion) && !versions.isEmpty()) {
                        versions.sort((Comparator<String>)versionComparator);
                        return (String)versions.get(versions.size() - 1);
                    }
                    return versionComparator.upgrade(finalVersion, versions).orElse(null);
                }
                catch (IllegalStateException e) {
                    return null;
                }
            }

            class UpgradeDependencyManagementImportVisitor
            extends MavenIsoVisitor<ExecutionContext> {
                UpgradeDependencyManagementImportVisitor() {
                }

                @Override
                public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                    Xml.Tag t = super.visitTag(tag, ctx);
                    try {
                        TreeVisitor upgradeManagedDependency;
                        if (this.isManagedDependencyImportTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId) && (upgradeManagedDependency = this.upgradeManagedDependency(tag, ctx, t)) != null) {
                            this.retainVersions();
                            this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true, UpgradeDependencyVersion.this.retainVersions).getVisitor());
                            this.doAfterVisit(upgradeManagedDependency);
                            this.maybeUpdateModel();
                            this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true, null).getVisitor());
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(t);
                    }
                    return t;
                }

                private void retainVersions() {
                    for (Recipe retainVersionRecipe : RetainVersions.plan(this, UpgradeDependencyVersion.this.retainVersions == null ? Collections.emptyList() : UpgradeDependencyVersion.this.retainVersions)) {
                        this.doAfterVisit(retainVersionRecipe.getVisitor());
                    }
                }
            }
        };
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion, @Nullable List<String> retainVersions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.retainVersions = retainVersions;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Nullable
    public List<String> getRetainVersions() {
        return this.retainVersions;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ", retainVersions=" + this.getRetainVersions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        List<String> this$retainVersions = this.getRetainVersions();
        List<String> other$retainVersions = other.getRetainVersions();
        return !(this$retainVersions == null ? other$retainVersions != null : !((Object)this$retainVersions).equals(other$retainVersions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        List<String> $retainVersions = this.getRetainVersions();
        result = result * 59 + ($retainVersions == null ? 43 : ((Object)$retainVersions).hashCode());
        return result;
    }
}

