/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.internal.RequestedVersion;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public class RawMavenResolver {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private final NavigableMap<Scope, Map<GroupArtifact, RequestedVersion>> versionSelection;
    private final Queue<ResolutionTask> workQueue = new LinkedList<ResolutionTask>();
    private final Map<PartialTreeKey, Optional<Pom>> resolved = new HashMap<PartialTreeKey, Optional<Pom>>();
    private final Map<ResolutionTask, PartialMaven> partialResults = new HashMap<ResolutionTask, PartialMaven>();
    private final MavenPomDownloader downloader;
    private final Collection<String> activeProfiles;
    private final boolean resolveOptional;
    private final MavenExecutionContextView ctx;
    @Nullable
    private final Path projectDir;

    public RawMavenResolver(MavenPomDownloader downloader, Collection<String> activeProfiles, boolean resolveOptional, ExecutionContext ctx, @Nullable Path projectDir) {
        this.versionSelection = new TreeMap<Scope, Map<GroupArtifact, RequestedVersion>>();
        for (Scope scope : Scope.values()) {
            this.versionSelection.putIfAbsent(scope, new HashMap());
        }
        this.downloader = downloader;
        this.activeProfiles = activeProfiles;
        this.resolveOptional = resolveOptional;
        this.ctx = new MavenExecutionContextView(ctx);
        this.projectDir = projectDir;
    }

    @Nullable
    public Xml.Document resolve(RawMaven rawMaven, Map<String, String> effectiveProperties) {
        Pom pom = this.resolve(rawMaven, Scope.None, rawMaven.getPom().getVersion(), effectiveProperties, this.ctx.getRepositories());
        assert (pom != null);
        rawMaven.getSample().stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent parsing a Maven POM file").tag("file.type", "Maven")).register((MeterRegistry)Metrics.globalRegistry));
        return rawMaven.getDocument().withMarkers(rawMaven.getDocument().getMarkers().compute((Marker)pom, (old, n) -> n));
    }

    @Nullable
    public Pom resolve(RawMaven rawMaven, Scope scope, @Nullable String requestedVersion, Map<String, String> effectiveProperties, Collection<MavenRepository> repositories) {
        return this.resolve(rawMaven, scope, requestedVersion, effectiveProperties, null, repositories, null);
    }

    @Nullable
    private Pom resolve(RawMaven rawMaven, Scope scope, @Nullable String requestedVersion, Map<String, String> effectiveProperties, @Nullable PartialMaven projectPom, Collection<MavenRepository> repositories, @Nullable LinkedHashSet<PartialTreeKey> seenParentPoms) {
        ResolutionTask rootTask = new ResolutionTask(scope, rawMaven, Collections.emptySet(), false, null, null, requestedVersion, effectiveProperties, projectPom, repositories, seenParentPoms);
        this.workQueue.add(rootTask);
        while (!this.workQueue.isEmpty()) {
            this.processTask(this.workQueue.poll());
        }
        return this.assembleResults(rootTask, new Stack<ResolutionTask>());
    }

    private void processTask(ResolutionTask task) {
        RawMaven rawMaven = task.getRawMaven();
        if (this.partialResults.containsKey(task)) {
            return;
        }
        PartialMaven partialMaven = new PartialMaven(rawMaven.getPom());
        this.processProperties(task, partialMaven);
        this.processRepositories(partialMaven, task);
        this.processParent(task, partialMaven);
        this.processDependencyManagement(task, partialMaven);
        this.processLicenses(task, partialMaven);
        this.processDependencies(task, partialMaven);
        this.partialResults.put(task, partialMaven);
    }

    private void processProperties(ResolutionTask task, PartialMaven partialMaven) {
        task.getRawMaven().getActiveProperties(this.activeProfiles).forEach(task.getEffectiveProperties()::putIfAbsent);
        partialMaven.setProperties(task.getRawMaven().getPom().getProperties());
        partialMaven.setEffectiveProperties(task.getEffectiveProperties());
    }

    private void processDependencyManagement(ResolutionTask task, PartialMaven partialMaven) {
        RawPom pom = task.getRawMaven().getPom();
        ArrayList<DependencyManagementDependency> managedDependencies = new ArrayList<DependencyManagementDependency>();
        for (RawPom.Dependency d : pom.getActiveDependencyManagementDependencies(this.activeProfiles)) {
            if (d.getVersion() == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Problem with dependencyManagement section of %s:%s:%s. Unable to determine version of managed dependency %s:%s", pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), d.getGroupId(), d.getArtifactId()));
            }
            assert (d.getVersion() != null);
            String groupId = partialMaven.getRequiredValue(d.getGroupId());
            String artifactId = partialMaven.getRequiredValue(d.getArtifactId());
            String version = partialMaven.getValue(d.getVersion(), false);
            if (groupId == null || artifactId == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Problem with dependencyManagement section of %s:%s:%s. Unable to determine groupId or artifactId of managed dependency %s:%s.", pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), d.getGroupId(), d.getArtifactId()));
            }
            assert (groupId != null);
            assert (artifactId != null);
            if (Objects.equals(d.getType(), "pom") && Objects.equals(d.getScope(), "import")) {
                Pom maven;
                if (version == null) {
                    this.ctx.getOnError().accept(new MavenParsingException("Problem with dependencyManagement section of %s:%s:%s. Unable to determine version of managed dependency %s:%s.", pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), d.getGroupId(), d.getArtifactId()));
                    continue;
                }
                RawMaven rawMaven = this.downloader.download(groupId, artifactId, version, null, null, partialMaven.getRepositories(), (ExecutionContext)this.ctx);
                if (rawMaven == null || (maven = new RawMavenResolver(this.downloader, this.activeProfiles, this.resolveOptional, (ExecutionContext)this.ctx, this.projectDir).resolve(rawMaven, Scope.Compile, d.getVersion(), new HashMap<String, String>(), partialMaven.getRepositories())) == null) continue;
                managedDependencies.add(new DependencyManagementDependency.Imported(groupId, artifactId, version, d.getVersion(), maven));
                continue;
            }
            Scope scope = d.getScope() == null ? null : Scope.fromName(d.getScope());
            if (Scope.Invalid.equals((Object)scope)) continue;
            managedDependencies.add(new DependencyManagementDependency.Defined(groupId, artifactId, version, d.getVersion(), scope, d.getClassifier(), d.getExclusions()));
        }
        partialMaven.setDependencyManagement(new Pom.DependencyManagement(managedDependencies));
    }

    private void processDependencies(ResolutionTask task, PartialMaven partialMaven) {
        RawMaven rawMaven = task.getRawMaven();
        if (partialMaven.getParent() != null) {
            for (Pom.Dependency dependency : partialMaven.getParent().getDependencies()) {
                RequestedVersion requestedVersion = this.selectVersion(dependency.getScope(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                ((Map)this.versionSelection.get((Object)dependency.getScope())).put(new GroupArtifact(dependency.getGroupId(), dependency.getArtifactId()), requestedVersion);
            }
        }
        partialMaven.setDependencyTasks(rawMaven.getActiveDependencies(this.activeProfiles).stream().filter(dep -> rawMaven.isProjectPom() || this.resolveOptional || dep.getOptional() == null || dep.getOptional() == false).map(dep -> {
            Set<GroupArtifact> exclusions;
            Scope requestedScope;
            Scope effectiveScope;
            String last;
            String scope;
            String groupId = partialMaven.getRequiredValue(dep.getGroupId());
            String artifactId = partialMaven.getRequiredValue(dep.getArtifactId());
            RawPom includingPom = rawMaven.getPom();
            if (groupId == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Problem resolving dependency of %s:%s:%s. Unable to determine groupId.", includingPom.getGroupId(), includingPom.getArtifactId(), includingPom.getVersion()));
                return null;
            }
            if (artifactId == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Problem resolving dependency of %s:%s:%s. Unable to determine artifactId.", includingPom.getGroupId(), includingPom.getArtifactId(), includingPom.getVersion()));
                return null;
            }
            if (dep.getOptional() != null && dep.getOptional().booleanValue() && task.getProjectPom() != null) {
                return null;
            }
            int i = 0;
            String string = scope = dep.getScope() != null ? partialMaven.getRequiredValue(dep.getScope()) : null;
            if (scope == null) {
                do {
                    String partialMavenScope;
                    last = scope;
                    String result = null;
                    if (last != null && (partialMavenScope = partialMaven.getRequiredValue(last)) != null) {
                        result = partialMavenScope;
                    }
                    if (result == null && (result = partialMaven.getDependencyManagement().getManagedScope(groupId, artifactId)) == null && partialMaven.getParent() != null) {
                        result = partialMaven.getParent().getManagedScope(groupId, artifactId);
                    }
                    scope = result;
                } while (i++ < 2 || !Objects.equals(scope, last));
            }
            if ((effectiveScope = (requestedScope = Scope.fromName(scope)).transitiveOf(task.getScope())) == null || Scope.Invalid.equals((Object)effectiveScope)) {
                return null;
            }
            for (GroupArtifact e : task.getExclusions()) {
                try {
                    if (!dep.getGroupId().matches(e.getGroupId()) || !dep.getArtifactId().matches(e.getArtifactId())) continue;
                    return null;
                }
                catch (Exception exception) {
                    this.ctx.getOnError().accept(exception);
                    return null;
                }
            }
            String managedVersion = null;
            PartialMaven projectPom = task.getProjectPom();
            if (projectPom != null && (managedVersion = projectPom.getDependencyManagement().getManagedVersion(groupId, artifactId)) == null && projectPom.getParent() != null) {
                managedVersion = projectPom.getParent().getManagedVersion(groupId, artifactId);
            }
            do {
                Object partialMavenVersion;
                last = managedVersion;
                String result = null;
                if (last != null && (partialMavenVersion = partialMaven.getRequiredValue(last)) != null) {
                    result = partialMavenVersion;
                }
                if (result == null) {
                    partialMavenVersion = partialMaven.getDependencyManagement().getDependencies().iterator();
                    block5: while (partialMavenVersion.hasNext()) {
                        DependencyManagementDependency managed = (DependencyManagementDependency)partialMavenVersion.next();
                        for (DependencyDescriptor dependencyDescriptor : managed.getDependencies()) {
                            if (!groupId.equals(partialMaven.getRequiredValue(dependencyDescriptor.getGroupId())) || !artifactId.equals(partialMaven.getRequiredValue(dependencyDescriptor.getArtifactId()))) continue;
                            result = dependencyDescriptor.getVersion();
                            break block5;
                        }
                    }
                    if (result == null && partialMaven.getParent() != null) {
                        result = partialMaven.getParent().getManagedVersion(groupId, artifactId);
                    }
                }
                managedVersion = result;
            } while (i++ < 2 || !Objects.equals(managedVersion, last));
            String version = partialMaven.getValue(dep.getVersion(), false);
            managedVersion = partialMaven.getValue(managedVersion, false);
            if ((task.getProjectPom() != null || version == null) && managedVersion != null) {
                version = managedVersion;
            }
            if (version == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Failed to determine version for %s:%s. Initial value was %s. Including POM is at %s", groupId, artifactId, dep.getVersion(), rawMaven));
                return null;
            }
            RequestedVersion requestedVersion = this.selectVersion(effectiveScope, groupId, artifactId, version);
            ((Map)this.versionSelection.get((Object)effectiveScope)).put(new GroupArtifact(groupId, artifactId), requestedVersion);
            version = requestedVersion.resolve(this.downloader, partialMaven.getRepositories());
            if (version == null || version.contains("${")) {
                this.ctx.getOnError().accept(new MavenParsingException("Unable to download %s:%s:%s. Including POM is at %s", groupId, artifactId, version, rawMaven));
                return null;
            }
            RawMaven download = this.downloader.download(groupId, artifactId, version, null, rawMaven, partialMaven.getRepositories(), (ExecutionContext)this.ctx);
            if (download == null) {
                this.ctx.getOnError().accept(new MavenParsingException("Unable to download %s:%s:%s. Including POM is at %s", groupId, artifactId, version, rawMaven.getSourcePath()));
                return null;
            }
            if (dep.getExclusions() == null) {
                exclusions = task.getExclusions();
            } else {
                exclusions = new HashSet<GroupArtifact>(task.getExclusions());
                for (GroupArtifact ex : dep.getExclusions()) {
                    GroupArtifact groupArtifact = new GroupArtifact(partialMaven.getRequiredValue(ex.getGroupId()), partialMaven.getRequiredValue(ex.getArtifactId()));
                    GroupArtifact artifact = new GroupArtifact(groupArtifact.getGroupId() == null ? ".*" : groupArtifact.getGroupId().replace("*", ".*"), groupArtifact.getArtifactId() == null ? ".*" : groupArtifact.getArtifactId().replace("*", ".*"));
                    exclusions.add(artifact);
                }
            }
            ResolutionTask resolutionTask = new ResolutionTask(requestedScope, download, exclusions, dep.getOptional() != null && dep.getOptional() != false, dep.getClassifier(), dep.getType(), dep.getVersion(), new HashMap<String, String>(partialMaven.getEffectiveProperties()), task.getProjectPom() == null ? partialMaven : task.getProjectPom(), partialMaven.getRepositories(), task.getSeenParentPoms());
            if (!this.partialResults.containsKey(resolutionTask)) {
                this.workQueue.add(resolutionTask);
            }
            return resolutionTask;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void processParent(ResolutionTask task, PartialMaven partialMaven) {
        RawMaven rawMaven = task.getRawMaven();
        RawPom pom = rawMaven.getPom();
        if (pom.getParent() != null) {
            PartialTreeKey gav;
            RawPom.Parent rawParent = pom.getParent();
            LinkedHashSet<Object> parentPomSightings = task.getSeenParentPoms() == null ? new LinkedHashSet() : new LinkedHashSet<PartialTreeKey>(task.getSeenParentPoms());
            if (parentPomSightings.contains(gav = new PartialTreeKey(rawParent.getGroupId(), rawParent.getArtifactId(), rawParent.getVersion(), task.getExclusions()))) {
                this.ctx.getOnError().accept(new MavenParsingException("Cycle in parent poms detected: " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + " is its own parent by way of these poms:\n" + parentPomSightings.stream().map(it -> ((PartialTreeKey)it).groupId + ":" + it.getArtifactId() + ":" + it.getVersion()).collect(Collectors.joining("\n"))));
                return;
            }
            parentPomSightings.add(gav);
            Pom parent = null;
            RawMaven rawParentModel = this.downloader.download(rawParent.getGroupId(), rawParent.getArtifactId(), rawParent.getVersion(), rawParent.getRelativePath(), rawMaven, partialMaven.getRepositories(), (ExecutionContext)this.ctx);
            if (rawParentModel != null) {
                PartialTreeKey parentKey = new PartialTreeKey(rawParent.getGroupId(), rawParent.getArtifactId(), rawParent.getVersion(), task.getExclusions());
                Optional<Pom> maybeParent = this.resolved.get(parentKey);
                if (maybeParent == null) {
                    parent = new RawMavenResolver(this.downloader, this.activeProfiles, this.resolveOptional, (ExecutionContext)this.ctx, this.projectDir).resolve(rawParentModel, Scope.Compile, rawParent.getVersion(), partialMaven.getEffectiveProperties(), task.getProjectPom(), partialMaven.getRepositories(), parentPomSightings);
                    this.resolved.put(parentKey, Optional.ofNullable(parent));
                } else {
                    parent = maybeParent.orElse(null);
                }
            }
            partialMaven.setParent(parent);
        }
    }

    private void processRepositories(PartialMaven partialMaven, ResolutionTask task) {
        LinkedHashSet<MavenRepository> repositories = new LinkedHashSet<MavenRepository>();
        for (RawRepositories.Repository repo : task.getRawMaven().getPom().getActiveRepositories(this.activeProfiles)) {
            MavenRepository mapped = this.processRepository(partialMaven, repo);
            if (mapped == null) continue;
            mapped = MavenRepositoryMirror.apply(this.ctx.getMirrors(), mapped);
            mapped = MavenRepositoryCredentials.apply(this.ctx.getCredentials(), mapped);
            repositories.add(mapped);
        }
        repositories.addAll(task.getRepositories());
        partialMaven.setRepositories(repositories);
    }

    private void processLicenses(ResolutionTask task, PartialMaven partialMaven) {
        List<RawPom.License> licenses = task.getRawMaven().getPom().getInnerLicenses();
        ArrayList<Pom.License> list = new ArrayList<Pom.License>();
        for (RawPom.License license : licenses) {
            Pom.License fromName = Pom.License.fromName(license.getName());
            list.add(fromName);
        }
        partialMaven.setLicenses(list);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Pom assembleResults(ResolutionTask task, Stack<ResolutionTask> assemblyStack) {
        if (assemblyStack.contains(task)) {
            return null;
        }
        RawMaven rawMaven = task.getRawMaven();
        RawPom rawPom = rawMaven.getPom();
        PartialTreeKey taskKey = new PartialTreeKey(rawPom.getGroupId(), rawPom.getArtifactId(), rawPom.getVersion(), task.getExclusions());
        Optional<Pom> result = this.resolved.get(taskKey);
        Stack<ResolutionTask> nextAssemblyStack = new Stack<ResolutionTask>();
        nextAssemblyStack.addAll(assemblyStack);
        nextAssemblyStack.push(task);
        if (result == null) {
            PartialMaven partial = this.partialResults.get(task);
            if (partial != null) {
                void var12_26;
                void var11_18;
                String string;
                void var11_14;
                HashSet<GroupArtifact> exclusions = new HashSet<GroupArtifact>();
                for (ResolutionTask resolutionTask : assemblyStack) {
                    PartialMaven partialMaven = this.partialResults.get(resolutionTask);
                    if (partialMaven == null) continue;
                    for (ResolutionTask depTask : partialMaven.getDependencyTasks()) {
                        RawPom depTaskPom = depTask.getRawMaven().getPom();
                        RawPom taskPom = task.getRawMaven().getPom();
                        if (depTask.getExclusions().isEmpty() || depTaskPom.getGroupId() == null || !depTaskPom.getGroupId().equals(taskPom.getGroupId()) || !depTaskPom.getArtifactId().equals(taskPom.getArtifactId())) continue;
                        exclusions.addAll(depTask.getExclusions());
                    }
                }
                ArrayList<Pom.Dependency> dependencies = new ArrayList<Pom.Dependency>(partial.getDependencyTasks().size());
                block2: for (ResolutionTask resolutionTask : partial.getDependencyTasks()) {
                    RawPom depTaskPom = resolutionTask.getRawMaven().getPom();
                    for (GroupArtifact exclusion : exclusions) {
                        if (!exclusion.getGroupId().equals(depTaskPom.getGroupId()) || !exclusion.getArtifactId().equals(depTaskPom.getArtifactId())) continue;
                        continue block2;
                    }
                    boolean optional = resolutionTask.isOptional();
                    Pom resolved = this.assembleResults(resolutionTask, nextAssemblyStack);
                    if (resolved == null) continue;
                    dependencies.add(new Pom.Dependency(resolutionTask.getRawMaven().getRepository(), resolutionTask.getScope(), resolutionTask.getClassifier(), resolutionTask.getType(), optional, resolved, resolutionTask.getRequestedVersion(), resolutionTask.getExclusions()));
                }
                Pom pom = partial.getParent();
                while (var11_14 != null) {
                    for (Pom.Dependency ancestorDep : var11_14.getDependencies()) {
                        Scope scope = ancestorDep.getScope();
                        String groupId = ancestorDep.getGroupId();
                        String artifactId = ancestorDep.getArtifactId();
                        String conflictResolvedVersion = this.selectVersion(scope, groupId, artifactId, ancestorDep.getVersion()).resolve(this.downloader, task.getRepositories());
                        if (!ancestorDep.getVersion().equals(conflictResolvedVersion)) {
                            Pom conflictResolved;
                            assert (conflictResolvedVersion != null);
                            RawMaven conflictResolvedRaw = this.downloader.download(groupId, artifactId, conflictResolvedVersion, null, null, task.getRepositories(), (ExecutionContext)this.ctx);
                            Pom pom2 = conflictResolved = conflictResolvedRaw == null ? null : this.assembleResults(new ResolutionTask(scope, conflictResolvedRaw, ancestorDep.getExclusions(), ancestorDep.isOptional(), ancestorDep.getClassifier(), ancestorDep.getType(), ancestorDep.getRequestedVersion(), partial.effectiveProperties, task.getProjectPom(), task.getRepositories(), null), nextAssemblyStack);
                            if (conflictResolved == null) {
                                dependencies.add(ancestorDep);
                                continue;
                            }
                            dependencies.add(new Pom.Dependency(rawMaven.getRepository(), scope, ancestorDep.getClassifier(), ancestorDep.getType(), ancestorDep.isOptional(), conflictResolved, ancestorDep.getRequestedVersion(), ancestorDep.getExclusions()));
                            continue;
                        }
                        dependencies.add(ancestorDep);
                    }
                    Pom pom3 = var11_14.getParent();
                }
                String string2 = rawPom.getGroupId();
                if (string2 == null) {
                    String string3 = partial.getParent().getGroupId();
                }
                if ((string = rawPom.getVersion()) == null) {
                    String string4 = partial.getParent().getVersion();
                }
                result = Optional.of(new Pom(Tree.randomId(), (String)var11_18, rawPom.getArtifactId(), (String)var12_26, rawPom.getName(), rawPom.getDescription(), rawPom.getSnapshotVersion(), rawPom.getPackaging(), null, partial.getParent(), dependencies, partial.getDependencyManagement(), partial.getLicenses(), partial.getRepositories(), partial.getProperties(), partial.getEffectiveProperties()));
            } else {
                result = Optional.empty();
            }
            this.resolved.put(taskKey, result);
        }
        return result.orElse(null);
    }

    @Nullable
    private MavenRepository processRepository(PartialMaven partialMaven, @Nullable RawRepositories.Repository repo) {
        if (repo == null) {
            return null;
        }
        String url = partialMaven.getRequiredValue(repo.getUrl());
        return url == null ? null : this.processRepository(repo.withUrl(url));
    }

    @Nullable
    private MavenRepository processRepository(@Nullable RawRepositories.Repository repo) {
        if (repo == null) {
            return null;
        }
        try {
            return new MavenRepository(repo.getId(), URI.create(repo.getUrl().trim()), repo.getReleases() == null || repo.getReleases().isEnabled(), repo.getSnapshots() != null && repo.getSnapshots().isEnabled(), null, null);
        }
        catch (Throwable t) {
            this.ctx.getOnError().accept(new MavenParsingException("Invalid repository URL %s", t, repo.getUrl()));
            return null;
        }
    }

    private RequestedVersion selectVersion(@Nullable Scope scope, String groupId, String artifactId, String version) {
        GroupArtifact groupArtifact = new GroupArtifact(groupId, artifactId);
        if (scope == null) {
            return new RequestedVersion(groupArtifact, null, version);
        }
        RequestedVersion nearer = null;
        for (Map nearerInScope : this.versionSelection.headMap(scope, true).values()) {
            RequestedVersion requestedVersion = (RequestedVersion)nearerInScope.get(groupArtifact);
            if (requestedVersion == null) continue;
            nearer = requestedVersion;
            break;
        }
        return ((Map)this.versionSelection.get((Object)scope)).getOrDefault(groupArtifact, new RequestedVersion(groupArtifact, nearer, version));
    }

    public class PartialMaven {
        private final RawPom rawPom;
        private Pom parent;
        private Pom.DependencyManagement dependencyManagement;
        private Collection<ResolutionTask> dependencyTasks = Collections.emptyList();
        private Collection<Pom.License> licenses = Collections.emptyList();
        private Collection<MavenRepository> repositories = Collections.emptyList();
        private Map<String, String> properties = Collections.emptyMap();
        private Map<String, String> effectiveProperties = Collections.emptyMap();

        public List<MavenRepository> getRepositories() {
            ArrayList<MavenRepository> allRepositories = new ArrayList<MavenRepository>(this.repositories);
            for (Pom ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
                allRepositories.addAll(ancestor.getRepositories());
            }
            return allRepositories;
        }

        @Nullable
        public String getValue(@Nullable String v, boolean required) {
            if (v == null) {
                return null;
            }
            try {
                return placeholderHelper.replacePlaceholders(v, key -> {
                    if (key == null) {
                        return null;
                    }
                    switch (key) {
                        case "groupId": 
                        case "project.groupId": 
                        case "pom.groupId": {
                            String groupId = this.rawPom.getGroupId();
                            if (groupId != null) {
                                return groupId;
                            }
                            return this.parent == null ? null : this.parent.getGroupId();
                        }
                        case "project.parent.groupId": {
                            return this.parent != null ? this.parent.getGroupId() : null;
                        }
                        case "artifactId": 
                        case "project.artifactId": 
                        case "pom.artifactId": {
                            return this.rawPom.getArtifactId();
                        }
                        case "project.parent.artifactId": {
                            return this.parent == null ? null : this.parent.getArtifactId();
                        }
                        case "version": 
                        case "project.version": 
                        case "pom.version": {
                            String rawVersion = this.rawPom.getVersion();
                            if (rawVersion != null) {
                                return rawVersion;
                            }
                            return this.parent == null ? null : this.parent.getVersion();
                        }
                        case "project.parent.version": {
                            return this.parent != null ? this.parent.getVersion() : null;
                        }
                    }
                    String value = System.getProperty(key);
                    if (value != null) {
                        return value;
                    }
                    value = this.effectiveProperties.get(key);
                    if (value != null) {
                        return value;
                    }
                    if (required) {
                        RawMavenResolver.this.ctx.getOnError().accept(new MavenParsingException("Unable to resolve property %s. Including POM is at %s", v, this.rawPom));
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                if (required) {
                    RawMavenResolver.this.ctx.getOnError().accept(new MavenParsingException("Unable to resolve property %s. Including POM is at %s", v, this.rawPom));
                }
                return null;
            }
        }

        @Nullable
        public String getRequiredValue(@Nullable String v) {
            return this.getValue(v, true);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialMaven)) {
                return false;
            }
            PartialMaven other = (PartialMaven)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawPom this$rawPom = this.getRawPom();
            RawPom other$rawPom = other.getRawPom();
            return !(this$rawPom == null ? other$rawPom != null : !((Object)this$rawPom).equals(other$rawPom));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PartialMaven;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawPom $rawPom = this.getRawPom();
            result = result * 59 + ($rawPom == null ? 43 : ((Object)$rawPom).hashCode());
            return result;
        }

        public PartialMaven(RawPom rawPom) {
            this.rawPom = rawPom;
        }

        public RawPom getRawPom() {
            return this.rawPom;
        }

        public Pom getParent() {
            return this.parent;
        }

        public Pom.DependencyManagement getDependencyManagement() {
            return this.dependencyManagement;
        }

        public Collection<ResolutionTask> getDependencyTasks() {
            return this.dependencyTasks;
        }

        public Collection<Pom.License> getLicenses() {
            return this.licenses;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, String> getEffectiveProperties() {
            return this.effectiveProperties;
        }

        public void setParent(Pom parent) {
            this.parent = parent;
        }

        public void setDependencyManagement(Pom.DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
        }

        public void setDependencyTasks(Collection<ResolutionTask> dependencyTasks) {
            this.dependencyTasks = dependencyTasks;
        }

        public void setLicenses(Collection<Pom.License> licenses) {
            this.licenses = licenses;
        }

        public void setRepositories(Collection<MavenRepository> repositories) {
            this.repositories = repositories;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public void setEffectiveProperties(Map<String, String> effectiveProperties) {
            this.effectiveProperties = effectiveProperties;
        }
    }

    static final class PartialTreeKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<GroupArtifact> exclusions;

        public PartialTreeKey(String groupId, String artifactId, String version, Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.exclusions = exclusions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialTreeKey)) {
                return false;
            }
            PartialTreeKey other = (PartialTreeKey)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RawMavenResolver.PartialTreeKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", exclusions=" + this.getExclusions() + ")";
        }
    }

    public static final class ResolutionTask {
        private final Scope scope;
        private final RawMaven rawMaven;
        @Nullable
        private final Set<GroupArtifact> exclusions;
        private final boolean optional;
        @Nullable
        private final String classifier;
        private final String type;
        @Nullable
        private final String requestedVersion;
        private final Map<String, String> effectiveProperties;
        private final PartialMaven projectPom;
        private final Collection<MavenRepository> repositories;
        @Nullable
        private final LinkedHashSet<PartialTreeKey> seenParentPoms;

        public Set<GroupArtifact> getExclusions() {
            return this.exclusions == null ? Collections.emptySet() : this.exclusions;
        }

        public ResolutionTask(Scope scope, RawMaven rawMaven, @Nullable Set<GroupArtifact> exclusions, boolean optional, @Nullable String classifier, String type, @Nullable String requestedVersion, Map<String, String> effectiveProperties, PartialMaven projectPom, Collection<MavenRepository> repositories, @Nullable LinkedHashSet<PartialTreeKey> seenParentPoms) {
            this.scope = scope;
            this.rawMaven = rawMaven;
            this.exclusions = exclusions;
            this.optional = optional;
            this.classifier = classifier;
            this.type = type;
            this.requestedVersion = requestedVersion;
            this.effectiveProperties = effectiveProperties;
            this.projectPom = projectPom;
            this.repositories = repositories;
            this.seenParentPoms = seenParentPoms;
        }

        public Scope getScope() {
            return this.scope;
        }

        public RawMaven getRawMaven() {
            return this.rawMaven;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        public Map<String, String> getEffectiveProperties() {
            return this.effectiveProperties;
        }

        public PartialMaven getProjectPom() {
            return this.projectPom;
        }

        public Collection<MavenRepository> getRepositories() {
            return this.repositories;
        }

        @Nullable
        public LinkedHashSet<PartialTreeKey> getSeenParentPoms() {
            return this.seenParentPoms;
        }

        @NonNull
        public String toString() {
            return "RawMavenResolver.ResolutionTask(scope=" + (Object)((Object)this.getScope()) + ", rawMaven=" + this.getRawMaven() + ", exclusions=" + this.getExclusions() + ", optional=" + this.isOptional() + ", classifier=" + this.getClassifier() + ", type=" + this.getType() + ", requestedVersion=" + this.getRequestedVersion() + ", effectiveProperties=" + this.getEffectiveProperties() + ", projectPom=" + this.getProjectPom() + ", repositories=" + this.getRepositories() + ", seenParentPoms=" + this.getSeenParentPoms() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolutionTask)) {
                return false;
            }
            ResolutionTask other = (ResolutionTask)o;
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            RawMaven this$rawMaven = this.getRawMaven();
            RawMaven other$rawMaven = other.getRawMaven();
            if (this$rawMaven == null ? other$rawMaven != null : !((Object)this$rawMaven).equals(other$rawMaven)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            return !(this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            RawMaven $rawMaven = this.getRawMaven();
            result = result * 59 + ($rawMaven == null ? 43 : ((Object)$rawMaven).hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            return result;
        }
    }
}

