/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    private static final MavenRepository SUPER_POM_REPOSITORY = new MavenRepository("central", URI.create("https://repo.maven.apache.org/maven2"), true, false, true, null, null);
    private final MavenPomCache mavenPomCache;
    private final Map<Path, RawMaven> projectPoms;
    private final MavenExecutionContextView ctx;

    public MavenPomDownloader(MavenPomCache mavenPomCache, Map<Path, RawMaven> projectPoms, ExecutionContext ctx) {
        this.mavenPomCache = mavenPomCache;
        this.projectPoms = projectPoms;
        this.ctx = new MavenExecutionContextView(ctx);
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, Collection<MavenRepository> repositories) {
        Timer.Sample sample = Timer.start();
        return Stream.concat(repositories.stream().distinct(), Stream.of(SUPER_POM_REPOSITORY)).map(this::normalizeRepository).distinct().filter(Objects::nonNull).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("repo.id", repo.getUri().toString()).tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "metadata");
            try {
                CacheResult<MavenMetadata> result = this.mavenPomCache.computeMavenMetadata(repo.getUri(), groupId, artifactId, () -> this.downloadMetadata(groupId, artifactId, null, Collections.singletonList(repo)));
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).reduce(MavenMetadata.EMPTY, (m1, m2) -> {
            if (m1 == MavenMetadata.EMPTY) {
                if (m2 == MavenMetadata.EMPTY) {
                    return m1;
                }
                return m2;
            }
            if (m2 == MavenMetadata.EMPTY) {
                return m1;
            }
            return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), Collections.emptyList(), null));
        });
    }

    @Nullable
    public MavenMetadata downloadMetadata(String groupId, String artifactId, @Nullable String version, Collection<MavenRepository> repositories) {
        return repositories.stream().map(this::normalizeRepository).distinct().filter(Objects::nonNull).map(repo -> this.forceDownloadMetadata(groupId, artifactId, version, (MavenRepository)repo)).filter(Objects::nonNull).reduce(MavenMetadata.EMPTY, (m1, m2) -> {
            if (m1 == MavenMetadata.EMPTY) {
                if (m2 == MavenMetadata.EMPTY) {
                    return m1;
                }
                return m2;
            }
            if (m2 == MavenMetadata.EMPTY) {
                return m1;
            }
            return new MavenMetadata(new MavenMetadata.Versioning(Collections.emptyList(), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), null));
        });
    }

    @Nullable
    private MavenMetadata forceDownloadMetadata(String groupId, String artifactId, @Nullable String version, MavenRepository repo) {
        String uri = repo.getUri().toString() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + (version == null ? "" : version + '/') + "maven-metadata.xml";
        Request.Builder request = this.applyAuthenticationToRequest(repo, new Request.Builder().url(uri).get());
        try {
            Response response;
            block10: {
                MavenMetadata mavenMetadata;
                block11: {
                    response = (Response)sendRequest.apply((Object)request.build());
                    try {
                        if (!response.isSuccessful() || response.body() == null) break block10;
                        byte[] responseBody = response.body().bytes();
                        mavenMetadata = MavenMetadata.parse(responseBody);
                        if (response == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return mavenMetadata;
            }
            if (response != null) {
                response.close();
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    private Timer.Builder addTagsByResult(Timer.Builder timer, CacheResult<?> result) {
        switch (result.getState()) {
            case Cached: {
                timer = timer.tags(new String[]{"outcome", "cached", "exception", "none"});
                break;
            }
            case Unavailable: {
                timer = timer.tags(new String[]{"outcome", "unavailable", "exception", "none"});
                break;
            }
            case Updated: {
                timer = timer.tags(new String[]{"outcome", "downloaded", "exception", "none"});
            }
        }
        return timer;
    }

    @Nullable
    public RawMaven download(String groupId, String artifactId, String version, @Nullable String relativePath, @Nullable RawMaven containingPom, Collection<MavenRepository> repositories, ExecutionContext ctx) {
        Object maybeLocalPom;
        Path folderContainingPom;
        HashMap<MavenRepository, Exception> errors = new HashMap<MavenRepository, Exception>();
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(groupId, artifactId, version, repositories, ctx);
        if (versionMaybeDatedSnapshot == null) {
            return null;
        }
        Timer.Sample sample = Timer.start();
        RawMaven goodEnoughMatch = null;
        for (RawMaven projectPom : this.projectPoms.values()) {
            if (!groupId.equals(projectPom.getPom().getGroupId()) || !artifactId.equals(projectPom.getPom().getArtifactId())) continue;
            if (version.equals(projectPom.getPom().getVersion())) {
                return projectPom;
            }
            goodEnoughMatch = projectPom;
        }
        if (goodEnoughMatch != null) {
            return goodEnoughMatch;
        }
        if (containingPom != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && groupId.equals(((RawMaven)maybeLocalPom).getPom().getGroupId()) && artifactId.equals(((RawMaven)maybeLocalPom).getPom().getArtifactId()) && version.equals(((RawMaven)maybeLocalPom).getPom().getVersion())) {
            return maybeLocalPom;
        }
        List repos = Stream.concat(repositories.stream(), Stream.of(SUPER_POM_REPOSITORY)).map(this::normalizeRepository).filter(Objects::nonNull).distinct().filter(repo -> repo.acceptsVersion(version)).collect(Collectors.toList());
        for (MavenRepository repo2 : repos) {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("repo.id", repo2.getUri().toString()).tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "pom");
            try {
                CacheResult<RawMaven> result = this.mavenPomCache.computeMaven(repo2.getUri(), groupId, artifactId, versionMaybeDatedSnapshot, () -> {
                    String uri = URI.create(repo2.getUri().toString()) + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + versionMaybeDatedSnapshot + ".pom";
                    Request.Builder request = this.applyAuthenticationToRequest(repo2, new Request.Builder().url(uri).get());
                    try (Response response = (Response)sendRequest.apply((Object)request.build());){
                        int responseCode = response.code();
                        if (!response.isSuccessful() || response.body() == null) throw new MavenDownloadingException("HTTP response code: %d", responseCode, uri);
                        byte[] responseBody = response.body().bytes();
                        Path inputPath = Paths.get(groupId, artifactId, version);
                        RawMaven rawMaven = RawMaven.parse(new Parser.Input(inputPath, () -> new ByteArrayInputStream(responseBody), true), null, versionMaybeDatedSnapshot.equals(version) ? null : versionMaybeDatedSnapshot, ctx).withRepository(repo2);
                        return rawMaven;
                    }
                    catch (Throwable throwable) {
                        throw new MavenDownloadingException(throwable);
                    }
                });
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                if (result.getState() == CacheResult.State.Unavailable) continue;
                return result.getData();
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                errors.put(repo2, e);
            }
        }
        if (!errors.isEmpty()) {
            String errorText = "Unable to download dependency " + groupId + ":" + artifactId + ":" + version + " from any of these repositories: \n" + errors.entrySet().stream().map(entry -> "    Id: " + ((MavenRepository)entry.getKey()).getId() + ", URL: " + ((MavenRepository)entry.getKey()).getUri().toString() + ", cause: " + entry.getValue()).collect(Collectors.joining("\n"));
            ctx.getOnError().accept(new MavenDownloadingException(errorText));
        }
        return null;
    }

    @Nullable
    private String datedSnapshotVersion(String groupId, String artifactId, String version, Collection<MavenRepository> repositories, ExecutionContext ctx) {
        if (version.endsWith("-SNAPSHOT")) {
            for (GroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(groupId) || !pinnedSnapshotVersion.getArtifactId().equals(artifactId) || !pinnedSnapshotVersion.getVersion().equals(version)) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            MavenMetadata mavenMetadata = repositories.stream().map(this::normalizeRepository).filter(Objects::nonNull).distinct().filter(repo -> repo.acceptsVersion(version)).map(repo -> this.downloadMetadata(groupId, artifactId, version, Collections.singletonList(repo))).filter(Objects::nonNull).findFirst().orElse(null);
            if (mavenMetadata != null) {
                MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
                if (snapshot == null) {
                    return null;
                }
                return version.replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return version;
    }

    @Nullable
    protected MavenRepository normalizeRepository(MavenRepository originalRepository) {
        CacheResult<MavenRepository> result;
        try {
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            if (repository.isKnownToExist()) {
                return repository;
            }
            String originalUrl = repository.getUri().toString();
            result = this.mavenPomCache.computeRepository(repository, () -> {
                MavenRepository mavenRepository;
                block17: {
                    String httpsUri = repository.getUri().getScheme().equalsIgnoreCase("http") ? repository.getUri().toString().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri().toString();
                    Request.Builder request = this.applyAuthenticationToRequest(repository, new Request.Builder().url(httpsUri).get());
                    Response ignored = (Response)sendRequest.apply((Object)request.build());
                    try {
                        mavenRepository = repository.withUri(URI.create(httpsUri));
                        if (ignored == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            MavenRepository mavenRepository2;
                            block18: {
                                if (httpsUri.equals(originalUrl)) {
                                    return null;
                                }
                                Response ignored2 = (Response)sendRequest.apply((Object)request.url(originalUrl).build());
                                try {
                                    mavenRepository2 = new MavenRepository(repository.getId(), URI.create(originalUrl), repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                                    if (ignored2 == null) break block18;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        if (ignored2 != null) {
                                            try {
                                                ignored2.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable3.addSuppressed(throwable4);
                                            }
                                        }
                                        throw throwable3;
                                    }
                                    catch (Throwable t2) {
                                        return null;
                                    }
                                }
                                ignored2.close();
                            }
                            return mavenRepository2;
                        }
                    }
                    ignored.close();
                }
                return mavenRepository;
            });
        }
        catch (Exception e) {
            return null;
        }
        MavenRepository repo = result.getData();
        return repo == null ? null : this.applyAuthenticationToRepository(repo);
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(), repository);
    }

    private Request.Builder applyAuthenticationToRequest(MavenRepository repository, Request.Builder request) {
        if (repository.getUsername() != null && repository.getPassword() != null) {
            String credentials = Credentials.basic((String)repository.getUsername(), (String)repository.getPassword());
            request.header("Authorization", credentials);
        }
        return request;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(), repository);
    }
}

